/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.finspace.model.FinspaceResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateKxDatabaseResponse
extends FinspaceResponse
implements ToCopyableBuilder<Builder, CreateKxDatabaseResponse> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("databaseName").getter(CreateKxDatabaseResponse.getter(CreateKxDatabaseResponse::databaseName)).setter(CreateKxDatabaseResponse.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseName").build()}).build();
    private static final SdkField<String> DATABASE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("databaseArn").getter(CreateKxDatabaseResponse.getter(CreateKxDatabaseResponse::databaseArn)).setter(CreateKxDatabaseResponse.setter(Builder::databaseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseArn").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(CreateKxDatabaseResponse.getter(CreateKxDatabaseResponse::environmentId)).setter(CreateKxDatabaseResponse.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateKxDatabaseResponse.getter(CreateKxDatabaseResponse::description)).setter(CreateKxDatabaseResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdTimestamp").getter(CreateKxDatabaseResponse.getter(CreateKxDatabaseResponse::createdTimestamp)).setter(CreateKxDatabaseResponse.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTimestamp").getter(CreateKxDatabaseResponse.getter(CreateKxDatabaseResponse::lastModifiedTimestamp)).setter(CreateKxDatabaseResponse.setter(Builder::lastModifiedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD, DATABASE_ARN_FIELD, ENVIRONMENT_ID_FIELD, DESCRIPTION_FIELD, CREATED_TIMESTAMP_FIELD, LAST_MODIFIED_TIMESTAMP_FIELD));
    private final String databaseName;
    private final String databaseArn;
    private final String environmentId;
    private final String description;
    private final Instant createdTimestamp;
    private final Instant lastModifiedTimestamp;

    private CreateKxDatabaseResponse(BuilderImpl builder) {
        super(builder);
        this.databaseName = builder.databaseName;
        this.databaseArn = builder.databaseArn;
        this.environmentId = builder.environmentId;
        this.description = builder.description;
        this.createdTimestamp = builder.createdTimestamp;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String databaseArn() {
        return this.databaseArn;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final String description() {
        return this.description;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant lastModifiedTimestamp() {
        return this.lastModifiedTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKxDatabaseResponse)) {
            return false;
        }
        CreateKxDatabaseResponse other = (CreateKxDatabaseResponse)((Object)obj);
        return Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.databaseArn(), other.databaseArn()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.lastModifiedTimestamp(), other.lastModifiedTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"CreateKxDatabaseResponse").add("DatabaseName", (Object)this.databaseName()).add("DatabaseArn", (Object)this.databaseArn()).add("EnvironmentId", (Object)this.environmentId()).add("Description", (Object)this.description()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("LastModifiedTimestamp", (Object)this.lastModifiedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "databaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "databaseArn": {
                return Optional.ofNullable(clazz.cast(this.databaseArn()));
            }
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "createdTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "lastModifiedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateKxDatabaseResponse, T> g) {
        return obj -> g.apply((CreateKxDatabaseResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceResponse.BuilderImpl
    implements Builder {
        private String databaseName;
        private String databaseArn;
        private String environmentId;
        private String description;
        private Instant createdTimestamp;
        private Instant lastModifiedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKxDatabaseResponse model) {
            super(model);
            this.databaseName(model.databaseName);
            this.databaseArn(model.databaseArn);
            this.environmentId(model.environmentId);
            this.description(model.description);
            this.createdTimestamp(model.createdTimestamp);
            this.lastModifiedTimestamp(model.lastModifiedTimestamp);
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getDatabaseArn() {
            return this.databaseArn;
        }

        public final void setDatabaseArn(String databaseArn) {
            this.databaseArn = databaseArn;
        }

        @Override
        public final Builder databaseArn(String databaseArn) {
            this.databaseArn = databaseArn;
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getLastModifiedTimestamp() {
            return this.lastModifiedTimestamp;
        }

        public final void setLastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        @Override
        public CreateKxDatabaseResponse build() {
            return new CreateKxDatabaseResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FinspaceResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateKxDatabaseResponse> {
        public Builder databaseName(String var1);

        public Builder databaseArn(String var1);

        public Builder environmentId(String var1);

        public Builder description(String var1);

        public Builder createdTimestamp(Instant var1);

        public Builder lastModifiedTimestamp(Instant var1);
    }
}

