/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.finspace.FinspaceClient;
import software.amazon.awssdk.services.finspace.internal.UserAgentUtils;
import software.amazon.awssdk.services.finspace.model.ListKxDataviewsRequest;
import software.amazon.awssdk.services.finspace.model.ListKxDataviewsResponse;

public class ListKxDataviewsIterable
implements SdkIterable<ListKxDataviewsResponse> {
    private final FinspaceClient client;
    private final ListKxDataviewsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListKxDataviewsIterable(FinspaceClient client, ListKxDataviewsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListKxDataviewsResponseFetcher();
    }

    public Iterator<ListKxDataviewsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListKxDataviewsResponseFetcher
    implements SyncPageFetcher<ListKxDataviewsResponse> {
        private ListKxDataviewsResponseFetcher() {
        }

        public boolean hasNextPage(ListKxDataviewsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListKxDataviewsResponse nextPage(ListKxDataviewsResponse previousPage) {
            if (previousPage == null) {
                return ListKxDataviewsIterable.this.client.listKxDataviews(ListKxDataviewsIterable.this.firstRequest);
            }
            return ListKxDataviewsIterable.this.client.listKxDataviews((ListKxDataviewsRequest)((Object)ListKxDataviewsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

