/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KxNode
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KxNode> {
    private static final SdkField<String> NODE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nodeId").getter(KxNode.getter(KxNode::nodeId)).setter(KxNode.setter(Builder::nodeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeId").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZoneId").getter(KxNode.getter(KxNode::availabilityZoneId)).setter(KxNode.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneId").build()}).build();
    private static final SdkField<Instant> LAUNCH_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("launchTime").getter(KxNode.getter(KxNode::launchTime)).setter(KxNode.setter(Builder::launchTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_ID_FIELD, AVAILABILITY_ZONE_ID_FIELD, LAUNCH_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String nodeId;
    private final String availabilityZoneId;
    private final Instant launchTime;

    private KxNode(BuilderImpl builder) {
        this.nodeId = builder.nodeId;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.launchTime = builder.launchTime;
    }

    public final String nodeId() {
        return this.nodeId;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public final Instant launchTime() {
        return this.launchTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KxNode)) {
            return false;
        }
        KxNode other = (KxNode)obj;
        return Objects.equals(this.nodeId(), other.nodeId()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && Objects.equals(this.launchTime(), other.launchTime());
    }

    public final String toString() {
        return ToString.builder((String)"KxNode").add("NodeId", (Object)this.nodeId()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("LaunchTime", (Object)this.launchTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nodeId": {
                return Optional.ofNullable(clazz.cast(this.nodeId()));
            }
            case "availabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "launchTime": {
                return Optional.ofNullable(clazz.cast(this.launchTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KxNode, T> g) {
        return obj -> g.apply((KxNode)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String nodeId;
        private String availabilityZoneId;
        private Instant launchTime;

        private BuilderImpl() {
        }

        private BuilderImpl(KxNode model) {
            this.nodeId(model.nodeId);
            this.availabilityZoneId(model.availabilityZoneId);
            this.launchTime(model.launchTime);
        }

        public final String getNodeId() {
            return this.nodeId;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final Instant getLaunchTime() {
            return this.launchTime;
        }

        public final void setLaunchTime(Instant launchTime) {
            this.launchTime = launchTime;
        }

        @Override
        public final Builder launchTime(Instant launchTime) {
            this.launchTime = launchTime;
            return this;
        }

        public KxNode build() {
            return new KxNode(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KxNode> {
        public Builder nodeId(String var1);

        public Builder availabilityZoneId(String var1);

        public Builder launchTime(Instant var1);
    }
}

