/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DnsStatus {
    NONE("NONE"),
    UPDATE_REQUESTED("UPDATE_REQUESTED"),
    UPDATING("UPDATING"),
    FAILED_UPDATE("FAILED_UPDATE"),
    SUCCESSFULLY_UPDATED("SUCCESSFULLY_UPDATED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DnsStatus> VALUE_MAP;
    private final String value;

    private DnsStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DnsStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DnsStatus> knownValues() {
        EnumSet<DnsStatus> knownValues = EnumSet.allOf(DnsStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DnsStatus.class, DnsStatus::toString);
    }
}

