/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ErrorDetails {
    THE_INPUTS_TO_THIS_REQUEST_ARE_INVALID("The inputs to this request are invalid."),

    SERVICE_LIMITS_HAVE_BEEN_EXCEEDED("Service limits have been exceeded."),

    MISSING_REQUIRED_PERMISSION_TO_PERFORM_THIS_REQUEST("Missing required permission to perform this request."),

    ONE_OR_MORE_INPUTS_TO_THIS_REQUEST_WERE_NOT_FOUND("One or more inputs to this request were not found."),

    THE_SYSTEM_TEMPORARILY_LACKS_SUFFICIENT_RESOURCES_TO_PROCESS_THE_REQUEST(
            "The system temporarily lacks sufficient resources to process the request."),

    AN_INTERNAL_ERROR_HAS_OCCURRED("An internal error has occurred."),

    CANCELLED("Cancelled"),

    A_USER_RECOVERABLE_ERROR_HAS_OCCURRED("A user recoverable error has occurred"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ErrorDetails> VALUE_MAP = EnumUtils.uniqueIndex(ErrorDetails.class, ErrorDetails::toString);

    private final String value;

    private ErrorDetails(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ErrorDetails corresponding to the value
     */
    public static ErrorDetails fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ErrorDetails}s
     */
    public static Set<ErrorDetails> knownValues() {
        Set<ErrorDetails> knownValues = EnumSet.allOf(ErrorDetails.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
