/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.finspace.DefaultFinspaceAsyncClient;
import software.amazon.awssdk.services.finspace.DefaultFinspaceBaseClientBuilder;
import software.amazon.awssdk.services.finspace.FinspaceAsyncClient;
import software.amazon.awssdk.services.finspace.FinspaceAsyncClientBuilder;
import software.amazon.awssdk.services.finspace.FinspaceServiceClientConfiguration;
import software.amazon.awssdk.services.finspace.endpoints.FinspaceEndpointProvider;

@SdkInternalApi
final class DefaultFinspaceAsyncClientBuilder
extends DefaultFinspaceBaseClientBuilder<FinspaceAsyncClientBuilder, FinspaceAsyncClient>
implements FinspaceAsyncClientBuilder {
    DefaultFinspaceAsyncClientBuilder() {
    }

    @Override
    public DefaultFinspaceAsyncClientBuilder endpointProvider(FinspaceEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final FinspaceAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultFinspaceAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        FinspaceServiceClientConfiguration serviceClientConfiguration = FinspaceServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultFinspaceAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

