/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.finspace.FinspaceClient;
import software.amazon.awssdk.services.finspace.FinspaceServiceClientConfiguration;
import software.amazon.awssdk.services.finspace.model.AccessDeniedException;
import software.amazon.awssdk.services.finspace.model.ConflictException;
import software.amazon.awssdk.services.finspace.model.CreateEnvironmentRequest;
import software.amazon.awssdk.services.finspace.model.CreateEnvironmentResponse;
import software.amazon.awssdk.services.finspace.model.CreateKxChangesetRequest;
import software.amazon.awssdk.services.finspace.model.CreateKxChangesetResponse;
import software.amazon.awssdk.services.finspace.model.CreateKxClusterRequest;
import software.amazon.awssdk.services.finspace.model.CreateKxClusterResponse;
import software.amazon.awssdk.services.finspace.model.CreateKxDatabaseRequest;
import software.amazon.awssdk.services.finspace.model.CreateKxDatabaseResponse;
import software.amazon.awssdk.services.finspace.model.CreateKxEnvironmentRequest;
import software.amazon.awssdk.services.finspace.model.CreateKxEnvironmentResponse;
import software.amazon.awssdk.services.finspace.model.CreateKxUserRequest;
import software.amazon.awssdk.services.finspace.model.CreateKxUserResponse;
import software.amazon.awssdk.services.finspace.model.DeleteEnvironmentRequest;
import software.amazon.awssdk.services.finspace.model.DeleteEnvironmentResponse;
import software.amazon.awssdk.services.finspace.model.DeleteKxClusterRequest;
import software.amazon.awssdk.services.finspace.model.DeleteKxClusterResponse;
import software.amazon.awssdk.services.finspace.model.DeleteKxDatabaseRequest;
import software.amazon.awssdk.services.finspace.model.DeleteKxDatabaseResponse;
import software.amazon.awssdk.services.finspace.model.DeleteKxEnvironmentRequest;
import software.amazon.awssdk.services.finspace.model.DeleteKxEnvironmentResponse;
import software.amazon.awssdk.services.finspace.model.DeleteKxUserRequest;
import software.amazon.awssdk.services.finspace.model.DeleteKxUserResponse;
import software.amazon.awssdk.services.finspace.model.FinspaceException;
import software.amazon.awssdk.services.finspace.model.FinspaceRequest;
import software.amazon.awssdk.services.finspace.model.GetEnvironmentRequest;
import software.amazon.awssdk.services.finspace.model.GetEnvironmentResponse;
import software.amazon.awssdk.services.finspace.model.GetKxChangesetRequest;
import software.amazon.awssdk.services.finspace.model.GetKxChangesetResponse;
import software.amazon.awssdk.services.finspace.model.GetKxClusterRequest;
import software.amazon.awssdk.services.finspace.model.GetKxClusterResponse;
import software.amazon.awssdk.services.finspace.model.GetKxConnectionStringRequest;
import software.amazon.awssdk.services.finspace.model.GetKxConnectionStringResponse;
import software.amazon.awssdk.services.finspace.model.GetKxDatabaseRequest;
import software.amazon.awssdk.services.finspace.model.GetKxDatabaseResponse;
import software.amazon.awssdk.services.finspace.model.GetKxEnvironmentRequest;
import software.amazon.awssdk.services.finspace.model.GetKxEnvironmentResponse;
import software.amazon.awssdk.services.finspace.model.GetKxUserRequest;
import software.amazon.awssdk.services.finspace.model.GetKxUserResponse;
import software.amazon.awssdk.services.finspace.model.InternalServerException;
import software.amazon.awssdk.services.finspace.model.InvalidRequestException;
import software.amazon.awssdk.services.finspace.model.LimitExceededException;
import software.amazon.awssdk.services.finspace.model.ListEnvironmentsRequest;
import software.amazon.awssdk.services.finspace.model.ListEnvironmentsResponse;
import software.amazon.awssdk.services.finspace.model.ListKxChangesetsRequest;
import software.amazon.awssdk.services.finspace.model.ListKxChangesetsResponse;
import software.amazon.awssdk.services.finspace.model.ListKxClusterNodesRequest;
import software.amazon.awssdk.services.finspace.model.ListKxClusterNodesResponse;
import software.amazon.awssdk.services.finspace.model.ListKxClustersRequest;
import software.amazon.awssdk.services.finspace.model.ListKxClustersResponse;
import software.amazon.awssdk.services.finspace.model.ListKxDatabasesRequest;
import software.amazon.awssdk.services.finspace.model.ListKxDatabasesResponse;
import software.amazon.awssdk.services.finspace.model.ListKxEnvironmentsRequest;
import software.amazon.awssdk.services.finspace.model.ListKxEnvironmentsResponse;
import software.amazon.awssdk.services.finspace.model.ListKxUsersRequest;
import software.amazon.awssdk.services.finspace.model.ListKxUsersResponse;
import software.amazon.awssdk.services.finspace.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.finspace.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.finspace.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.finspace.model.ResourceNotFoundException;
import software.amazon.awssdk.services.finspace.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.finspace.model.TagResourceRequest;
import software.amazon.awssdk.services.finspace.model.TagResourceResponse;
import software.amazon.awssdk.services.finspace.model.ThrottlingException;
import software.amazon.awssdk.services.finspace.model.UntagResourceRequest;
import software.amazon.awssdk.services.finspace.model.UntagResourceResponse;
import software.amazon.awssdk.services.finspace.model.UpdateEnvironmentRequest;
import software.amazon.awssdk.services.finspace.model.UpdateEnvironmentResponse;
import software.amazon.awssdk.services.finspace.model.UpdateKxClusterDatabasesRequest;
import software.amazon.awssdk.services.finspace.model.UpdateKxClusterDatabasesResponse;
import software.amazon.awssdk.services.finspace.model.UpdateKxDatabaseRequest;
import software.amazon.awssdk.services.finspace.model.UpdateKxDatabaseResponse;
import software.amazon.awssdk.services.finspace.model.UpdateKxEnvironmentNetworkRequest;
import software.amazon.awssdk.services.finspace.model.UpdateKxEnvironmentNetworkResponse;
import software.amazon.awssdk.services.finspace.model.UpdateKxEnvironmentRequest;
import software.amazon.awssdk.services.finspace.model.UpdateKxEnvironmentResponse;
import software.amazon.awssdk.services.finspace.model.UpdateKxUserRequest;
import software.amazon.awssdk.services.finspace.model.UpdateKxUserResponse;
import software.amazon.awssdk.services.finspace.model.ValidationException;
import software.amazon.awssdk.services.finspace.paginators.ListKxChangesetsIterable;
import software.amazon.awssdk.services.finspace.paginators.ListKxClusterNodesIterable;
import software.amazon.awssdk.services.finspace.paginators.ListKxDatabasesIterable;
import software.amazon.awssdk.services.finspace.paginators.ListKxEnvironmentsIterable;
import software.amazon.awssdk.services.finspace.transform.CreateEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.finspace.transform.CreateKxChangesetRequestMarshaller;
import software.amazon.awssdk.services.finspace.transform.CreateKxClusterRequestMarshaller;
import software.amazon.awssdk.services.finspace.transform.CreateKxDatabaseRequestMarshaller;
import software.amazon.awssdk.services.finspace.transform.CreateKxEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.finspace.transform.CreateKxUserRequestMarshaller;
import software.amazon.awssdk.services.finspace.transform.DeleteEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.finspace.transform.DeleteKxClusterRequestMarshaller;
import software.amazon.awssdk.services.finspace.transform.DeleteKxDatabaseRequestMarshaller;
import software.amazon.awssdk.services.finspace.transform.DeleteKxEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.finspace.transform.DeleteKxUserRequestMarshaller;
import software.amazon.awssdk.services.finspace.transform.GetEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.finspace.transform.GetKxChangesetRequestMarshaller;
import software.amazon.awssdk.services.finspace.transform.GetKxClusterRequestMarshaller;
import software.amazon.awssdk.services.finspace.transform.GetKxConnectionStringRequestMarshaller;
import software.amazon.awssdk.services.finspace.transform.GetKxDatabaseRequestMarshaller;
import software.amazon.awssdk.services.finspace.transform.GetKxEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.finspace.transform.GetKxUserRequestMarshaller;
import software.amazon.awssdk.services.finspace.transform.ListEnvironmentsRequestMarshaller;
import software.amazon.awssdk.services.finspace.transform.ListKxChangesetsRequestMarshaller;
import software.amazon.awssdk.services.finspace.transform.ListKxClusterNodesRequestMarshaller;
import software.amazon.awssdk.services.finspace.transform.ListKxClustersRequestMarshaller;
import software.amazon.awssdk.services.finspace.transform.ListKxDatabasesRequestMarshaller;
import software.amazon.awssdk.services.finspace.transform.ListKxEnvironmentsRequestMarshaller;
import software.amazon.awssdk.services.finspace.transform.ListKxUsersRequestMarshaller;
import software.amazon.awssdk.services.finspace.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.finspace.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.finspace.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.finspace.transform.UpdateEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.finspace.transform.UpdateKxClusterDatabasesRequestMarshaller;
import software.amazon.awssdk.services.finspace.transform.UpdateKxDatabaseRequestMarshaller;
import software.amazon.awssdk.services.finspace.transform.UpdateKxEnvironmentNetworkRequestMarshaller;
import software.amazon.awssdk.services.finspace.transform.UpdateKxEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.finspace.transform.UpdateKxUserRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultFinspaceClient
implements FinspaceClient {
    private static final Logger log = Logger.loggerFor(DefaultFinspaceClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final FinspaceServiceClientConfiguration serviceClientConfiguration;

    protected DefaultFinspaceClient(FinspaceServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateEnvironmentResponse createEnvironment(CreateEnvironmentRequest createEnvironmentRequest) throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException, LimitExceededException, AwsServiceException, SdkClientException, FinspaceException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEnvironmentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFinspaceClient.resolveMetricPublishers(this.clientConfiguration, createEnvironmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"finspace");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEnvironment");
            CreateEnvironmentResponse createEnvironmentResponse = (CreateEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEnvironment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createEnvironmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateEnvironmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createEnvironmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFinspaceClient.lambda$createEnvironment$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateKxChangesetResponse createKxChangeset(CreateKxChangesetRequest createKxChangesetRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, ConflictException, LimitExceededException, AwsServiceException, SdkClientException, FinspaceException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateKxChangesetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFinspaceClient.resolveMetricPublishers(this.clientConfiguration, createKxChangesetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"finspace");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateKxChangeset");
            CreateKxChangesetResponse createKxChangesetResponse = (CreateKxChangesetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateKxChangeset").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createKxChangesetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateKxChangesetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createKxChangesetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFinspaceClient.lambda$createKxChangeset$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateKxClusterResponse createKxCluster(CreateKxClusterRequest createKxClusterRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, LimitExceededException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateKxClusterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFinspaceClient.resolveMetricPublishers(this.clientConfiguration, createKxClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"finspace");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateKxCluster");
            CreateKxClusterResponse createKxClusterResponse = (CreateKxClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateKxCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createKxClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateKxClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createKxClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFinspaceClient.lambda$createKxCluster$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateKxDatabaseResponse createKxDatabase(CreateKxDatabaseRequest createKxDatabaseRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, ConflictException, ResourceAlreadyExistsException, ResourceNotFoundException, LimitExceededException, AwsServiceException, SdkClientException, FinspaceException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateKxDatabaseResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFinspaceClient.resolveMetricPublishers(this.clientConfiguration, createKxDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"finspace");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateKxDatabase");
            CreateKxDatabaseResponse createKxDatabaseResponse = (CreateKxDatabaseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateKxDatabase").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createKxDatabaseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateKxDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createKxDatabaseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFinspaceClient.lambda$createKxDatabase$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateKxEnvironmentResponse createKxEnvironment(CreateKxEnvironmentRequest createKxEnvironmentRequest) throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException, LimitExceededException, ConflictException, AwsServiceException, SdkClientException, FinspaceException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateKxEnvironmentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFinspaceClient.resolveMetricPublishers(this.clientConfiguration, createKxEnvironmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"finspace");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateKxEnvironment");
            CreateKxEnvironmentResponse createKxEnvironmentResponse = (CreateKxEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateKxEnvironment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createKxEnvironmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateKxEnvironmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createKxEnvironmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFinspaceClient.lambda$createKxEnvironment$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateKxUserResponse createKxUser(CreateKxUserRequest createKxUserRequest) throws ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, ValidationException, ResourceAlreadyExistsException, LimitExceededException, ConflictException, AwsServiceException, SdkClientException, FinspaceException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateKxUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFinspaceClient.resolveMetricPublishers(this.clientConfiguration, createKxUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"finspace");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateKxUser");
            CreateKxUserResponse createKxUserResponse = (CreateKxUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateKxUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createKxUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateKxUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createKxUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFinspaceClient.lambda$createKxUser$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteEnvironmentResponse deleteEnvironment(DeleteEnvironmentRequest deleteEnvironmentRequest) throws ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, FinspaceException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEnvironmentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFinspaceClient.resolveMetricPublishers(this.clientConfiguration, deleteEnvironmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"finspace");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEnvironment");
            DeleteEnvironmentResponse deleteEnvironmentResponse = (DeleteEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEnvironment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEnvironmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteEnvironmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteEnvironmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFinspaceClient.lambda$deleteEnvironment$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteKxClusterResponse deleteKxCluster(DeleteKxClusterRequest deleteKxClusterRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, LimitExceededException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteKxClusterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFinspaceClient.resolveMetricPublishers(this.clientConfiguration, deleteKxClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"finspace");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteKxCluster");
            DeleteKxClusterResponse deleteKxClusterResponse = (DeleteKxClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteKxCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteKxClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteKxClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteKxClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFinspaceClient.lambda$deleteKxCluster$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteKxDatabaseResponse deleteKxDatabase(DeleteKxDatabaseRequest deleteKxDatabaseRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, FinspaceException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteKxDatabaseResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFinspaceClient.resolveMetricPublishers(this.clientConfiguration, deleteKxDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"finspace");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteKxDatabase");
            DeleteKxDatabaseResponse deleteKxDatabaseResponse = (DeleteKxDatabaseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteKxDatabase").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteKxDatabaseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteKxDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteKxDatabaseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFinspaceClient.lambda$deleteKxDatabase$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteKxEnvironmentResponse deleteKxEnvironment(DeleteKxEnvironmentRequest deleteKxEnvironmentRequest) throws ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, FinspaceException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteKxEnvironmentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFinspaceClient.resolveMetricPublishers(this.clientConfiguration, deleteKxEnvironmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"finspace");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteKxEnvironment");
            DeleteKxEnvironmentResponse deleteKxEnvironmentResponse = (DeleteKxEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteKxEnvironment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteKxEnvironmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteKxEnvironmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteKxEnvironmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFinspaceClient.lambda$deleteKxEnvironment$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteKxUserResponse deleteKxUser(DeleteKxUserRequest deleteKxUserRequest) throws InternalServerException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, FinspaceException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteKxUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFinspaceClient.resolveMetricPublishers(this.clientConfiguration, deleteKxUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"finspace");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteKxUser");
            DeleteKxUserResponse deleteKxUserResponse = (DeleteKxUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteKxUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteKxUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteKxUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteKxUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFinspaceClient.lambda$deleteKxUser$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEnvironmentResponse getEnvironment(GetEnvironmentRequest getEnvironmentRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, FinspaceException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEnvironmentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFinspaceClient.resolveMetricPublishers(this.clientConfiguration, getEnvironmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"finspace");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEnvironment");
            GetEnvironmentResponse getEnvironmentResponse = (GetEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEnvironment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getEnvironmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetEnvironmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getEnvironmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFinspaceClient.lambda$getEnvironment$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetKxChangesetResponse getKxChangeset(GetKxChangesetRequest getKxChangesetRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetKxChangesetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFinspaceClient.resolveMetricPublishers(this.clientConfiguration, getKxChangesetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"finspace");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetKxChangeset");
            GetKxChangesetResponse getKxChangesetResponse = (GetKxChangesetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetKxChangeset").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getKxChangesetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetKxChangesetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getKxChangesetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFinspaceClient.lambda$getKxChangeset$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetKxClusterResponse getKxCluster(GetKxClusterRequest getKxClusterRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, LimitExceededException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetKxClusterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFinspaceClient.resolveMetricPublishers(this.clientConfiguration, getKxClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"finspace");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetKxCluster");
            GetKxClusterResponse getKxClusterResponse = (GetKxClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetKxCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getKxClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetKxClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getKxClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFinspaceClient.lambda$getKxCluster$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetKxConnectionStringResponse getKxConnectionString(GetKxConnectionStringRequest getKxConnectionStringRequest) throws InternalServerException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, FinspaceException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetKxConnectionStringResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFinspaceClient.resolveMetricPublishers(this.clientConfiguration, getKxConnectionStringRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"finspace");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetKxConnectionString");
            GetKxConnectionStringResponse getKxConnectionStringResponse = (GetKxConnectionStringResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetKxConnectionString").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getKxConnectionStringRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetKxConnectionStringRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getKxConnectionStringResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFinspaceClient.lambda$getKxConnectionString$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetKxDatabaseResponse getKxDatabase(GetKxDatabaseRequest getKxDatabaseRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetKxDatabaseResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFinspaceClient.resolveMetricPublishers(this.clientConfiguration, getKxDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"finspace");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetKxDatabase");
            GetKxDatabaseResponse getKxDatabaseResponse = (GetKxDatabaseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetKxDatabase").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getKxDatabaseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetKxDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getKxDatabaseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFinspaceClient.lambda$getKxDatabase$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetKxEnvironmentResponse getKxEnvironment(GetKxEnvironmentRequest getKxEnvironmentRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, FinspaceException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetKxEnvironmentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFinspaceClient.resolveMetricPublishers(this.clientConfiguration, getKxEnvironmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"finspace");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetKxEnvironment");
            GetKxEnvironmentResponse getKxEnvironmentResponse = (GetKxEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetKxEnvironment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getKxEnvironmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetKxEnvironmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getKxEnvironmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFinspaceClient.lambda$getKxEnvironment$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetKxUserResponse getKxUser(GetKxUserRequest getKxUserRequest) throws InternalServerException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, FinspaceException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetKxUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFinspaceClient.resolveMetricPublishers(this.clientConfiguration, getKxUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"finspace");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetKxUser");
            GetKxUserResponse getKxUserResponse = (GetKxUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetKxUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getKxUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetKxUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getKxUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFinspaceClient.lambda$getKxUser$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEnvironmentsResponse listEnvironments(ListEnvironmentsRequest listEnvironmentsRequest) throws InternalServerException, ValidationException, AwsServiceException, SdkClientException, FinspaceException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEnvironmentsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFinspaceClient.resolveMetricPublishers(this.clientConfiguration, listEnvironmentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"finspace");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEnvironments");
            ListEnvironmentsResponse listEnvironmentsResponse = (ListEnvironmentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEnvironments").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listEnvironmentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEnvironmentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEnvironmentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFinspaceClient.lambda$listEnvironments$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListKxChangesetsResponse listKxChangesets(ListKxChangesetsRequest listKxChangesetsRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListKxChangesetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFinspaceClient.resolveMetricPublishers(this.clientConfiguration, listKxChangesetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"finspace");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListKxChangesets");
            ListKxChangesetsResponse listKxChangesetsResponse = (ListKxChangesetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListKxChangesets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listKxChangesetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListKxChangesetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listKxChangesetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFinspaceClient.lambda$listKxChangesets$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListKxChangesetsIterable listKxChangesetsPaginator(ListKxChangesetsRequest listKxChangesetsRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        return new ListKxChangesetsIterable(this, this.applyPaginatorUserAgent(listKxChangesetsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListKxClusterNodesResponse listKxClusterNodes(ListKxClusterNodesRequest listKxClusterNodesRequest) throws InternalServerException, ThrottlingException, AccessDeniedException, LimitExceededException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListKxClusterNodesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFinspaceClient.resolveMetricPublishers(this.clientConfiguration, listKxClusterNodesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"finspace");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListKxClusterNodes");
            ListKxClusterNodesResponse listKxClusterNodesResponse = (ListKxClusterNodesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListKxClusterNodes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listKxClusterNodesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListKxClusterNodesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listKxClusterNodesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFinspaceClient.lambda$listKxClusterNodes$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListKxClusterNodesIterable listKxClusterNodesPaginator(ListKxClusterNodesRequest listKxClusterNodesRequest) throws InternalServerException, ThrottlingException, AccessDeniedException, LimitExceededException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        return new ListKxClusterNodesIterable(this, this.applyPaginatorUserAgent(listKxClusterNodesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListKxClustersResponse listKxClusters(ListKxClustersRequest listKxClustersRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, LimitExceededException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListKxClustersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFinspaceClient.resolveMetricPublishers(this.clientConfiguration, listKxClustersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"finspace");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListKxClusters");
            ListKxClustersResponse listKxClustersResponse = (ListKxClustersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListKxClusters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listKxClustersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListKxClustersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listKxClustersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFinspaceClient.lambda$listKxClusters$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListKxDatabasesResponse listKxDatabases(ListKxDatabasesRequest listKxDatabasesRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListKxDatabasesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFinspaceClient.resolveMetricPublishers(this.clientConfiguration, listKxDatabasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"finspace");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListKxDatabases");
            ListKxDatabasesResponse listKxDatabasesResponse = (ListKxDatabasesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListKxDatabases").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listKxDatabasesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListKxDatabasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listKxDatabasesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFinspaceClient.lambda$listKxDatabases$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListKxDatabasesIterable listKxDatabasesPaginator(ListKxDatabasesRequest listKxDatabasesRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        return new ListKxDatabasesIterable(this, this.applyPaginatorUserAgent(listKxDatabasesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListKxEnvironmentsResponse listKxEnvironments(ListKxEnvironmentsRequest listKxEnvironmentsRequest) throws InternalServerException, ValidationException, AwsServiceException, SdkClientException, FinspaceException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListKxEnvironmentsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFinspaceClient.resolveMetricPublishers(this.clientConfiguration, listKxEnvironmentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"finspace");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListKxEnvironments");
            ListKxEnvironmentsResponse listKxEnvironmentsResponse = (ListKxEnvironmentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListKxEnvironments").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listKxEnvironmentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListKxEnvironmentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listKxEnvironmentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFinspaceClient.lambda$listKxEnvironments$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListKxEnvironmentsIterable listKxEnvironmentsPaginator(ListKxEnvironmentsRequest listKxEnvironmentsRequest) throws InternalServerException, ValidationException, AwsServiceException, SdkClientException, FinspaceException {
        return new ListKxEnvironmentsIterable(this, this.applyPaginatorUserAgent(listKxEnvironmentsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListKxUsersResponse listKxUsers(ListKxUsersRequest listKxUsersRequest) throws ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, FinspaceException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListKxUsersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFinspaceClient.resolveMetricPublishers(this.clientConfiguration, listKxUsersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"finspace");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListKxUsers");
            ListKxUsersResponse listKxUsersResponse = (ListKxUsersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListKxUsers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listKxUsersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListKxUsersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listKxUsersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFinspaceClient.lambda$listKxUsers$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFinspaceClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"finspace");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFinspaceClient.lambda$listTagsForResource$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFinspaceClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"finspace");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFinspaceClient.lambda$tagResource$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFinspaceClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"finspace");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFinspaceClient.lambda$untagResource$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateEnvironmentResponse updateEnvironment(UpdateEnvironmentRequest updateEnvironmentRequest) throws ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, FinspaceException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateEnvironmentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFinspaceClient.resolveMetricPublishers(this.clientConfiguration, updateEnvironmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"finspace");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateEnvironment");
            UpdateEnvironmentResponse updateEnvironmentResponse = (UpdateEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateEnvironment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateEnvironmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateEnvironmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateEnvironmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFinspaceClient.lambda$updateEnvironment$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateKxClusterDatabasesResponse updateKxClusterDatabases(UpdateKxClusterDatabasesRequest updateKxClusterDatabasesRequest) throws InternalServerException, ThrottlingException, AccessDeniedException, LimitExceededException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateKxClusterDatabasesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFinspaceClient.resolveMetricPublishers(this.clientConfiguration, updateKxClusterDatabasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"finspace");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateKxClusterDatabases");
            UpdateKxClusterDatabasesResponse updateKxClusterDatabasesResponse = (UpdateKxClusterDatabasesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateKxClusterDatabases").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateKxClusterDatabasesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateKxClusterDatabasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateKxClusterDatabasesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFinspaceClient.lambda$updateKxClusterDatabases$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateKxDatabaseResponse updateKxDatabase(UpdateKxDatabaseRequest updateKxDatabaseRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, FinspaceException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateKxDatabaseResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFinspaceClient.resolveMetricPublishers(this.clientConfiguration, updateKxDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"finspace");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateKxDatabase");
            UpdateKxDatabaseResponse updateKxDatabaseResponse = (UpdateKxDatabaseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateKxDatabase").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateKxDatabaseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateKxDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateKxDatabaseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFinspaceClient.lambda$updateKxDatabase$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateKxEnvironmentResponse updateKxEnvironment(UpdateKxEnvironmentRequest updateKxEnvironmentRequest) throws ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException, AwsServiceException, SdkClientException, FinspaceException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateKxEnvironmentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFinspaceClient.resolveMetricPublishers(this.clientConfiguration, updateKxEnvironmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"finspace");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateKxEnvironment");
            UpdateKxEnvironmentResponse updateKxEnvironmentResponse = (UpdateKxEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateKxEnvironment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateKxEnvironmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateKxEnvironmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateKxEnvironmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFinspaceClient.lambda$updateKxEnvironment$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateKxEnvironmentNetworkResponse updateKxEnvironmentNetwork(UpdateKxEnvironmentNetworkRequest updateKxEnvironmentNetworkRequest) throws ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException, AwsServiceException, SdkClientException, FinspaceException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateKxEnvironmentNetworkResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFinspaceClient.resolveMetricPublishers(this.clientConfiguration, updateKxEnvironmentNetworkRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"finspace");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateKxEnvironmentNetwork");
            UpdateKxEnvironmentNetworkResponse updateKxEnvironmentNetworkResponse = (UpdateKxEnvironmentNetworkResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateKxEnvironmentNetwork").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateKxEnvironmentNetworkRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateKxEnvironmentNetworkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateKxEnvironmentNetworkResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFinspaceClient.lambda$updateKxEnvironmentNetwork$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateKxUserResponse updateKxUser(UpdateKxUserRequest updateKxUserRequest) throws InternalServerException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, LimitExceededException, ConflictException, AwsServiceException, SdkClientException, FinspaceException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateKxUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFinspaceClient.resolveMetricPublishers(this.clientConfiguration, updateKxUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"finspace");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateKxUser");
            UpdateKxUserResponse updateKxUserResponse = (UpdateKxUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateKxUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateKxUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateKxUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateKxUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFinspaceClient.lambda$updateKxUser$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private <T extends FinspaceRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.20.89").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((FinspaceRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public final String serviceName() {
        return "finspace";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(FinspaceException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build());
    }

    @Override
    public final FinspaceServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateKxUser$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateKxEnvironmentNetwork$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateKxEnvironment$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateKxDatabase$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateKxClusterDatabases$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateEnvironment$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listKxUsers$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listKxEnvironments$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listKxDatabases$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listKxClusters$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listKxClusterNodes$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listKxChangesets$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEnvironments$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getKxUser$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getKxEnvironment$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getKxDatabase$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getKxConnectionString$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getKxCluster$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getKxChangeset$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEnvironment$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteKxUser$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteKxEnvironment$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteKxDatabase$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteKxCluster$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEnvironment$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createKxUser$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createKxEnvironment$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createKxDatabase$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createKxCluster$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createKxChangeset$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createEnvironment$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

