/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ErrorDetails {
    THE_INPUTS_TO_THIS_REQUEST_ARE_INVALID("The inputs to this request are invalid."),
    SERVICE_LIMITS_HAVE_BEEN_EXCEEDED("Service limits have been exceeded."),
    MISSING_REQUIRED_PERMISSION_TO_PERFORM_THIS_REQUEST("Missing required permission to perform this request."),
    ONE_OR_MORE_INPUTS_TO_THIS_REQUEST_WERE_NOT_FOUND("One or more inputs to this request were not found."),
    THE_SYSTEM_TEMPORARILY_LACKS_SUFFICIENT_RESOURCES_TO_PROCESS_THE_REQUEST("The system temporarily lacks sufficient resources to process the request."),
    AN_INTERNAL_ERROR_HAS_OCCURRED("An internal error has occurred."),
    CANCELLED("Cancelled"),
    A_USER_RECOVERABLE_ERROR_HAS_OCCURRED("A user recoverable error has occurred"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ErrorDetails> VALUE_MAP;
    private final String value;

    private ErrorDetails(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ErrorDetails fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ErrorDetails> knownValues() {
        EnumSet<ErrorDetails> knownValues = EnumSet.allOf(ErrorDetails.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ErrorDetails.class, ErrorDetails::toString);
    }
}

