/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.finspace.model.FinspaceResponse;
import software.amazon.awssdk.services.finspace.model.KxCluster;
import software.amazon.awssdk.services.finspace.model.KxClustersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListKxClustersResponse
extends FinspaceResponse
implements ToCopyableBuilder<Builder, ListKxClustersResponse> {
    private static final SdkField<List<KxCluster>> KX_CLUSTER_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("kxClusterSummaries").getter(ListKxClustersResponse.getter(ListKxClustersResponse::kxClusterSummaries)).setter(ListKxClustersResponse.setter(Builder::kxClusterSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kxClusterSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KxCluster::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListKxClustersResponse.getter(ListKxClustersResponse::nextToken)).setter(ListKxClustersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KX_CLUSTER_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<KxCluster> kxClusterSummaries;
    private final String nextToken;

    private ListKxClustersResponse(BuilderImpl builder) {
        super(builder);
        this.kxClusterSummaries = builder.kxClusterSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasKxClusterSummaries() {
        return this.kxClusterSummaries != null && !(this.kxClusterSummaries instanceof SdkAutoConstructList);
    }

    public final List<KxCluster> kxClusterSummaries() {
        return this.kxClusterSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKxClusterSummaries() ? this.kxClusterSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListKxClustersResponse)) {
            return false;
        }
        ListKxClustersResponse other = (ListKxClustersResponse)((Object)obj);
        return this.hasKxClusterSummaries() == other.hasKxClusterSummaries() && Objects.equals(this.kxClusterSummaries(), other.kxClusterSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListKxClustersResponse").add("KxClusterSummaries", this.hasKxClusterSummaries() ? this.kxClusterSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "kxClusterSummaries": {
                return Optional.ofNullable(clazz.cast(this.kxClusterSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListKxClustersResponse, T> g) {
        return obj -> g.apply((ListKxClustersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceResponse.BuilderImpl
    implements Builder {
        private List<KxCluster> kxClusterSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListKxClustersResponse model) {
            super(model);
            this.kxClusterSummaries(model.kxClusterSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<KxCluster.Builder> getKxClusterSummaries() {
            List<KxCluster.Builder> result = KxClustersCopier.copyToBuilder(this.kxClusterSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKxClusterSummaries(Collection<KxCluster.BuilderImpl> kxClusterSummaries) {
            this.kxClusterSummaries = KxClustersCopier.copyFromBuilder(kxClusterSummaries);
        }

        @Override
        public final Builder kxClusterSummaries(Collection<KxCluster> kxClusterSummaries) {
            this.kxClusterSummaries = KxClustersCopier.copy(kxClusterSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kxClusterSummaries(KxCluster ... kxClusterSummaries) {
            this.kxClusterSummaries(Arrays.asList(kxClusterSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kxClusterSummaries(Consumer<KxCluster.Builder> ... kxClusterSummaries) {
            this.kxClusterSummaries(Stream.of(kxClusterSummaries).map(c -> (KxCluster)((KxCluster.Builder)KxCluster.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListKxClustersResponse build() {
            return new ListKxClustersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FinspaceResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListKxClustersResponse> {
        public Builder kxClusterSummaries(Collection<KxCluster> var1);

        public Builder kxClusterSummaries(KxCluster ... var1);

        public Builder kxClusterSummaries(Consumer<KxCluster.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

