/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateEipFromVlanResponse extends EvsResponse implements
        ToCopyableBuilder<DisassociateEipFromVlanResponse.Builder, DisassociateEipFromVlanResponse> {
    private static final SdkField<Vlan> VLAN_FIELD = SdkField.<Vlan> builder(MarshallingType.SDK_POJO).memberName("vlan")
            .getter(getter(DisassociateEipFromVlanResponse::vlan)).setter(setter(Builder::vlan)).constructor(Vlan::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vlan").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VLAN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Vlan vlan;

    private DisassociateEipFromVlanResponse(BuilderImpl builder) {
        super(builder);
        this.vlan = builder.vlan;
    }

    /**
     * Returns the value of the Vlan property for this object.
     * 
     * @return The value of the Vlan property for this object.
     */
    public final Vlan vlan() {
        return vlan;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vlan());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateEipFromVlanResponse)) {
            return false;
        }
        DisassociateEipFromVlanResponse other = (DisassociateEipFromVlanResponse) obj;
        return Objects.equals(vlan(), other.vlan());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateEipFromVlanResponse").add("Vlan", vlan()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vlan":
            return Optional.ofNullable(clazz.cast(vlan()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vlan", VLAN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociateEipFromVlanResponse, T> g) {
        return obj -> g.apply((DisassociateEipFromVlanResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EvsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DisassociateEipFromVlanResponse> {
        /**
         * Sets the value of the Vlan property for this object.
         *
         * @param vlan
         *        The new value for the Vlan property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vlan(Vlan vlan);

        /**
         * Sets the value of the Vlan property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Vlan.Builder} avoiding the need to create
         * one manually via {@link Vlan#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Vlan.Builder#build()} is called immediately and its result is
         * passed to {@link #vlan(Vlan)}.
         * 
         * @param vlan
         *        a consumer that will call methods on {@link Vlan.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vlan(Vlan)
         */
        default Builder vlan(Consumer<Vlan.Builder> vlan) {
            return vlan(Vlan.builder().applyMutation(vlan).build());
        }
    }

    static final class BuilderImpl extends EvsResponse.BuilderImpl implements Builder {
        private Vlan vlan;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateEipFromVlanResponse model) {
            super(model);
            vlan(model.vlan);
        }

        public final Vlan.Builder getVlan() {
            return vlan != null ? vlan.toBuilder() : null;
        }

        public final void setVlan(Vlan.BuilderImpl vlan) {
            this.vlan = vlan != null ? vlan.build() : null;
        }

        @Override
        public final Builder vlan(Vlan vlan) {
            this.vlan = vlan;
            return this;
        }

        @Override
        public DisassociateEipFromVlanResponse build() {
            return new DisassociateEipFromVlanResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
