/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.evs.model.InstanceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HostInfoForCreate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HostInfoForCreate> {
    private static final SdkField<String> HOST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hostName").getter(HostInfoForCreate.getter(HostInfoForCreate::hostName)).setter(HostInfoForCreate.setter(Builder::hostName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostName").build()}).build();
    private static final SdkField<String> KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyName").getter(HostInfoForCreate.getter(HostInfoForCreate::keyName)).setter(HostInfoForCreate.setter(Builder::keyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyName").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceType").getter(HostInfoForCreate.getter(HostInfoForCreate::instanceTypeAsString)).setter(HostInfoForCreate.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()}).build();
    private static final SdkField<String> PLACEMENT_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("placementGroupId").getter(HostInfoForCreate.getter(HostInfoForCreate::placementGroupId)).setter(HostInfoForCreate.setter(Builder::placementGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementGroupId").build()}).build();
    private static final SdkField<String> DEDICATED_HOST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dedicatedHostId").getter(HostInfoForCreate.getter(HostInfoForCreate::dedicatedHostId)).setter(HostInfoForCreate.setter(Builder::dedicatedHostId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dedicatedHostId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_NAME_FIELD, KEY_NAME_FIELD, INSTANCE_TYPE_FIELD, PLACEMENT_GROUP_ID_FIELD, DEDICATED_HOST_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HostInfoForCreate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String hostName;
    private final String keyName;
    private final String instanceType;
    private final String placementGroupId;
    private final String dedicatedHostId;

    private HostInfoForCreate(BuilderImpl builder) {
        this.hostName = builder.hostName;
        this.keyName = builder.keyName;
        this.instanceType = builder.instanceType;
        this.placementGroupId = builder.placementGroupId;
        this.dedicatedHostId = builder.dedicatedHostId;
    }

    public final String hostName() {
        return this.hostName;
    }

    public final String keyName() {
        return this.keyName;
    }

    public final InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final String placementGroupId() {
        return this.placementGroupId;
    }

    public final String dedicatedHostId() {
        return this.dedicatedHostId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostName());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.placementGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dedicatedHostId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostInfoForCreate)) {
            return false;
        }
        HostInfoForCreate other = (HostInfoForCreate)obj;
        return Objects.equals(this.hostName(), other.hostName()) && Objects.equals(this.keyName(), other.keyName()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.placementGroupId(), other.placementGroupId()) && Objects.equals(this.dedicatedHostId(), other.dedicatedHostId());
    }

    public final String toString() {
        return ToString.builder((String)"HostInfoForCreate").add("HostName", (Object)this.hostName()).add("KeyName", (Object)this.keyName()).add("InstanceType", (Object)this.instanceTypeAsString()).add("PlacementGroupId", (Object)this.placementGroupId()).add("DedicatedHostId", (Object)this.dedicatedHostId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "hostName": {
                return Optional.ofNullable(clazz.cast(this.hostName()));
            }
            case "keyName": {
                return Optional.ofNullable(clazz.cast(this.keyName()));
            }
            case "instanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "placementGroupId": {
                return Optional.ofNullable(clazz.cast(this.placementGroupId()));
            }
            case "dedicatedHostId": {
                return Optional.ofNullable(clazz.cast(this.dedicatedHostId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("hostName", HOST_NAME_FIELD);
        map.put("keyName", KEY_NAME_FIELD);
        map.put("instanceType", INSTANCE_TYPE_FIELD);
        map.put("placementGroupId", PLACEMENT_GROUP_ID_FIELD);
        map.put("dedicatedHostId", DEDICATED_HOST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HostInfoForCreate, T> g) {
        return obj -> g.apply((HostInfoForCreate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String hostName;
        private String keyName;
        private String instanceType;
        private String placementGroupId;
        private String dedicatedHostId;

        private BuilderImpl() {
        }

        private BuilderImpl(HostInfoForCreate model) {
            this.hostName(model.hostName);
            this.keyName(model.keyName);
            this.instanceType(model.instanceType);
            this.placementGroupId(model.placementGroupId);
            this.dedicatedHostId(model.dedicatedHostId);
        }

        public final String getHostName() {
            return this.hostName;
        }

        public final void setHostName(String hostName) {
            this.hostName = hostName;
        }

        @Override
        public final Builder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getPlacementGroupId() {
            return this.placementGroupId;
        }

        public final void setPlacementGroupId(String placementGroupId) {
            this.placementGroupId = placementGroupId;
        }

        @Override
        public final Builder placementGroupId(String placementGroupId) {
            this.placementGroupId = placementGroupId;
            return this;
        }

        public final String getDedicatedHostId() {
            return this.dedicatedHostId;
        }

        public final void setDedicatedHostId(String dedicatedHostId) {
            this.dedicatedHostId = dedicatedHostId;
        }

        @Override
        public final Builder dedicatedHostId(String dedicatedHostId) {
            this.dedicatedHostId = dedicatedHostId;
            return this;
        }

        public HostInfoForCreate build() {
            return new HostInfoForCreate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HostInfoForCreate> {
        public Builder hostName(String var1);

        public Builder keyName(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder placementGroupId(String var1);

        public Builder dedicatedHostId(String var1);
    }
}

