/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EnvironmentState {
    CREATING("CREATING"),
    CREATED("CREATED"),
    DELETING("DELETING"),
    DELETED("DELETED"),
    CREATE_FAILED("CREATE_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EnvironmentState> VALUE_MAP;
    private final String value;

    private EnvironmentState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EnvironmentState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EnvironmentState> knownValues() {
        EnumSet<EnvironmentState> knownValues = EnumSet.allOf(EnvironmentState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EnvironmentState.class, EnvironmentState::toString);
    }
}

