/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.evs.model.CheckResult;
import software.amazon.awssdk.services.evs.model.CheckType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Check
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Check> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(Check.getter(Check::typeAsString)).setter(Check.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("result").getter(Check.getter(Check::resultAsString)).setter(Check.setter(Builder::result)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()}).build();
    private static final SdkField<Instant> IMPAIRED_SINCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("impairedSince").getter(Check.getter(Check::impairedSince)).setter(Check.setter(Builder::impairedSince)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impairedSince").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, RESULT_FIELD, IMPAIRED_SINCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Check.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String result;
    private final Instant impairedSince;

    private Check(BuilderImpl builder) {
        this.type = builder.type;
        this.result = builder.result;
        this.impairedSince = builder.impairedSince;
    }

    public final CheckType type() {
        return CheckType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final CheckResult result() {
        return CheckResult.fromValue(this.result);
    }

    public final String resultAsString() {
        return this.result;
    }

    public final Instant impairedSince() {
        return this.impairedSince;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.impairedSince());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Check)) {
            return false;
        }
        Check other = (Check)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.resultAsString(), other.resultAsString()) && Objects.equals(this.impairedSince(), other.impairedSince());
    }

    public final String toString() {
        return ToString.builder((String)"Check").add("Type", (Object)this.typeAsString()).add("Result", (Object)this.resultAsString()).add("ImpairedSince", (Object)this.impairedSince()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "result": {
                return Optional.ofNullable(clazz.cast(this.resultAsString()));
            }
            case "impairedSince": {
                return Optional.ofNullable(clazz.cast(this.impairedSince()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TYPE_FIELD);
        map.put("result", RESULT_FIELD);
        map.put("impairedSince", IMPAIRED_SINCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Check, T> g) {
        return obj -> g.apply((Check)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String result;
        private Instant impairedSince;

        private BuilderImpl() {
        }

        private BuilderImpl(Check model) {
            this.type(model.type);
            this.result(model.result);
            this.impairedSince(model.impairedSince);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CheckType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getResult() {
            return this.result;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        @Override
        public final Builder result(CheckResult result) {
            this.result(result == null ? null : result.toString());
            return this;
        }

        public final Instant getImpairedSince() {
            return this.impairedSince;
        }

        public final void setImpairedSince(Instant impairedSince) {
            this.impairedSince = impairedSince;
        }

        @Override
        public final Builder impairedSince(Instant impairedSince) {
            this.impairedSince = impairedSince;
            return this;
        }

        public Check build() {
            return new Check(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Check> {
        public Builder type(String var1);

        public Builder type(CheckType var1);

        public Builder result(String var1);

        public Builder result(CheckResult var1);

        public Builder impairedSince(Instant var1);
    }
}

