/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.evs.model.Check;
import software.amazon.awssdk.services.evs.model.CheckResult;
import software.amazon.awssdk.services.evs.model.ChecksListCopier;
import software.amazon.awssdk.services.evs.model.ConnectivityInfo;
import software.amazon.awssdk.services.evs.model.EnvironmentState;
import software.amazon.awssdk.services.evs.model.LicenseInfo;
import software.amazon.awssdk.services.evs.model.LicenseInfoListCopier;
import software.amazon.awssdk.services.evs.model.Secret;
import software.amazon.awssdk.services.evs.model.SecretListCopier;
import software.amazon.awssdk.services.evs.model.ServiceAccessSecurityGroups;
import software.amazon.awssdk.services.evs.model.VcfHostnames;
import software.amazon.awssdk.services.evs.model.VcfVersion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Environment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Environment> {
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(Environment.getter(Environment::environmentId)).setter(Environment.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()}).build();
    private static final SdkField<String> ENVIRONMENT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentState").getter(Environment.getter(Environment::environmentStateAsString)).setter(Environment.setter(Builder::environmentState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentState").build()}).build();
    private static final SdkField<String> STATE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stateDetails").getter(Environment.getter(Environment::stateDetails)).setter(Environment.setter(Builder::stateDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateDetails").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Environment.getter(Environment::createdAt)).setter(Environment.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("modifiedAt").getter(Environment.getter(Environment::modifiedAt)).setter(Environment.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentArn").getter(Environment.getter(Environment::environmentArn)).setter(Environment.setter(Builder::environmentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentArn").build()}).build();
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentName").getter(Environment.getter(Environment::environmentName)).setter(Environment.setter(Builder::environmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentName").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vpcId").getter(Environment.getter(Environment::vpcId)).setter(Environment.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcId").build()}).build();
    private static final SdkField<String> SERVICE_ACCESS_SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceAccessSubnetId").getter(Environment.getter(Environment::serviceAccessSubnetId)).setter(Environment.setter(Builder::serviceAccessSubnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccessSubnetId").build()}).build();
    private static final SdkField<String> VCF_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vcfVersion").getter(Environment.getter(Environment::vcfVersionAsString)).setter(Environment.setter(Builder::vcfVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vcfVersion").build()}).build();
    private static final SdkField<Boolean> TERMS_ACCEPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("termsAccepted").getter(Environment.getter(Environment::termsAccepted)).setter(Environment.setter(Builder::termsAccepted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("termsAccepted").build()}).build();
    private static final SdkField<List<LicenseInfo>> LICENSE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("licenseInfo").getter(Environment.getter(Environment::licenseInfo)).setter(Environment.setter(Builder::licenseInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseInfo").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LicenseInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SITE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("siteId").getter(Environment.getter(Environment::siteId)).setter(Environment.setter(Builder::siteId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("siteId").build()}).build();
    private static final SdkField<String> ENVIRONMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentStatus").getter(Environment.getter(Environment::environmentStatusAsString)).setter(Environment.setter(Builder::environmentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentStatus").build()}).build();
    private static final SdkField<List<Check>> CHECKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("checks").getter(Environment.getter(Environment::checks)).setter(Environment.setter(Builder::checks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Check::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ConnectivityInfo> CONNECTIVITY_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("connectivityInfo").getter(Environment.getter(Environment::connectivityInfo)).setter(Environment.setter(Builder::connectivityInfo)).constructor(ConnectivityInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectivityInfo").build()}).build();
    private static final SdkField<VcfHostnames> VCF_HOSTNAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vcfHostnames").getter(Environment.getter(Environment::vcfHostnames)).setter(Environment.setter(Builder::vcfHostnames)).constructor(VcfHostnames::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vcfHostnames").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(Environment.getter(Environment::kmsKeyId)).setter(Environment.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final SdkField<ServiceAccessSecurityGroups> SERVICE_ACCESS_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serviceAccessSecurityGroups").getter(Environment.getter(Environment::serviceAccessSecurityGroups)).setter(Environment.setter(Builder::serviceAccessSecurityGroups)).constructor(ServiceAccessSecurityGroups::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccessSecurityGroups").build()}).build();
    private static final SdkField<List<Secret>> CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("credentials").getter(Environment.getter(Environment::credentials)).setter(Environment.setter(Builder::credentials)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentials").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Secret::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_ID_FIELD, ENVIRONMENT_STATE_FIELD, STATE_DETAILS_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD, ENVIRONMENT_ARN_FIELD, ENVIRONMENT_NAME_FIELD, VPC_ID_FIELD, SERVICE_ACCESS_SUBNET_ID_FIELD, VCF_VERSION_FIELD, TERMS_ACCEPTED_FIELD, LICENSE_INFO_FIELD, SITE_ID_FIELD, ENVIRONMENT_STATUS_FIELD, CHECKS_FIELD, CONNECTIVITY_INFO_FIELD, VCF_HOSTNAMES_FIELD, KMS_KEY_ID_FIELD, SERVICE_ACCESS_SECURITY_GROUPS_FIELD, CREDENTIALS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Environment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String environmentId;
    private final String environmentState;
    private final String stateDetails;
    private final Instant createdAt;
    private final Instant modifiedAt;
    private final String environmentArn;
    private final String environmentName;
    private final String vpcId;
    private final String serviceAccessSubnetId;
    private final String vcfVersion;
    private final Boolean termsAccepted;
    private final List<LicenseInfo> licenseInfo;
    private final String siteId;
    private final String environmentStatus;
    private final List<Check> checks;
    private final ConnectivityInfo connectivityInfo;
    private final VcfHostnames vcfHostnames;
    private final String kmsKeyId;
    private final ServiceAccessSecurityGroups serviceAccessSecurityGroups;
    private final List<Secret> credentials;

    private Environment(BuilderImpl builder) {
        this.environmentId = builder.environmentId;
        this.environmentState = builder.environmentState;
        this.stateDetails = builder.stateDetails;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.environmentArn = builder.environmentArn;
        this.environmentName = builder.environmentName;
        this.vpcId = builder.vpcId;
        this.serviceAccessSubnetId = builder.serviceAccessSubnetId;
        this.vcfVersion = builder.vcfVersion;
        this.termsAccepted = builder.termsAccepted;
        this.licenseInfo = builder.licenseInfo;
        this.siteId = builder.siteId;
        this.environmentStatus = builder.environmentStatus;
        this.checks = builder.checks;
        this.connectivityInfo = builder.connectivityInfo;
        this.vcfHostnames = builder.vcfHostnames;
        this.kmsKeyId = builder.kmsKeyId;
        this.serviceAccessSecurityGroups = builder.serviceAccessSecurityGroups;
        this.credentials = builder.credentials;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final EnvironmentState environmentState() {
        return EnvironmentState.fromValue(this.environmentState);
    }

    public final String environmentStateAsString() {
        return this.environmentState;
    }

    public final String stateDetails() {
        return this.stateDetails;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public final String environmentArn() {
        return this.environmentArn;
    }

    public final String environmentName() {
        return this.environmentName;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final String serviceAccessSubnetId() {
        return this.serviceAccessSubnetId;
    }

    public final VcfVersion vcfVersion() {
        return VcfVersion.fromValue(this.vcfVersion);
    }

    public final String vcfVersionAsString() {
        return this.vcfVersion;
    }

    public final Boolean termsAccepted() {
        return this.termsAccepted;
    }

    public final boolean hasLicenseInfo() {
        return this.licenseInfo != null && !(this.licenseInfo instanceof SdkAutoConstructList);
    }

    public final List<LicenseInfo> licenseInfo() {
        return this.licenseInfo;
    }

    public final String siteId() {
        return this.siteId;
    }

    public final CheckResult environmentStatus() {
        return CheckResult.fromValue(this.environmentStatus);
    }

    public final String environmentStatusAsString() {
        return this.environmentStatus;
    }

    public final boolean hasChecks() {
        return this.checks != null && !(this.checks instanceof SdkAutoConstructList);
    }

    public final List<Check> checks() {
        return this.checks;
    }

    public final ConnectivityInfo connectivityInfo() {
        return this.connectivityInfo;
    }

    public final VcfHostnames vcfHostnames() {
        return this.vcfHostnames;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final ServiceAccessSecurityGroups serviceAccessSecurityGroups() {
        return this.serviceAccessSecurityGroups;
    }

    public final boolean hasCredentials() {
        return this.credentials != null && !(this.credentials instanceof SdkAutoConstructList);
    }

    public final List<Secret> credentials() {
        return this.credentials;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccessSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vcfVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.termsAccepted());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLicenseInfo() ? this.licenseInfo() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.siteId());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChecks() ? this.checks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.connectivityInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.vcfHostnames());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccessSecurityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCredentials() ? this.credentials() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Environment)) {
            return false;
        }
        Environment other = (Environment)obj;
        return Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.environmentStateAsString(), other.environmentStateAsString()) && Objects.equals(this.stateDetails(), other.stateDetails()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.modifiedAt(), other.modifiedAt()) && Objects.equals(this.environmentArn(), other.environmentArn()) && Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.serviceAccessSubnetId(), other.serviceAccessSubnetId()) && Objects.equals(this.vcfVersionAsString(), other.vcfVersionAsString()) && Objects.equals(this.termsAccepted(), other.termsAccepted()) && this.hasLicenseInfo() == other.hasLicenseInfo() && Objects.equals(this.licenseInfo(), other.licenseInfo()) && Objects.equals(this.siteId(), other.siteId()) && Objects.equals(this.environmentStatusAsString(), other.environmentStatusAsString()) && this.hasChecks() == other.hasChecks() && Objects.equals(this.checks(), other.checks()) && Objects.equals(this.connectivityInfo(), other.connectivityInfo()) && Objects.equals(this.vcfHostnames(), other.vcfHostnames()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.serviceAccessSecurityGroups(), other.serviceAccessSecurityGroups()) && this.hasCredentials() == other.hasCredentials() && Objects.equals(this.credentials(), other.credentials());
    }

    public final String toString() {
        return ToString.builder((String)"Environment").add("EnvironmentId", (Object)this.environmentId()).add("EnvironmentState", (Object)this.environmentStateAsString()).add("StateDetails", (Object)this.stateDetails()).add("CreatedAt", (Object)this.createdAt()).add("ModifiedAt", (Object)this.modifiedAt()).add("EnvironmentArn", (Object)this.environmentArn()).add("EnvironmentName", (Object)this.environmentName()).add("VpcId", (Object)this.vpcId()).add("ServiceAccessSubnetId", (Object)this.serviceAccessSubnetId()).add("VcfVersion", (Object)this.vcfVersionAsString()).add("TermsAccepted", (Object)this.termsAccepted()).add("LicenseInfo", this.hasLicenseInfo() ? this.licenseInfo() : null).add("SiteId", (Object)this.siteId()).add("EnvironmentStatus", (Object)this.environmentStatusAsString()).add("Checks", this.hasChecks() ? this.checks() : null).add("ConnectivityInfo", (Object)this.connectivityInfo()).add("VcfHostnames", (Object)this.vcfHostnames()).add("KmsKeyId", (Object)this.kmsKeyId()).add("ServiceAccessSecurityGroups", (Object)this.serviceAccessSecurityGroups()).add("Credentials", this.hasCredentials() ? this.credentials() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "environmentState": {
                return Optional.ofNullable(clazz.cast(this.environmentStateAsString()));
            }
            case "stateDetails": {
                return Optional.ofNullable(clazz.cast(this.stateDetails()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "modifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
            case "environmentArn": {
                return Optional.ofNullable(clazz.cast(this.environmentArn()));
            }
            case "environmentName": {
                return Optional.ofNullable(clazz.cast(this.environmentName()));
            }
            case "vpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "serviceAccessSubnetId": {
                return Optional.ofNullable(clazz.cast(this.serviceAccessSubnetId()));
            }
            case "vcfVersion": {
                return Optional.ofNullable(clazz.cast(this.vcfVersionAsString()));
            }
            case "termsAccepted": {
                return Optional.ofNullable(clazz.cast(this.termsAccepted()));
            }
            case "licenseInfo": {
                return Optional.ofNullable(clazz.cast(this.licenseInfo()));
            }
            case "siteId": {
                return Optional.ofNullable(clazz.cast(this.siteId()));
            }
            case "environmentStatus": {
                return Optional.ofNullable(clazz.cast(this.environmentStatusAsString()));
            }
            case "checks": {
                return Optional.ofNullable(clazz.cast(this.checks()));
            }
            case "connectivityInfo": {
                return Optional.ofNullable(clazz.cast(this.connectivityInfo()));
            }
            case "vcfHostnames": {
                return Optional.ofNullable(clazz.cast(this.vcfHostnames()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "serviceAccessSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.serviceAccessSecurityGroups()));
            }
            case "credentials": {
                return Optional.ofNullable(clazz.cast(this.credentials()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("environmentState", ENVIRONMENT_STATE_FIELD);
        map.put("stateDetails", STATE_DETAILS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("modifiedAt", MODIFIED_AT_FIELD);
        map.put("environmentArn", ENVIRONMENT_ARN_FIELD);
        map.put("environmentName", ENVIRONMENT_NAME_FIELD);
        map.put("vpcId", VPC_ID_FIELD);
        map.put("serviceAccessSubnetId", SERVICE_ACCESS_SUBNET_ID_FIELD);
        map.put("vcfVersion", VCF_VERSION_FIELD);
        map.put("termsAccepted", TERMS_ACCEPTED_FIELD);
        map.put("licenseInfo", LICENSE_INFO_FIELD);
        map.put("siteId", SITE_ID_FIELD);
        map.put("environmentStatus", ENVIRONMENT_STATUS_FIELD);
        map.put("checks", CHECKS_FIELD);
        map.put("connectivityInfo", CONNECTIVITY_INFO_FIELD);
        map.put("vcfHostnames", VCF_HOSTNAMES_FIELD);
        map.put("kmsKeyId", KMS_KEY_ID_FIELD);
        map.put("serviceAccessSecurityGroups", SERVICE_ACCESS_SECURITY_GROUPS_FIELD);
        map.put("credentials", CREDENTIALS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Environment, T> g) {
        return obj -> g.apply((Environment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String environmentId;
        private String environmentState;
        private String stateDetails;
        private Instant createdAt;
        private Instant modifiedAt;
        private String environmentArn;
        private String environmentName;
        private String vpcId;
        private String serviceAccessSubnetId;
        private String vcfVersion;
        private Boolean termsAccepted;
        private List<LicenseInfo> licenseInfo = DefaultSdkAutoConstructList.getInstance();
        private String siteId;
        private String environmentStatus;
        private List<Check> checks = DefaultSdkAutoConstructList.getInstance();
        private ConnectivityInfo connectivityInfo;
        private VcfHostnames vcfHostnames;
        private String kmsKeyId;
        private ServiceAccessSecurityGroups serviceAccessSecurityGroups;
        private List<Secret> credentials = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Environment model) {
            this.environmentId(model.environmentId);
            this.environmentState(model.environmentState);
            this.stateDetails(model.stateDetails);
            this.createdAt(model.createdAt);
            this.modifiedAt(model.modifiedAt);
            this.environmentArn(model.environmentArn);
            this.environmentName(model.environmentName);
            this.vpcId(model.vpcId);
            this.serviceAccessSubnetId(model.serviceAccessSubnetId);
            this.vcfVersion(model.vcfVersion);
            this.termsAccepted(model.termsAccepted);
            this.licenseInfo(model.licenseInfo);
            this.siteId(model.siteId);
            this.environmentStatus(model.environmentStatus);
            this.checks(model.checks);
            this.connectivityInfo(model.connectivityInfo);
            this.vcfHostnames(model.vcfHostnames);
            this.kmsKeyId(model.kmsKeyId);
            this.serviceAccessSecurityGroups(model.serviceAccessSecurityGroups);
            this.credentials(model.credentials);
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getEnvironmentState() {
            return this.environmentState;
        }

        public final void setEnvironmentState(String environmentState) {
            this.environmentState = environmentState;
        }

        @Override
        public final Builder environmentState(String environmentState) {
            this.environmentState = environmentState;
            return this;
        }

        @Override
        public final Builder environmentState(EnvironmentState environmentState) {
            this.environmentState(environmentState == null ? null : environmentState.toString());
            return this;
        }

        public final String getStateDetails() {
            return this.stateDetails;
        }

        public final void setStateDetails(String stateDetails) {
            this.stateDetails = stateDetails;
        }

        @Override
        public final Builder stateDetails(String stateDetails) {
            this.stateDetails = stateDetails;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final String getEnvironmentArn() {
            return this.environmentArn;
        }

        public final void setEnvironmentArn(String environmentArn) {
            this.environmentArn = environmentArn;
        }

        @Override
        public final Builder environmentArn(String environmentArn) {
            this.environmentArn = environmentArn;
            return this;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getServiceAccessSubnetId() {
            return this.serviceAccessSubnetId;
        }

        public final void setServiceAccessSubnetId(String serviceAccessSubnetId) {
            this.serviceAccessSubnetId = serviceAccessSubnetId;
        }

        @Override
        public final Builder serviceAccessSubnetId(String serviceAccessSubnetId) {
            this.serviceAccessSubnetId = serviceAccessSubnetId;
            return this;
        }

        public final String getVcfVersion() {
            return this.vcfVersion;
        }

        public final void setVcfVersion(String vcfVersion) {
            this.vcfVersion = vcfVersion;
        }

        @Override
        public final Builder vcfVersion(String vcfVersion) {
            this.vcfVersion = vcfVersion;
            return this;
        }

        @Override
        public final Builder vcfVersion(VcfVersion vcfVersion) {
            this.vcfVersion(vcfVersion == null ? null : vcfVersion.toString());
            return this;
        }

        public final Boolean getTermsAccepted() {
            return this.termsAccepted;
        }

        public final void setTermsAccepted(Boolean termsAccepted) {
            this.termsAccepted = termsAccepted;
        }

        @Override
        public final Builder termsAccepted(Boolean termsAccepted) {
            this.termsAccepted = termsAccepted;
            return this;
        }

        public final List<LicenseInfo.Builder> getLicenseInfo() {
            List<LicenseInfo.Builder> result = LicenseInfoListCopier.copyToBuilder(this.licenseInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLicenseInfo(Collection<LicenseInfo.BuilderImpl> licenseInfo) {
            this.licenseInfo = LicenseInfoListCopier.copyFromBuilder(licenseInfo);
        }

        @Override
        public final Builder licenseInfo(Collection<LicenseInfo> licenseInfo) {
            this.licenseInfo = LicenseInfoListCopier.copy(licenseInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseInfo(LicenseInfo ... licenseInfo) {
            this.licenseInfo(Arrays.asList(licenseInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseInfo(Consumer<LicenseInfo.Builder> ... licenseInfo) {
            this.licenseInfo(Stream.of(licenseInfo).map(c -> (LicenseInfo)((LicenseInfo.Builder)LicenseInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSiteId() {
            return this.siteId;
        }

        public final void setSiteId(String siteId) {
            this.siteId = siteId;
        }

        @Override
        public final Builder siteId(String siteId) {
            this.siteId = siteId;
            return this;
        }

        public final String getEnvironmentStatus() {
            return this.environmentStatus;
        }

        public final void setEnvironmentStatus(String environmentStatus) {
            this.environmentStatus = environmentStatus;
        }

        @Override
        public final Builder environmentStatus(String environmentStatus) {
            this.environmentStatus = environmentStatus;
            return this;
        }

        @Override
        public final Builder environmentStatus(CheckResult environmentStatus) {
            this.environmentStatus(environmentStatus == null ? null : environmentStatus.toString());
            return this;
        }

        public final List<Check.Builder> getChecks() {
            List<Check.Builder> result = ChecksListCopier.copyToBuilder(this.checks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChecks(Collection<Check.BuilderImpl> checks) {
            this.checks = ChecksListCopier.copyFromBuilder(checks);
        }

        @Override
        public final Builder checks(Collection<Check> checks) {
            this.checks = ChecksListCopier.copy(checks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checks(Check ... checks) {
            this.checks(Arrays.asList(checks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checks(Consumer<Check.Builder> ... checks) {
            this.checks(Stream.of(checks).map(c -> (Check)((Check.Builder)Check.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ConnectivityInfo.Builder getConnectivityInfo() {
            return this.connectivityInfo != null ? this.connectivityInfo.toBuilder() : null;
        }

        public final void setConnectivityInfo(ConnectivityInfo.BuilderImpl connectivityInfo) {
            this.connectivityInfo = connectivityInfo != null ? connectivityInfo.build() : null;
        }

        @Override
        public final Builder connectivityInfo(ConnectivityInfo connectivityInfo) {
            this.connectivityInfo = connectivityInfo;
            return this;
        }

        public final VcfHostnames.Builder getVcfHostnames() {
            return this.vcfHostnames != null ? this.vcfHostnames.toBuilder() : null;
        }

        public final void setVcfHostnames(VcfHostnames.BuilderImpl vcfHostnames) {
            this.vcfHostnames = vcfHostnames != null ? vcfHostnames.build() : null;
        }

        @Override
        public final Builder vcfHostnames(VcfHostnames vcfHostnames) {
            this.vcfHostnames = vcfHostnames;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final ServiceAccessSecurityGroups.Builder getServiceAccessSecurityGroups() {
            return this.serviceAccessSecurityGroups != null ? this.serviceAccessSecurityGroups.toBuilder() : null;
        }

        public final void setServiceAccessSecurityGroups(ServiceAccessSecurityGroups.BuilderImpl serviceAccessSecurityGroups) {
            this.serviceAccessSecurityGroups = serviceAccessSecurityGroups != null ? serviceAccessSecurityGroups.build() : null;
        }

        @Override
        public final Builder serviceAccessSecurityGroups(ServiceAccessSecurityGroups serviceAccessSecurityGroups) {
            this.serviceAccessSecurityGroups = serviceAccessSecurityGroups;
            return this;
        }

        public final List<Secret.Builder> getCredentials() {
            List<Secret.Builder> result = SecretListCopier.copyToBuilder(this.credentials);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCredentials(Collection<Secret.BuilderImpl> credentials) {
            this.credentials = SecretListCopier.copyFromBuilder(credentials);
        }

        @Override
        public final Builder credentials(Collection<Secret> credentials) {
            this.credentials = SecretListCopier.copy(credentials);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentials(Secret ... credentials) {
            this.credentials(Arrays.asList(credentials));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentials(Consumer<Secret.Builder> ... credentials) {
            this.credentials(Stream.of(credentials).map(c -> (Secret)((Secret.Builder)Secret.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Environment build() {
            return new Environment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Environment> {
        public Builder environmentId(String var1);

        public Builder environmentState(String var1);

        public Builder environmentState(EnvironmentState var1);

        public Builder stateDetails(String var1);

        public Builder createdAt(Instant var1);

        public Builder modifiedAt(Instant var1);

        public Builder environmentArn(String var1);

        public Builder environmentName(String var1);

        public Builder vpcId(String var1);

        public Builder serviceAccessSubnetId(String var1);

        public Builder vcfVersion(String var1);

        public Builder vcfVersion(VcfVersion var1);

        public Builder termsAccepted(Boolean var1);

        public Builder licenseInfo(Collection<LicenseInfo> var1);

        public Builder licenseInfo(LicenseInfo ... var1);

        public Builder licenseInfo(Consumer<LicenseInfo.Builder> ... var1);

        public Builder siteId(String var1);

        public Builder environmentStatus(String var1);

        public Builder environmentStatus(CheckResult var1);

        public Builder checks(Collection<Check> var1);

        public Builder checks(Check ... var1);

        public Builder checks(Consumer<Check.Builder> ... var1);

        public Builder connectivityInfo(ConnectivityInfo var1);

        default public Builder connectivityInfo(Consumer<ConnectivityInfo.Builder> connectivityInfo) {
            return this.connectivityInfo((ConnectivityInfo)((ConnectivityInfo.Builder)ConnectivityInfo.builder().applyMutation(connectivityInfo)).build());
        }

        public Builder vcfHostnames(VcfHostnames var1);

        default public Builder vcfHostnames(Consumer<VcfHostnames.Builder> vcfHostnames) {
            return this.vcfHostnames((VcfHostnames)((VcfHostnames.Builder)VcfHostnames.builder().applyMutation(vcfHostnames)).build());
        }

        public Builder kmsKeyId(String var1);

        public Builder serviceAccessSecurityGroups(ServiceAccessSecurityGroups var1);

        default public Builder serviceAccessSecurityGroups(Consumer<ServiceAccessSecurityGroups.Builder> serviceAccessSecurityGroups) {
            return this.serviceAccessSecurityGroups((ServiceAccessSecurityGroups)((ServiceAccessSecurityGroups.Builder)ServiceAccessSecurityGroups.builder().applyMutation(serviceAccessSecurityGroups)).build());
        }

        public Builder credentials(Collection<Secret> var1);

        public Builder credentials(Secret ... var1);

        public Builder credentials(Consumer<Secret.Builder> ... var1);
    }
}

