/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.evs.model.ConnectivityInfo;
import software.amazon.awssdk.services.evs.model.EvsRequest;
import software.amazon.awssdk.services.evs.model.HostInfoForCreate;
import software.amazon.awssdk.services.evs.model.HostInfoForCreateListCopier;
import software.amazon.awssdk.services.evs.model.InitialVlans;
import software.amazon.awssdk.services.evs.model.LicenseInfo;
import software.amazon.awssdk.services.evs.model.LicenseInfoListCopier;
import software.amazon.awssdk.services.evs.model.RequestTagMapCopier;
import software.amazon.awssdk.services.evs.model.ServiceAccessSecurityGroups;
import software.amazon.awssdk.services.evs.model.VcfHostnames;
import software.amazon.awssdk.services.evs.model.VcfVersion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEnvironmentRequest
extends EvsRequest
implements ToCopyableBuilder<Builder, CreateEnvironmentRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::clientToken)).setter(CreateEnvironmentRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentName").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::environmentName)).setter(CreateEnvironmentRequest.setter(Builder::environmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentName").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::kmsKeyId)).setter(CreateEnvironmentRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::tags)).setter(CreateEnvironmentRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<ServiceAccessSecurityGroups> SERVICE_ACCESS_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serviceAccessSecurityGroups").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::serviceAccessSecurityGroups)).setter(CreateEnvironmentRequest.setter(Builder::serviceAccessSecurityGroups)).constructor(ServiceAccessSecurityGroups::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccessSecurityGroups").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vpcId").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::vpcId)).setter(CreateEnvironmentRequest.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcId").build()}).build();
    private static final SdkField<String> SERVICE_ACCESS_SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceAccessSubnetId").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::serviceAccessSubnetId)).setter(CreateEnvironmentRequest.setter(Builder::serviceAccessSubnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccessSubnetId").build()}).build();
    private static final SdkField<String> VCF_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vcfVersion").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::vcfVersionAsString)).setter(CreateEnvironmentRequest.setter(Builder::vcfVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vcfVersion").build()}).build();
    private static final SdkField<Boolean> TERMS_ACCEPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("termsAccepted").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::termsAccepted)).setter(CreateEnvironmentRequest.setter(Builder::termsAccepted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("termsAccepted").build()}).build();
    private static final SdkField<List<LicenseInfo>> LICENSE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("licenseInfo").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::licenseInfo)).setter(CreateEnvironmentRequest.setter(Builder::licenseInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseInfo").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LicenseInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<InitialVlans> INITIAL_VLANS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("initialVlans").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::initialVlans)).setter(CreateEnvironmentRequest.setter(Builder::initialVlans)).constructor(InitialVlans::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialVlans").build()}).build();
    private static final SdkField<List<HostInfoForCreate>> HOSTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("hosts").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::hosts)).setter(CreateEnvironmentRequest.setter(Builder::hosts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hosts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HostInfoForCreate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ConnectivityInfo> CONNECTIVITY_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("connectivityInfo").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::connectivityInfo)).setter(CreateEnvironmentRequest.setter(Builder::connectivityInfo)).constructor(ConnectivityInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectivityInfo").build()}).build();
    private static final SdkField<VcfHostnames> VCF_HOSTNAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vcfHostnames").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::vcfHostnames)).setter(CreateEnvironmentRequest.setter(Builder::vcfHostnames)).constructor(VcfHostnames::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vcfHostnames").build()}).build();
    private static final SdkField<String> SITE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("siteId").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::siteId)).setter(CreateEnvironmentRequest.setter(Builder::siteId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("siteId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, ENVIRONMENT_NAME_FIELD, KMS_KEY_ID_FIELD, TAGS_FIELD, SERVICE_ACCESS_SECURITY_GROUPS_FIELD, VPC_ID_FIELD, SERVICE_ACCESS_SUBNET_ID_FIELD, VCF_VERSION_FIELD, TERMS_ACCEPTED_FIELD, LICENSE_INFO_FIELD, INITIAL_VLANS_FIELD, HOSTS_FIELD, CONNECTIVITY_INFO_FIELD, VCF_HOSTNAMES_FIELD, SITE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateEnvironmentRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String environmentName;
    private final String kmsKeyId;
    private final Map<String, String> tags;
    private final ServiceAccessSecurityGroups serviceAccessSecurityGroups;
    private final String vpcId;
    private final String serviceAccessSubnetId;
    private final String vcfVersion;
    private final Boolean termsAccepted;
    private final List<LicenseInfo> licenseInfo;
    private final InitialVlans initialVlans;
    private final List<HostInfoForCreate> hosts;
    private final ConnectivityInfo connectivityInfo;
    private final VcfHostnames vcfHostnames;
    private final String siteId;

    private CreateEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.environmentName = builder.environmentName;
        this.kmsKeyId = builder.kmsKeyId;
        this.tags = builder.tags;
        this.serviceAccessSecurityGroups = builder.serviceAccessSecurityGroups;
        this.vpcId = builder.vpcId;
        this.serviceAccessSubnetId = builder.serviceAccessSubnetId;
        this.vcfVersion = builder.vcfVersion;
        this.termsAccepted = builder.termsAccepted;
        this.licenseInfo = builder.licenseInfo;
        this.initialVlans = builder.initialVlans;
        this.hosts = builder.hosts;
        this.connectivityInfo = builder.connectivityInfo;
        this.vcfHostnames = builder.vcfHostnames;
        this.siteId = builder.siteId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String environmentName() {
        return this.environmentName;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final ServiceAccessSecurityGroups serviceAccessSecurityGroups() {
        return this.serviceAccessSecurityGroups;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final String serviceAccessSubnetId() {
        return this.serviceAccessSubnetId;
    }

    public final VcfVersion vcfVersion() {
        return VcfVersion.fromValue(this.vcfVersion);
    }

    public final String vcfVersionAsString() {
        return this.vcfVersion;
    }

    public final Boolean termsAccepted() {
        return this.termsAccepted;
    }

    public final boolean hasLicenseInfo() {
        return this.licenseInfo != null && !(this.licenseInfo instanceof SdkAutoConstructList);
    }

    public final List<LicenseInfo> licenseInfo() {
        return this.licenseInfo;
    }

    public final InitialVlans initialVlans() {
        return this.initialVlans;
    }

    public final boolean hasHosts() {
        return this.hosts != null && !(this.hosts instanceof SdkAutoConstructList);
    }

    public final List<HostInfoForCreate> hosts() {
        return this.hosts;
    }

    public final ConnectivityInfo connectivityInfo() {
        return this.connectivityInfo;
    }

    public final VcfHostnames vcfHostnames() {
        return this.vcfHostnames;
    }

    public final String siteId() {
        return this.siteId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccessSecurityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccessSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vcfVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.termsAccepted());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLicenseInfo() ? this.licenseInfo() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.initialVlans());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHosts() ? this.hosts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.connectivityInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.vcfHostnames());
        hashCode = 31 * hashCode + Objects.hashCode(this.siteId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentRequest)) {
            return false;
        }
        CreateEnvironmentRequest other = (CreateEnvironmentRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.serviceAccessSecurityGroups(), other.serviceAccessSecurityGroups()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.serviceAccessSubnetId(), other.serviceAccessSubnetId()) && Objects.equals(this.vcfVersionAsString(), other.vcfVersionAsString()) && Objects.equals(this.termsAccepted(), other.termsAccepted()) && this.hasLicenseInfo() == other.hasLicenseInfo() && Objects.equals(this.licenseInfo(), other.licenseInfo()) && Objects.equals(this.initialVlans(), other.initialVlans()) && this.hasHosts() == other.hasHosts() && Objects.equals(this.hosts(), other.hosts()) && Objects.equals(this.connectivityInfo(), other.connectivityInfo()) && Objects.equals(this.vcfHostnames(), other.vcfHostnames()) && Objects.equals(this.siteId(), other.siteId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEnvironmentRequest").add("ClientToken", (Object)this.clientToken()).add("EnvironmentName", (Object)this.environmentName()).add("KmsKeyId", (Object)this.kmsKeyId()).add("Tags", this.hasTags() ? this.tags() : null).add("ServiceAccessSecurityGroups", (Object)this.serviceAccessSecurityGroups()).add("VpcId", (Object)this.vpcId()).add("ServiceAccessSubnetId", (Object)this.serviceAccessSubnetId()).add("VcfVersion", (Object)this.vcfVersionAsString()).add("TermsAccepted", (Object)this.termsAccepted()).add("LicenseInfo", this.hasLicenseInfo() ? this.licenseInfo() : null).add("InitialVlans", (Object)this.initialVlans()).add("Hosts", this.hasHosts() ? this.hosts() : null).add("ConnectivityInfo", (Object)this.connectivityInfo()).add("VcfHostnames", (Object)this.vcfHostnames()).add("SiteId", (Object)this.siteId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "environmentName": {
                return Optional.ofNullable(clazz.cast(this.environmentName()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "serviceAccessSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.serviceAccessSecurityGroups()));
            }
            case "vpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "serviceAccessSubnetId": {
                return Optional.ofNullable(clazz.cast(this.serviceAccessSubnetId()));
            }
            case "vcfVersion": {
                return Optional.ofNullable(clazz.cast(this.vcfVersionAsString()));
            }
            case "termsAccepted": {
                return Optional.ofNullable(clazz.cast(this.termsAccepted()));
            }
            case "licenseInfo": {
                return Optional.ofNullable(clazz.cast(this.licenseInfo()));
            }
            case "initialVlans": {
                return Optional.ofNullable(clazz.cast(this.initialVlans()));
            }
            case "hosts": {
                return Optional.ofNullable(clazz.cast(this.hosts()));
            }
            case "connectivityInfo": {
                return Optional.ofNullable(clazz.cast(this.connectivityInfo()));
            }
            case "vcfHostnames": {
                return Optional.ofNullable(clazz.cast(this.vcfHostnames()));
            }
            case "siteId": {
                return Optional.ofNullable(clazz.cast(this.siteId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("environmentName", ENVIRONMENT_NAME_FIELD);
        map.put("kmsKeyId", KMS_KEY_ID_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("serviceAccessSecurityGroups", SERVICE_ACCESS_SECURITY_GROUPS_FIELD);
        map.put("vpcId", VPC_ID_FIELD);
        map.put("serviceAccessSubnetId", SERVICE_ACCESS_SUBNET_ID_FIELD);
        map.put("vcfVersion", VCF_VERSION_FIELD);
        map.put("termsAccepted", TERMS_ACCEPTED_FIELD);
        map.put("licenseInfo", LICENSE_INFO_FIELD);
        map.put("initialVlans", INITIAL_VLANS_FIELD);
        map.put("hosts", HOSTS_FIELD);
        map.put("connectivityInfo", CONNECTIVITY_INFO_FIELD);
        map.put("vcfHostnames", VCF_HOSTNAMES_FIELD);
        map.put("siteId", SITE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateEnvironmentRequest, T> g) {
        return obj -> g.apply((CreateEnvironmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EvsRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String environmentName;
        private String kmsKeyId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private ServiceAccessSecurityGroups serviceAccessSecurityGroups;
        private String vpcId;
        private String serviceAccessSubnetId;
        private String vcfVersion;
        private Boolean termsAccepted;
        private List<LicenseInfo> licenseInfo = DefaultSdkAutoConstructList.getInstance();
        private InitialVlans initialVlans;
        private List<HostInfoForCreate> hosts = DefaultSdkAutoConstructList.getInstance();
        private ConnectivityInfo connectivityInfo;
        private VcfHostnames vcfHostnames;
        private String siteId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.environmentName(model.environmentName);
            this.kmsKeyId(model.kmsKeyId);
            this.tags(model.tags);
            this.serviceAccessSecurityGroups(model.serviceAccessSecurityGroups);
            this.vpcId(model.vpcId);
            this.serviceAccessSubnetId(model.serviceAccessSubnetId);
            this.vcfVersion(model.vcfVersion);
            this.termsAccepted(model.termsAccepted);
            this.licenseInfo(model.licenseInfo);
            this.initialVlans(model.initialVlans);
            this.hosts(model.hosts);
            this.connectivityInfo(model.connectivityInfo);
            this.vcfHostnames(model.vcfHostnames);
            this.siteId(model.siteId);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = RequestTagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = RequestTagMapCopier.copy(tags);
            return this;
        }

        public final ServiceAccessSecurityGroups.Builder getServiceAccessSecurityGroups() {
            return this.serviceAccessSecurityGroups != null ? this.serviceAccessSecurityGroups.toBuilder() : null;
        }

        public final void setServiceAccessSecurityGroups(ServiceAccessSecurityGroups.BuilderImpl serviceAccessSecurityGroups) {
            this.serviceAccessSecurityGroups = serviceAccessSecurityGroups != null ? serviceAccessSecurityGroups.build() : null;
        }

        @Override
        public final Builder serviceAccessSecurityGroups(ServiceAccessSecurityGroups serviceAccessSecurityGroups) {
            this.serviceAccessSecurityGroups = serviceAccessSecurityGroups;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getServiceAccessSubnetId() {
            return this.serviceAccessSubnetId;
        }

        public final void setServiceAccessSubnetId(String serviceAccessSubnetId) {
            this.serviceAccessSubnetId = serviceAccessSubnetId;
        }

        @Override
        public final Builder serviceAccessSubnetId(String serviceAccessSubnetId) {
            this.serviceAccessSubnetId = serviceAccessSubnetId;
            return this;
        }

        public final String getVcfVersion() {
            return this.vcfVersion;
        }

        public final void setVcfVersion(String vcfVersion) {
            this.vcfVersion = vcfVersion;
        }

        @Override
        public final Builder vcfVersion(String vcfVersion) {
            this.vcfVersion = vcfVersion;
            return this;
        }

        @Override
        public final Builder vcfVersion(VcfVersion vcfVersion) {
            this.vcfVersion(vcfVersion == null ? null : vcfVersion.toString());
            return this;
        }

        public final Boolean getTermsAccepted() {
            return this.termsAccepted;
        }

        public final void setTermsAccepted(Boolean termsAccepted) {
            this.termsAccepted = termsAccepted;
        }

        @Override
        public final Builder termsAccepted(Boolean termsAccepted) {
            this.termsAccepted = termsAccepted;
            return this;
        }

        public final List<LicenseInfo.Builder> getLicenseInfo() {
            List<LicenseInfo.Builder> result = LicenseInfoListCopier.copyToBuilder(this.licenseInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLicenseInfo(Collection<LicenseInfo.BuilderImpl> licenseInfo) {
            this.licenseInfo = LicenseInfoListCopier.copyFromBuilder(licenseInfo);
        }

        @Override
        public final Builder licenseInfo(Collection<LicenseInfo> licenseInfo) {
            this.licenseInfo = LicenseInfoListCopier.copy(licenseInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseInfo(LicenseInfo ... licenseInfo) {
            this.licenseInfo(Arrays.asList(licenseInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseInfo(Consumer<LicenseInfo.Builder> ... licenseInfo) {
            this.licenseInfo(Stream.of(licenseInfo).map(c -> (LicenseInfo)((LicenseInfo.Builder)LicenseInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final InitialVlans.Builder getInitialVlans() {
            return this.initialVlans != null ? this.initialVlans.toBuilder() : null;
        }

        public final void setInitialVlans(InitialVlans.BuilderImpl initialVlans) {
            this.initialVlans = initialVlans != null ? initialVlans.build() : null;
        }

        @Override
        public final Builder initialVlans(InitialVlans initialVlans) {
            this.initialVlans = initialVlans;
            return this;
        }

        public final List<HostInfoForCreate.Builder> getHosts() {
            List<HostInfoForCreate.Builder> result = HostInfoForCreateListCopier.copyToBuilder(this.hosts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHosts(Collection<HostInfoForCreate.BuilderImpl> hosts) {
            this.hosts = HostInfoForCreateListCopier.copyFromBuilder(hosts);
        }

        @Override
        public final Builder hosts(Collection<HostInfoForCreate> hosts) {
            this.hosts = HostInfoForCreateListCopier.copy(hosts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hosts(HostInfoForCreate ... hosts) {
            this.hosts(Arrays.asList(hosts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hosts(Consumer<HostInfoForCreate.Builder> ... hosts) {
            this.hosts(Stream.of(hosts).map(c -> (HostInfoForCreate)((HostInfoForCreate.Builder)HostInfoForCreate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ConnectivityInfo.Builder getConnectivityInfo() {
            return this.connectivityInfo != null ? this.connectivityInfo.toBuilder() : null;
        }

        public final void setConnectivityInfo(ConnectivityInfo.BuilderImpl connectivityInfo) {
            this.connectivityInfo = connectivityInfo != null ? connectivityInfo.build() : null;
        }

        @Override
        public final Builder connectivityInfo(ConnectivityInfo connectivityInfo) {
            this.connectivityInfo = connectivityInfo;
            return this;
        }

        public final VcfHostnames.Builder getVcfHostnames() {
            return this.vcfHostnames != null ? this.vcfHostnames.toBuilder() : null;
        }

        public final void setVcfHostnames(VcfHostnames.BuilderImpl vcfHostnames) {
            this.vcfHostnames = vcfHostnames != null ? vcfHostnames.build() : null;
        }

        @Override
        public final Builder vcfHostnames(VcfHostnames vcfHostnames) {
            this.vcfHostnames = vcfHostnames;
            return this;
        }

        public final String getSiteId() {
            return this.siteId;
        }

        public final void setSiteId(String siteId) {
            this.siteId = siteId;
        }

        @Override
        public final Builder siteId(String siteId) {
            this.siteId = siteId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEnvironmentRequest build() {
            return new CreateEnvironmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EvsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEnvironmentRequest> {
        public Builder clientToken(String var1);

        public Builder environmentName(String var1);

        public Builder kmsKeyId(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder serviceAccessSecurityGroups(ServiceAccessSecurityGroups var1);

        default public Builder serviceAccessSecurityGroups(Consumer<ServiceAccessSecurityGroups.Builder> serviceAccessSecurityGroups) {
            return this.serviceAccessSecurityGroups((ServiceAccessSecurityGroups)((ServiceAccessSecurityGroups.Builder)ServiceAccessSecurityGroups.builder().applyMutation(serviceAccessSecurityGroups)).build());
        }

        public Builder vpcId(String var1);

        public Builder serviceAccessSubnetId(String var1);

        public Builder vcfVersion(String var1);

        public Builder vcfVersion(VcfVersion var1);

        public Builder termsAccepted(Boolean var1);

        public Builder licenseInfo(Collection<LicenseInfo> var1);

        public Builder licenseInfo(LicenseInfo ... var1);

        public Builder licenseInfo(Consumer<LicenseInfo.Builder> ... var1);

        public Builder initialVlans(InitialVlans var1);

        default public Builder initialVlans(Consumer<InitialVlans.Builder> initialVlans) {
            return this.initialVlans((InitialVlans)((InitialVlans.Builder)InitialVlans.builder().applyMutation(initialVlans)).build());
        }

        public Builder hosts(Collection<HostInfoForCreate> var1);

        public Builder hosts(HostInfoForCreate ... var1);

        public Builder hosts(Consumer<HostInfoForCreate.Builder> ... var1);

        public Builder connectivityInfo(ConnectivityInfo var1);

        default public Builder connectivityInfo(Consumer<ConnectivityInfo.Builder> connectivityInfo) {
            return this.connectivityInfo((ConnectivityInfo)((ConnectivityInfo.Builder)ConnectivityInfo.builder().applyMutation(connectivityInfo)).build());
        }

        public Builder vcfHostnames(VcfHostnames var1);

        default public Builder vcfHostnames(Consumer<VcfHostnames.Builder> vcfHostnames) {
            return this.vcfHostnames((VcfHostnames)((VcfHostnames.Builder)VcfHostnames.builder().applyMutation(vcfHostnames)).build());
        }

        public Builder siteId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

