/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.evs.model.CheckResult;
import software.amazon.awssdk.services.evs.model.EnvironmentState;
import software.amazon.awssdk.services.evs.model.VcfVersion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnvironmentSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnvironmentSummary> {
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(EnvironmentSummary.getter(EnvironmentSummary::environmentId)).setter(EnvironmentSummary.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()}).build();
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentName").getter(EnvironmentSummary.getter(EnvironmentSummary::environmentName)).setter(EnvironmentSummary.setter(Builder::environmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentName").build()}).build();
    private static final SdkField<String> VCF_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vcfVersion").getter(EnvironmentSummary.getter(EnvironmentSummary::vcfVersionAsString)).setter(EnvironmentSummary.setter(Builder::vcfVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vcfVersion").build()}).build();
    private static final SdkField<String> ENVIRONMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentStatus").getter(EnvironmentSummary.getter(EnvironmentSummary::environmentStatusAsString)).setter(EnvironmentSummary.setter(Builder::environmentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentStatus").build()}).build();
    private static final SdkField<String> ENVIRONMENT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentState").getter(EnvironmentSummary.getter(EnvironmentSummary::environmentStateAsString)).setter(EnvironmentSummary.setter(Builder::environmentState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentState").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(EnvironmentSummary.getter(EnvironmentSummary::createdAt)).setter(EnvironmentSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("modifiedAt").getter(EnvironmentSummary.getter(EnvironmentSummary::modifiedAt)).setter(EnvironmentSummary.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentArn").getter(EnvironmentSummary.getter(EnvironmentSummary::environmentArn)).setter(EnvironmentSummary.setter(Builder::environmentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_ID_FIELD, ENVIRONMENT_NAME_FIELD, VCF_VERSION_FIELD, ENVIRONMENT_STATUS_FIELD, ENVIRONMENT_STATE_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD, ENVIRONMENT_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EnvironmentSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String environmentId;
    private final String environmentName;
    private final String vcfVersion;
    private final String environmentStatus;
    private final String environmentState;
    private final Instant createdAt;
    private final Instant modifiedAt;
    private final String environmentArn;

    private EnvironmentSummary(BuilderImpl builder) {
        this.environmentId = builder.environmentId;
        this.environmentName = builder.environmentName;
        this.vcfVersion = builder.vcfVersion;
        this.environmentStatus = builder.environmentStatus;
        this.environmentState = builder.environmentState;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.environmentArn = builder.environmentArn;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final String environmentName() {
        return this.environmentName;
    }

    public final VcfVersion vcfVersion() {
        return VcfVersion.fromValue(this.vcfVersion);
    }

    public final String vcfVersionAsString() {
        return this.vcfVersion;
    }

    public final CheckResult environmentStatus() {
        return CheckResult.fromValue(this.environmentStatus);
    }

    public final String environmentStatusAsString() {
        return this.environmentStatus;
    }

    public final EnvironmentState environmentState() {
        return EnvironmentState.fromValue(this.environmentState);
    }

    public final String environmentStateAsString() {
        return this.environmentState;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public final String environmentArn() {
        return this.environmentArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vcfVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentSummary)) {
            return false;
        }
        EnvironmentSummary other = (EnvironmentSummary)obj;
        return Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.vcfVersionAsString(), other.vcfVersionAsString()) && Objects.equals(this.environmentStatusAsString(), other.environmentStatusAsString()) && Objects.equals(this.environmentStateAsString(), other.environmentStateAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.modifiedAt(), other.modifiedAt()) && Objects.equals(this.environmentArn(), other.environmentArn());
    }

    public final String toString() {
        return ToString.builder((String)"EnvironmentSummary").add("EnvironmentId", (Object)this.environmentId()).add("EnvironmentName", (Object)this.environmentName()).add("VcfVersion", (Object)this.vcfVersionAsString()).add("EnvironmentStatus", (Object)this.environmentStatusAsString()).add("EnvironmentState", (Object)this.environmentStateAsString()).add("CreatedAt", (Object)this.createdAt()).add("ModifiedAt", (Object)this.modifiedAt()).add("EnvironmentArn", (Object)this.environmentArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "environmentName": {
                return Optional.ofNullable(clazz.cast(this.environmentName()));
            }
            case "vcfVersion": {
                return Optional.ofNullable(clazz.cast(this.vcfVersionAsString()));
            }
            case "environmentStatus": {
                return Optional.ofNullable(clazz.cast(this.environmentStatusAsString()));
            }
            case "environmentState": {
                return Optional.ofNullable(clazz.cast(this.environmentStateAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "modifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
            case "environmentArn": {
                return Optional.ofNullable(clazz.cast(this.environmentArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("environmentName", ENVIRONMENT_NAME_FIELD);
        map.put("vcfVersion", VCF_VERSION_FIELD);
        map.put("environmentStatus", ENVIRONMENT_STATUS_FIELD);
        map.put("environmentState", ENVIRONMENT_STATE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("modifiedAt", MODIFIED_AT_FIELD);
        map.put("environmentArn", ENVIRONMENT_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentSummary, T> g) {
        return obj -> g.apply((EnvironmentSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String environmentId;
        private String environmentName;
        private String vcfVersion;
        private String environmentStatus;
        private String environmentState;
        private Instant createdAt;
        private Instant modifiedAt;
        private String environmentArn;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentSummary model) {
            this.environmentId(model.environmentId);
            this.environmentName(model.environmentName);
            this.vcfVersion(model.vcfVersion);
            this.environmentStatus(model.environmentStatus);
            this.environmentState(model.environmentState);
            this.createdAt(model.createdAt);
            this.modifiedAt(model.modifiedAt);
            this.environmentArn(model.environmentArn);
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getVcfVersion() {
            return this.vcfVersion;
        }

        public final void setVcfVersion(String vcfVersion) {
            this.vcfVersion = vcfVersion;
        }

        @Override
        public final Builder vcfVersion(String vcfVersion) {
            this.vcfVersion = vcfVersion;
            return this;
        }

        @Override
        public final Builder vcfVersion(VcfVersion vcfVersion) {
            this.vcfVersion(vcfVersion == null ? null : vcfVersion.toString());
            return this;
        }

        public final String getEnvironmentStatus() {
            return this.environmentStatus;
        }

        public final void setEnvironmentStatus(String environmentStatus) {
            this.environmentStatus = environmentStatus;
        }

        @Override
        public final Builder environmentStatus(String environmentStatus) {
            this.environmentStatus = environmentStatus;
            return this;
        }

        @Override
        public final Builder environmentStatus(CheckResult environmentStatus) {
            this.environmentStatus(environmentStatus == null ? null : environmentStatus.toString());
            return this;
        }

        public final String getEnvironmentState() {
            return this.environmentState;
        }

        public final void setEnvironmentState(String environmentState) {
            this.environmentState = environmentState;
        }

        @Override
        public final Builder environmentState(String environmentState) {
            this.environmentState = environmentState;
            return this;
        }

        @Override
        public final Builder environmentState(EnvironmentState environmentState) {
            this.environmentState(environmentState == null ? null : environmentState.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final String getEnvironmentArn() {
            return this.environmentArn;
        }

        public final void setEnvironmentArn(String environmentArn) {
            this.environmentArn = environmentArn;
        }

        @Override
        public final Builder environmentArn(String environmentArn) {
            this.environmentArn = environmentArn;
            return this;
        }

        public EnvironmentSummary build() {
            return new EnvironmentSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnvironmentSummary> {
        public Builder environmentId(String var1);

        public Builder environmentName(String var1);

        public Builder vcfVersion(String var1);

        public Builder vcfVersion(VcfVersion var1);

        public Builder environmentStatus(String var1);

        public Builder environmentStatus(CheckResult var1);

        public Builder environmentState(String var1);

        public Builder environmentState(EnvironmentState var1);

        public Builder createdAt(Instant var1);

        public Builder modifiedAt(Instant var1);

        public Builder environmentArn(String var1);
    }
}

