/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.evs.EvsClient;
import software.amazon.awssdk.services.evs.internal.UserAgentUtils;
import software.amazon.awssdk.services.evs.model.ListEnvironmentVlansRequest;
import software.amazon.awssdk.services.evs.model.ListEnvironmentVlansResponse;
import software.amazon.awssdk.services.evs.model.Vlan;

public class ListEnvironmentVlansIterable
implements SdkIterable<ListEnvironmentVlansResponse> {
    private final EvsClient client;
    private final ListEnvironmentVlansRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEnvironmentVlansIterable(EvsClient client, ListEnvironmentVlansRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEnvironmentVlansResponseFetcher();
    }

    public Iterator<ListEnvironmentVlansResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Vlan> environmentVlans() {
        Function<ListEnvironmentVlansResponse, Iterator> getIterator = response -> {
            if (response != null && response.environmentVlans() != null) {
                return response.environmentVlans().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEnvironmentVlansResponseFetcher
    implements SyncPageFetcher<ListEnvironmentVlansResponse> {
        private ListEnvironmentVlansResponseFetcher() {
        }

        public boolean hasNextPage(ListEnvironmentVlansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEnvironmentVlansResponse nextPage(ListEnvironmentVlansResponse previousPage) {
            if (previousPage == null) {
                return ListEnvironmentVlansIterable.this.client.listEnvironmentVlans(ListEnvironmentVlansIterable.this.firstRequest);
            }
            return ListEnvironmentVlansIterable.this.client.listEnvironmentVlans((ListEnvironmentVlansRequest)((Object)ListEnvironmentVlansIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

