/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.evs.model.EvsResponse;
import software.amazon.awssdk.services.evs.model.Host;
import software.amazon.awssdk.services.evs.model.HostListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEnvironmentHostsResponse
extends EvsResponse
implements ToCopyableBuilder<Builder, ListEnvironmentHostsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListEnvironmentHostsResponse.getter(ListEnvironmentHostsResponse::nextToken)).setter(ListEnvironmentHostsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<Host>> ENVIRONMENT_HOSTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("environmentHosts").getter(ListEnvironmentHostsResponse.getter(ListEnvironmentHostsResponse::environmentHosts)).setter(ListEnvironmentHostsResponse.setter(Builder::environmentHosts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentHosts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Host::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, ENVIRONMENT_HOSTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEnvironmentHostsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<Host> environmentHosts;

    private ListEnvironmentHostsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.environmentHosts = builder.environmentHosts;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasEnvironmentHosts() {
        return this.environmentHosts != null && !(this.environmentHosts instanceof SdkAutoConstructList);
    }

    public final List<Host> environmentHosts() {
        return this.environmentHosts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentHosts() ? this.environmentHosts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnvironmentHostsResponse)) {
            return false;
        }
        ListEnvironmentHostsResponse other = (ListEnvironmentHostsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasEnvironmentHosts() == other.hasEnvironmentHosts() && Objects.equals(this.environmentHosts(), other.environmentHosts());
    }

    public final String toString() {
        return ToString.builder((String)"ListEnvironmentHostsResponse").add("NextToken", (Object)this.nextToken()).add("EnvironmentHosts", this.hasEnvironmentHosts() ? this.environmentHosts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "environmentHosts": {
                return Optional.ofNullable(clazz.cast(this.environmentHosts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("environmentHosts", ENVIRONMENT_HOSTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEnvironmentHostsResponse, T> g) {
        return obj -> g.apply((ListEnvironmentHostsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EvsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<Host> environmentHosts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnvironmentHostsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.environmentHosts(model.environmentHosts);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Host.Builder> getEnvironmentHosts() {
            List<Host.Builder> result = HostListCopier.copyToBuilder(this.environmentHosts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentHosts(Collection<Host.BuilderImpl> environmentHosts) {
            this.environmentHosts = HostListCopier.copyFromBuilder(environmentHosts);
        }

        @Override
        public final Builder environmentHosts(Collection<Host> environmentHosts) {
            this.environmentHosts = HostListCopier.copy(environmentHosts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentHosts(Host ... environmentHosts) {
            this.environmentHosts(Arrays.asList(environmentHosts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentHosts(Consumer<Host.Builder> ... environmentHosts) {
            this.environmentHosts(Stream.of(environmentHosts).map(c -> (Host)((Host.Builder)Host.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListEnvironmentHostsResponse build() {
            return new ListEnvironmentHostsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EvsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEnvironmentHostsResponse> {
        public Builder nextToken(String var1);

        public Builder environmentHosts(Collection<Host> var1);

        public Builder environmentHosts(Host ... var1);

        public Builder environmentHosts(Consumer<Host.Builder> ... var1);
    }
}

