/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.evidently.model.EvidentlyRequest;
import software.amazon.awssdk.services.evidently.model.ProjectAppConfigResourceConfig;
import software.amazon.awssdk.services.evidently.model.ProjectDataDeliveryConfig;
import software.amazon.awssdk.services.evidently.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProjectRequest
extends EvidentlyRequest
implements ToCopyableBuilder<Builder, CreateProjectRequest> {
    private static final SdkField<ProjectAppConfigResourceConfig> APP_CONFIG_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("appConfigResource").getter(CreateProjectRequest.getter(CreateProjectRequest::appConfigResource)).setter(CreateProjectRequest.setter(Builder::appConfigResource)).constructor(ProjectAppConfigResourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appConfigResource").build()}).build();
    private static final SdkField<ProjectDataDeliveryConfig> DATA_DELIVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataDelivery").getter(CreateProjectRequest.getter(CreateProjectRequest::dataDelivery)).setter(CreateProjectRequest.setter(Builder::dataDelivery)).constructor(ProjectDataDeliveryConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataDelivery").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateProjectRequest.getter(CreateProjectRequest::description)).setter(CreateProjectRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateProjectRequest.getter(CreateProjectRequest::name)).setter(CreateProjectRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateProjectRequest.getter(CreateProjectRequest::tags)).setter(CreateProjectRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_CONFIG_RESOURCE_FIELD, DATA_DELIVERY_FIELD, DESCRIPTION_FIELD, NAME_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateProjectRequest.memberNameToFieldInitializer();
    private final ProjectAppConfigResourceConfig appConfigResource;
    private final ProjectDataDeliveryConfig dataDelivery;
    private final String description;
    private final String name;
    private final Map<String, String> tags;

    private CreateProjectRequest(BuilderImpl builder) {
        super(builder);
        this.appConfigResource = builder.appConfigResource;
        this.dataDelivery = builder.dataDelivery;
        this.description = builder.description;
        this.name = builder.name;
        this.tags = builder.tags;
    }

    public final ProjectAppConfigResourceConfig appConfigResource() {
        return this.appConfigResource;
    }

    public final ProjectDataDeliveryConfig dataDelivery() {
        return this.dataDelivery;
    }

    public final String description() {
        return this.description;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appConfigResource());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataDelivery());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProjectRequest)) {
            return false;
        }
        CreateProjectRequest other = (CreateProjectRequest)((Object)obj);
        return Objects.equals(this.appConfigResource(), other.appConfigResource()) && Objects.equals(this.dataDelivery(), other.dataDelivery()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateProjectRequest").add("AppConfigResource", (Object)this.appConfigResource()).add("DataDelivery", (Object)this.dataDelivery()).add("Description", (Object)this.description()).add("Name", (Object)this.name()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appConfigResource": {
                return Optional.ofNullable(clazz.cast(this.appConfigResource()));
            }
            case "dataDelivery": {
                return Optional.ofNullable(clazz.cast(this.dataDelivery()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appConfigResource", APP_CONFIG_RESOURCE_FIELD);
        map.put("dataDelivery", DATA_DELIVERY_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProjectRequest, T> g) {
        return obj -> g.apply((CreateProjectRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EvidentlyRequest.BuilderImpl
    implements Builder {
        private ProjectAppConfigResourceConfig appConfigResource;
        private ProjectDataDeliveryConfig dataDelivery;
        private String description;
        private String name;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProjectRequest model) {
            super(model);
            this.appConfigResource(model.appConfigResource);
            this.dataDelivery(model.dataDelivery);
            this.description(model.description);
            this.name(model.name);
            this.tags(model.tags);
        }

        public final ProjectAppConfigResourceConfig.Builder getAppConfigResource() {
            return this.appConfigResource != null ? this.appConfigResource.toBuilder() : null;
        }

        public final void setAppConfigResource(ProjectAppConfigResourceConfig.BuilderImpl appConfigResource) {
            this.appConfigResource = appConfigResource != null ? appConfigResource.build() : null;
        }

        @Override
        public final Builder appConfigResource(ProjectAppConfigResourceConfig appConfigResource) {
            this.appConfigResource = appConfigResource;
            return this;
        }

        public final ProjectDataDeliveryConfig.Builder getDataDelivery() {
            return this.dataDelivery != null ? this.dataDelivery.toBuilder() : null;
        }

        public final void setDataDelivery(ProjectDataDeliveryConfig.BuilderImpl dataDelivery) {
            this.dataDelivery = dataDelivery != null ? dataDelivery.build() : null;
        }

        @Override
        public final Builder dataDelivery(ProjectDataDeliveryConfig dataDelivery) {
            this.dataDelivery = dataDelivery;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProjectRequest build() {
            return new CreateProjectRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EvidentlyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateProjectRequest> {
        public Builder appConfigResource(ProjectAppConfigResourceConfig var1);

        default public Builder appConfigResource(Consumer<ProjectAppConfigResourceConfig.Builder> appConfigResource) {
            return this.appConfigResource((ProjectAppConfigResourceConfig)((ProjectAppConfigResourceConfig.Builder)ProjectAppConfigResourceConfig.builder().applyMutation(appConfigResource)).build());
        }

        public Builder dataDelivery(ProjectDataDeliveryConfig var1);

        default public Builder dataDelivery(Consumer<ProjectDataDeliveryConfig.Builder> dataDelivery) {
            return this.dataDelivery((ProjectDataDeliveryConfig)((ProjectDataDeliveryConfig.Builder)ProjectDataDeliveryConfig.builder().applyMutation(dataDelivery)).build());
        }

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

