/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.evidently.model.EntityOverrideMapCopier;
import software.amazon.awssdk.services.evidently.model.EvidentlyRequest;
import software.amazon.awssdk.services.evidently.model.FeatureEvaluationStrategy;
import software.amazon.awssdk.services.evidently.model.VariationConfig;
import software.amazon.awssdk.services.evidently.model.VariationConfigsListCopier;
import software.amazon.awssdk.services.evidently.model.VariationNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFeatureRequest
extends EvidentlyRequest
implements ToCopyableBuilder<Builder, UpdateFeatureRequest> {
    private static final SdkField<List<VariationConfig>> ADD_OR_UPDATE_VARIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("addOrUpdateVariations").getter(UpdateFeatureRequest.getter(UpdateFeatureRequest::addOrUpdateVariations)).setter(UpdateFeatureRequest.setter(Builder::addOrUpdateVariations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addOrUpdateVariations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VariationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DEFAULT_VARIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultVariation").getter(UpdateFeatureRequest.getter(UpdateFeatureRequest::defaultVariation)).setter(UpdateFeatureRequest.setter(Builder::defaultVariation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultVariation").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateFeatureRequest.getter(UpdateFeatureRequest::description)).setter(UpdateFeatureRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Map<String, String>> ENTITY_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("entityOverrides").getter(UpdateFeatureRequest.getter(UpdateFeatureRequest::entityOverrides)).setter(UpdateFeatureRequest.setter(Builder::entityOverrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityOverrides").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> EVALUATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("evaluationStrategy").getter(UpdateFeatureRequest.getter(UpdateFeatureRequest::evaluationStrategyAsString)).setter(UpdateFeatureRequest.setter(Builder::evaluationStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationStrategy").build()}).build();
    private static final SdkField<String> FEATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("feature").getter(UpdateFeatureRequest.getter(UpdateFeatureRequest::feature)).setter(UpdateFeatureRequest.setter(Builder::feature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("feature").build()}).build();
    private static final SdkField<String> PROJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("project").getter(UpdateFeatureRequest.getter(UpdateFeatureRequest::project)).setter(UpdateFeatureRequest.setter(Builder::project)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("project").build()}).build();
    private static final SdkField<List<String>> REMOVE_VARIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("removeVariations").getter(UpdateFeatureRequest.getter(UpdateFeatureRequest::removeVariations)).setter(UpdateFeatureRequest.setter(Builder::removeVariations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removeVariations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADD_OR_UPDATE_VARIATIONS_FIELD, DEFAULT_VARIATION_FIELD, DESCRIPTION_FIELD, ENTITY_OVERRIDES_FIELD, EVALUATION_STRATEGY_FIELD, FEATURE_FIELD, PROJECT_FIELD, REMOVE_VARIATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateFeatureRequest.memberNameToFieldInitializer();
    private final List<VariationConfig> addOrUpdateVariations;
    private final String defaultVariation;
    private final String description;
    private final Map<String, String> entityOverrides;
    private final String evaluationStrategy;
    private final String feature;
    private final String project;
    private final List<String> removeVariations;

    private UpdateFeatureRequest(BuilderImpl builder) {
        super(builder);
        this.addOrUpdateVariations = builder.addOrUpdateVariations;
        this.defaultVariation = builder.defaultVariation;
        this.description = builder.description;
        this.entityOverrides = builder.entityOverrides;
        this.evaluationStrategy = builder.evaluationStrategy;
        this.feature = builder.feature;
        this.project = builder.project;
        this.removeVariations = builder.removeVariations;
    }

    public final boolean hasAddOrUpdateVariations() {
        return this.addOrUpdateVariations != null && !(this.addOrUpdateVariations instanceof SdkAutoConstructList);
    }

    public final List<VariationConfig> addOrUpdateVariations() {
        return this.addOrUpdateVariations;
    }

    public final String defaultVariation() {
        return this.defaultVariation;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasEntityOverrides() {
        return this.entityOverrides != null && !(this.entityOverrides instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> entityOverrides() {
        return this.entityOverrides;
    }

    public final FeatureEvaluationStrategy evaluationStrategy() {
        return FeatureEvaluationStrategy.fromValue(this.evaluationStrategy);
    }

    public final String evaluationStrategyAsString() {
        return this.evaluationStrategy;
    }

    public final String feature() {
        return this.feature;
    }

    public final String project() {
        return this.project;
    }

    public final boolean hasRemoveVariations() {
        return this.removeVariations != null && !(this.removeVariations instanceof SdkAutoConstructList);
    }

    public final List<String> removeVariations() {
        return this.removeVariations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddOrUpdateVariations() ? this.addOrUpdateVariations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultVariation());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntityOverrides() ? this.entityOverrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.feature());
        hashCode = 31 * hashCode + Objects.hashCode(this.project());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveVariations() ? this.removeVariations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFeatureRequest)) {
            return false;
        }
        UpdateFeatureRequest other = (UpdateFeatureRequest)((Object)obj);
        return this.hasAddOrUpdateVariations() == other.hasAddOrUpdateVariations() && Objects.equals(this.addOrUpdateVariations(), other.addOrUpdateVariations()) && Objects.equals(this.defaultVariation(), other.defaultVariation()) && Objects.equals(this.description(), other.description()) && this.hasEntityOverrides() == other.hasEntityOverrides() && Objects.equals(this.entityOverrides(), other.entityOverrides()) && Objects.equals(this.evaluationStrategyAsString(), other.evaluationStrategyAsString()) && Objects.equals(this.feature(), other.feature()) && Objects.equals(this.project(), other.project()) && this.hasRemoveVariations() == other.hasRemoveVariations() && Objects.equals(this.removeVariations(), other.removeVariations());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFeatureRequest").add("AddOrUpdateVariations", this.hasAddOrUpdateVariations() ? this.addOrUpdateVariations() : null).add("DefaultVariation", (Object)this.defaultVariation()).add("Description", (Object)this.description()).add("EntityOverrides", this.hasEntityOverrides() ? this.entityOverrides() : null).add("EvaluationStrategy", (Object)this.evaluationStrategyAsString()).add("Feature", (Object)this.feature()).add("Project", (Object)this.project()).add("RemoveVariations", this.hasRemoveVariations() ? this.removeVariations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "addOrUpdateVariations": {
                return Optional.ofNullable(clazz.cast(this.addOrUpdateVariations()));
            }
            case "defaultVariation": {
                return Optional.ofNullable(clazz.cast(this.defaultVariation()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "entityOverrides": {
                return Optional.ofNullable(clazz.cast(this.entityOverrides()));
            }
            case "evaluationStrategy": {
                return Optional.ofNullable(clazz.cast(this.evaluationStrategyAsString()));
            }
            case "feature": {
                return Optional.ofNullable(clazz.cast(this.feature()));
            }
            case "project": {
                return Optional.ofNullable(clazz.cast(this.project()));
            }
            case "removeVariations": {
                return Optional.ofNullable(clazz.cast(this.removeVariations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("addOrUpdateVariations", ADD_OR_UPDATE_VARIATIONS_FIELD);
        map.put("defaultVariation", DEFAULT_VARIATION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("entityOverrides", ENTITY_OVERRIDES_FIELD);
        map.put("evaluationStrategy", EVALUATION_STRATEGY_FIELD);
        map.put("feature", FEATURE_FIELD);
        map.put("project", PROJECT_FIELD);
        map.put("removeVariations", REMOVE_VARIATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFeatureRequest, T> g) {
        return obj -> g.apply((UpdateFeatureRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EvidentlyRequest.BuilderImpl
    implements Builder {
        private List<VariationConfig> addOrUpdateVariations = DefaultSdkAutoConstructList.getInstance();
        private String defaultVariation;
        private String description;
        private Map<String, String> entityOverrides = DefaultSdkAutoConstructMap.getInstance();
        private String evaluationStrategy;
        private String feature;
        private String project;
        private List<String> removeVariations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFeatureRequest model) {
            super(model);
            this.addOrUpdateVariations(model.addOrUpdateVariations);
            this.defaultVariation(model.defaultVariation);
            this.description(model.description);
            this.entityOverrides(model.entityOverrides);
            this.evaluationStrategy(model.evaluationStrategy);
            this.feature(model.feature);
            this.project(model.project);
            this.removeVariations(model.removeVariations);
        }

        public final List<VariationConfig.Builder> getAddOrUpdateVariations() {
            List<VariationConfig.Builder> result = VariationConfigsListCopier.copyToBuilder(this.addOrUpdateVariations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddOrUpdateVariations(Collection<VariationConfig.BuilderImpl> addOrUpdateVariations) {
            this.addOrUpdateVariations = VariationConfigsListCopier.copyFromBuilder(addOrUpdateVariations);
        }

        @Override
        public final Builder addOrUpdateVariations(Collection<VariationConfig> addOrUpdateVariations) {
            this.addOrUpdateVariations = VariationConfigsListCopier.copy(addOrUpdateVariations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOrUpdateVariations(VariationConfig ... addOrUpdateVariations) {
            this.addOrUpdateVariations(Arrays.asList(addOrUpdateVariations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOrUpdateVariations(Consumer<VariationConfig.Builder> ... addOrUpdateVariations) {
            this.addOrUpdateVariations(Stream.of(addOrUpdateVariations).map(c -> (VariationConfig)((VariationConfig.Builder)VariationConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDefaultVariation() {
            return this.defaultVariation;
        }

        public final void setDefaultVariation(String defaultVariation) {
            this.defaultVariation = defaultVariation;
        }

        @Override
        public final Builder defaultVariation(String defaultVariation) {
            this.defaultVariation = defaultVariation;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getEntityOverrides() {
            if (this.entityOverrides instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.entityOverrides;
        }

        public final void setEntityOverrides(Map<String, String> entityOverrides) {
            this.entityOverrides = EntityOverrideMapCopier.copy(entityOverrides);
        }

        @Override
        public final Builder entityOverrides(Map<String, String> entityOverrides) {
            this.entityOverrides = EntityOverrideMapCopier.copy(entityOverrides);
            return this;
        }

        public final String getEvaluationStrategy() {
            return this.evaluationStrategy;
        }

        public final void setEvaluationStrategy(String evaluationStrategy) {
            this.evaluationStrategy = evaluationStrategy;
        }

        @Override
        public final Builder evaluationStrategy(String evaluationStrategy) {
            this.evaluationStrategy = evaluationStrategy;
            return this;
        }

        @Override
        public final Builder evaluationStrategy(FeatureEvaluationStrategy evaluationStrategy) {
            this.evaluationStrategy(evaluationStrategy == null ? null : evaluationStrategy.toString());
            return this;
        }

        public final String getFeature() {
            return this.feature;
        }

        public final void setFeature(String feature) {
            this.feature = feature;
        }

        @Override
        public final Builder feature(String feature) {
            this.feature = feature;
            return this;
        }

        public final String getProject() {
            return this.project;
        }

        public final void setProject(String project) {
            this.project = project;
        }

        @Override
        public final Builder project(String project) {
            this.project = project;
            return this;
        }

        public final Collection<String> getRemoveVariations() {
            if (this.removeVariations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.removeVariations;
        }

        public final void setRemoveVariations(Collection<String> removeVariations) {
            this.removeVariations = VariationNameListCopier.copy(removeVariations);
        }

        @Override
        public final Builder removeVariations(Collection<String> removeVariations) {
            this.removeVariations = VariationNameListCopier.copy(removeVariations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeVariations(String ... removeVariations) {
            this.removeVariations(Arrays.asList(removeVariations));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFeatureRequest build() {
            return new UpdateFeatureRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EvidentlyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFeatureRequest> {
        public Builder addOrUpdateVariations(Collection<VariationConfig> var1);

        public Builder addOrUpdateVariations(VariationConfig ... var1);

        public Builder addOrUpdateVariations(Consumer<VariationConfig.Builder> ... var1);

        public Builder defaultVariation(String var1);

        public Builder description(String var1);

        public Builder entityOverrides(Map<String, String> var1);

        public Builder evaluationStrategy(String var1);

        public Builder evaluationStrategy(FeatureEvaluationStrategy var1);

        public Builder feature(String var1);

        public Builder project(String var1);

        public Builder removeVariations(Collection<String> var1);

        public Builder removeVariations(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

