/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.evidently.model.FeatureToVariationMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Treatment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Treatment> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Treatment.getter(Treatment::description)).setter(Treatment.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Map<String, String>> FEATURE_VARIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("featureVariations").getter(Treatment.getter(Treatment::featureVariations)).setter(Treatment.setter(Builder::featureVariations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("featureVariations").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Treatment.getter(Treatment::name)).setter(Treatment.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, FEATURE_VARIATIONS_FIELD, NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Treatment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String description;
    private final Map<String, String> featureVariations;
    private final String name;

    private Treatment(BuilderImpl builder) {
        this.description = builder.description;
        this.featureVariations = builder.featureVariations;
        this.name = builder.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasFeatureVariations() {
        return this.featureVariations != null && !(this.featureVariations instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> featureVariations() {
        return this.featureVariations;
    }

    public final String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeatureVariations() ? this.featureVariations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Treatment)) {
            return false;
        }
        Treatment other = (Treatment)obj;
        return Objects.equals(this.description(), other.description()) && this.hasFeatureVariations() == other.hasFeatureVariations() && Objects.equals(this.featureVariations(), other.featureVariations()) && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder((String)"Treatment").add("Description", (Object)this.description()).add("FeatureVariations", this.hasFeatureVariations() ? this.featureVariations() : null).add("Name", (Object)this.name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "featureVariations": {
                return Optional.ofNullable(clazz.cast(this.featureVariations()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("featureVariations", FEATURE_VARIATIONS_FIELD);
        map.put("name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Treatment, T> g) {
        return obj -> g.apply((Treatment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private Map<String, String> featureVariations = DefaultSdkAutoConstructMap.getInstance();
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(Treatment model) {
            this.description(model.description);
            this.featureVariations(model.featureVariations);
            this.name(model.name);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getFeatureVariations() {
            if (this.featureVariations instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.featureVariations;
        }

        public final void setFeatureVariations(Map<String, String> featureVariations) {
            this.featureVariations = FeatureToVariationMapCopier.copy(featureVariations);
        }

        @Override
        public final Builder featureVariations(Map<String, String> featureVariations) {
            this.featureVariations = FeatureToVariationMapCopier.copy(featureVariations);
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public Treatment build() {
            return new Treatment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Treatment> {
        public Builder description(String var1);

        public Builder featureVariations(Map<String, String> var1);

        public Builder name(String var1);
    }
}

