/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.evidently.model.EvidentlyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartExperimentRequest
extends EvidentlyRequest
implements ToCopyableBuilder<Builder, StartExperimentRequest> {
    private static final SdkField<Instant> ANALYSIS_COMPLETE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("analysisCompleteTime").getter(StartExperimentRequest.getter(StartExperimentRequest::analysisCompleteTime)).setter(StartExperimentRequest.setter(Builder::analysisCompleteTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisCompleteTime").build()}).build();
    private static final SdkField<String> EXPERIMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("experiment").getter(StartExperimentRequest.getter(StartExperimentRequest::experiment)).setter(StartExperimentRequest.setter(Builder::experiment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("experiment").build()}).build();
    private static final SdkField<String> PROJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("project").getter(StartExperimentRequest.getter(StartExperimentRequest::project)).setter(StartExperimentRequest.setter(Builder::project)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("project").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_COMPLETE_TIME_FIELD, EXPERIMENT_FIELD, PROJECT_FIELD));
    private final Instant analysisCompleteTime;
    private final String experiment;
    private final String project;

    private StartExperimentRequest(BuilderImpl builder) {
        super(builder);
        this.analysisCompleteTime = builder.analysisCompleteTime;
        this.experiment = builder.experiment;
        this.project = builder.project;
    }

    public final Instant analysisCompleteTime() {
        return this.analysisCompleteTime;
    }

    public final String experiment() {
        return this.experiment;
    }

    public final String project() {
        return this.project;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisCompleteTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.experiment());
        hashCode = 31 * hashCode + Objects.hashCode(this.project());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartExperimentRequest)) {
            return false;
        }
        StartExperimentRequest other = (StartExperimentRequest)((Object)obj);
        return Objects.equals(this.analysisCompleteTime(), other.analysisCompleteTime()) && Objects.equals(this.experiment(), other.experiment()) && Objects.equals(this.project(), other.project());
    }

    public final String toString() {
        return ToString.builder((String)"StartExperimentRequest").add("AnalysisCompleteTime", (Object)this.analysisCompleteTime()).add("Experiment", (Object)this.experiment()).add("Project", (Object)this.project()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "analysisCompleteTime": {
                return Optional.ofNullable(clazz.cast(this.analysisCompleteTime()));
            }
            case "experiment": {
                return Optional.ofNullable(clazz.cast(this.experiment()));
            }
            case "project": {
                return Optional.ofNullable(clazz.cast(this.project()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartExperimentRequest, T> g) {
        return obj -> g.apply((StartExperimentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EvidentlyRequest.BuilderImpl
    implements Builder {
        private Instant analysisCompleteTime;
        private String experiment;
        private String project;

        private BuilderImpl() {
        }

        private BuilderImpl(StartExperimentRequest model) {
            super(model);
            this.analysisCompleteTime(model.analysisCompleteTime);
            this.experiment(model.experiment);
            this.project(model.project);
        }

        public final Instant getAnalysisCompleteTime() {
            return this.analysisCompleteTime;
        }

        public final void setAnalysisCompleteTime(Instant analysisCompleteTime) {
            this.analysisCompleteTime = analysisCompleteTime;
        }

        @Override
        public final Builder analysisCompleteTime(Instant analysisCompleteTime) {
            this.analysisCompleteTime = analysisCompleteTime;
            return this;
        }

        public final String getExperiment() {
            return this.experiment;
        }

        public final void setExperiment(String experiment) {
            this.experiment = experiment;
        }

        @Override
        public final Builder experiment(String experiment) {
            this.experiment = experiment;
            return this;
        }

        public final String getProject() {
            return this.project;
        }

        public final void setProject(String project) {
            this.project = project;
        }

        @Override
        public final Builder project(String project) {
            this.project = project;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartExperimentRequest build() {
            return new StartExperimentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EvidentlyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartExperimentRequest> {
        public Builder analysisCompleteTime(Instant var1);

        public Builder experiment(String var1);

        public Builder project(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

