/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.evidently.model.GroupToWeightMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SegmentOverride
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SegmentOverride> {
    private static final SdkField<Long> EVALUATION_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("evaluationOrder").getter(SegmentOverride.getter(SegmentOverride::evaluationOrder)).setter(SegmentOverride.setter(Builder::evaluationOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationOrder").build()}).build();
    private static final SdkField<String> SEGMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("segment").getter(SegmentOverride.getter(SegmentOverride::segment)).setter(SegmentOverride.setter(Builder::segment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segment").build()}).build();
    private static final SdkField<Map<String, Long>> WEIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("weights").getter(SegmentOverride.getter(SegmentOverride::weights)).setter(SegmentOverride.setter(Builder::weights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("weights").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LONG).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_ORDER_FIELD, SEGMENT_FIELD, WEIGHTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long evaluationOrder;
    private final String segment;
    private final Map<String, Long> weights;

    private SegmentOverride(BuilderImpl builder) {
        this.evaluationOrder = builder.evaluationOrder;
        this.segment = builder.segment;
        this.weights = builder.weights;
    }

    public final Long evaluationOrder() {
        return this.evaluationOrder;
    }

    public final String segment() {
        return this.segment;
    }

    public final boolean hasWeights() {
        return this.weights != null && !(this.weights instanceof SdkAutoConstructMap);
    }

    public final Map<String, Long> weights() {
        return this.weights;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationOrder());
        hashCode = 31 * hashCode + Objects.hashCode(this.segment());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWeights() ? this.weights() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentOverride)) {
            return false;
        }
        SegmentOverride other = (SegmentOverride)obj;
        return Objects.equals(this.evaluationOrder(), other.evaluationOrder()) && Objects.equals(this.segment(), other.segment()) && this.hasWeights() == other.hasWeights() && Objects.equals(this.weights(), other.weights());
    }

    public final String toString() {
        return ToString.builder((String)"SegmentOverride").add("EvaluationOrder", (Object)this.evaluationOrder()).add("Segment", (Object)this.segment()).add("Weights", this.hasWeights() ? this.weights() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "evaluationOrder": {
                return Optional.ofNullable(clazz.cast(this.evaluationOrder()));
            }
            case "segment": {
                return Optional.ofNullable(clazz.cast(this.segment()));
            }
            case "weights": {
                return Optional.ofNullable(clazz.cast(this.weights()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SegmentOverride, T> g) {
        return obj -> g.apply((SegmentOverride)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long evaluationOrder;
        private String segment;
        private Map<String, Long> weights = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentOverride model) {
            this.evaluationOrder(model.evaluationOrder);
            this.segment(model.segment);
            this.weights(model.weights);
        }

        public final Long getEvaluationOrder() {
            return this.evaluationOrder;
        }

        public final void setEvaluationOrder(Long evaluationOrder) {
            this.evaluationOrder = evaluationOrder;
        }

        @Override
        public final Builder evaluationOrder(Long evaluationOrder) {
            this.evaluationOrder = evaluationOrder;
            return this;
        }

        public final String getSegment() {
            return this.segment;
        }

        public final void setSegment(String segment) {
            this.segment = segment;
        }

        @Override
        public final Builder segment(String segment) {
            this.segment = segment;
            return this;
        }

        public final Map<String, Long> getWeights() {
            if (this.weights instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.weights;
        }

        public final void setWeights(Map<String, Long> weights) {
            this.weights = GroupToWeightMapCopier.copy(weights);
        }

        @Override
        public final Builder weights(Map<String, Long> weights) {
            this.weights = GroupToWeightMapCopier.copy(weights);
            return this;
        }

        public SegmentOverride build() {
            return new SegmentOverride(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SegmentOverride> {
        public Builder evaluationOrder(Long var1);

        public Builder segment(String var1);

        public Builder weights(Map<String, Long> var1);
    }
}

