/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.evidently.model.GroupToWeightMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduledSplitConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScheduledSplitConfig> {
    private static final SdkField<Map<String, Long>> GROUP_WEIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("groupWeights").getter(ScheduledSplitConfig.getter(ScheduledSplitConfig::groupWeights)).setter(ScheduledSplitConfig.setter(Builder::groupWeights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupWeights").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LONG).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(ScheduledSplitConfig.getter(ScheduledSplitConfig::startTime)).setter(ScheduledSplitConfig.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_WEIGHTS_FIELD, START_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, Long> groupWeights;
    private final Instant startTime;

    private ScheduledSplitConfig(BuilderImpl builder) {
        this.groupWeights = builder.groupWeights;
        this.startTime = builder.startTime;
    }

    public final boolean hasGroupWeights() {
        return this.groupWeights != null && !(this.groupWeights instanceof SdkAutoConstructMap);
    }

    public final Map<String, Long> groupWeights() {
        return this.groupWeights;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupWeights() ? this.groupWeights() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledSplitConfig)) {
            return false;
        }
        ScheduledSplitConfig other = (ScheduledSplitConfig)obj;
        return this.hasGroupWeights() == other.hasGroupWeights() && Objects.equals(this.groupWeights(), other.groupWeights()) && Objects.equals(this.startTime(), other.startTime());
    }

    public final String toString() {
        return ToString.builder((String)"ScheduledSplitConfig").add("GroupWeights", this.hasGroupWeights() ? this.groupWeights() : null).add("StartTime", (Object)this.startTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "groupWeights": {
                return Optional.ofNullable(clazz.cast(this.groupWeights()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduledSplitConfig, T> g) {
        return obj -> g.apply((ScheduledSplitConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, Long> groupWeights = DefaultSdkAutoConstructMap.getInstance();
        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledSplitConfig model) {
            this.groupWeights(model.groupWeights);
            this.startTime(model.startTime);
        }

        public final Map<String, Long> getGroupWeights() {
            if (this.groupWeights instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.groupWeights;
        }

        public final void setGroupWeights(Map<String, Long> groupWeights) {
            this.groupWeights = GroupToWeightMapCopier.copy(groupWeights);
        }

        @Override
        public final Builder groupWeights(Map<String, Long> groupWeights) {
            this.groupWeights = GroupToWeightMapCopier.copy(groupWeights);
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public ScheduledSplitConfig build() {
            return new ScheduledSplitConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScheduledSplitConfig> {
        public Builder groupWeights(Map<String, Long> var1);

        public Builder startTime(Instant var1);
    }
}

