/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.evidently.model.CloudWatchLogsDestinationConfig;
import software.amazon.awssdk.services.evidently.model.S3DestinationConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProjectDataDeliveryConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProjectDataDeliveryConfig> {
    private static final SdkField<CloudWatchLogsDestinationConfig> CLOUD_WATCH_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cloudWatchLogs").getter(ProjectDataDeliveryConfig.getter(ProjectDataDeliveryConfig::cloudWatchLogs)).setter(ProjectDataDeliveryConfig.setter(Builder::cloudWatchLogs)).constructor(CloudWatchLogsDestinationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLogs").build()}).build();
    private static final SdkField<S3DestinationConfig> S3_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3Destination").getter(ProjectDataDeliveryConfig.getter(ProjectDataDeliveryConfig::s3Destination)).setter(ProjectDataDeliveryConfig.setter(Builder::s3Destination)).constructor(S3DestinationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Destination").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_LOGS_FIELD, S3_DESTINATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final CloudWatchLogsDestinationConfig cloudWatchLogs;
    private final S3DestinationConfig s3Destination;

    private ProjectDataDeliveryConfig(BuilderImpl builder) {
        this.cloudWatchLogs = builder.cloudWatchLogs;
        this.s3Destination = builder.s3Destination;
    }

    public final CloudWatchLogsDestinationConfig cloudWatchLogs() {
        return this.cloudWatchLogs;
    }

    public final S3DestinationConfig s3Destination() {
        return this.s3Destination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Destination());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectDataDeliveryConfig)) {
            return false;
        }
        ProjectDataDeliveryConfig other = (ProjectDataDeliveryConfig)obj;
        return Objects.equals(this.cloudWatchLogs(), other.cloudWatchLogs()) && Objects.equals(this.s3Destination(), other.s3Destination());
    }

    public final String toString() {
        return ToString.builder((String)"ProjectDataDeliveryConfig").add("CloudWatchLogs", (Object)this.cloudWatchLogs()).add("S3Destination", (Object)this.s3Destination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cloudWatchLogs": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogs()));
            }
            case "s3Destination": {
                return Optional.ofNullable(clazz.cast(this.s3Destination()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProjectDataDeliveryConfig, T> g) {
        return obj -> g.apply((ProjectDataDeliveryConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CloudWatchLogsDestinationConfig cloudWatchLogs;
        private S3DestinationConfig s3Destination;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectDataDeliveryConfig model) {
            this.cloudWatchLogs(model.cloudWatchLogs);
            this.s3Destination(model.s3Destination);
        }

        public final CloudWatchLogsDestinationConfig.Builder getCloudWatchLogs() {
            return this.cloudWatchLogs != null ? this.cloudWatchLogs.toBuilder() : null;
        }

        public final void setCloudWatchLogs(CloudWatchLogsDestinationConfig.BuilderImpl cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs != null ? cloudWatchLogs.build() : null;
        }

        @Override
        @Transient
        public final Builder cloudWatchLogs(CloudWatchLogsDestinationConfig cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs;
            return this;
        }

        public final S3DestinationConfig.Builder getS3Destination() {
            return this.s3Destination != null ? this.s3Destination.toBuilder() : null;
        }

        public final void setS3Destination(S3DestinationConfig.BuilderImpl s3Destination) {
            this.s3Destination = s3Destination != null ? s3Destination.build() : null;
        }

        @Override
        @Transient
        public final Builder s3Destination(S3DestinationConfig s3Destination) {
            this.s3Destination = s3Destination;
            return this;
        }

        public ProjectDataDeliveryConfig build() {
            return new ProjectDataDeliveryConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProjectDataDeliveryConfig> {
        public Builder cloudWatchLogs(CloudWatchLogsDestinationConfig var1);

        default public Builder cloudWatchLogs(Consumer<CloudWatchLogsDestinationConfig.Builder> cloudWatchLogs) {
            return this.cloudWatchLogs((CloudWatchLogsDestinationConfig)((CloudWatchLogsDestinationConfig.Builder)CloudWatchLogsDestinationConfig.builder().applyMutation(cloudWatchLogs)).build());
        }

        public Builder s3Destination(S3DestinationConfig var1);

        default public Builder s3Destination(Consumer<S3DestinationConfig.Builder> s3Destination) {
            return this.s3Destination((S3DestinationConfig)((S3DestinationConfig.Builder)S3DestinationConfig.builder().applyMutation(s3Destination)).build());
        }
    }
}

