/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationRequest> {
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityId").getter(EvaluationRequest.getter(EvaluationRequest::entityId)).setter(EvaluationRequest.setter(Builder::entityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityId").build()}).build();
    private static final SdkField<String> EVALUATION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("evaluationContext").getter(EvaluationRequest.getter(EvaluationRequest::evaluationContext)).setter(EvaluationRequest.setter(Builder::evaluationContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationContext").build(), JsonValueTrait.create()}).build();
    private static final SdkField<String> FEATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("feature").getter(EvaluationRequest.getter(EvaluationRequest::feature)).setter(EvaluationRequest.setter(Builder::feature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("feature").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_ID_FIELD, EVALUATION_CONTEXT_FIELD, FEATURE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String entityId;
    private final String evaluationContext;
    private final String feature;

    private EvaluationRequest(BuilderImpl builder) {
        this.entityId = builder.entityId;
        this.evaluationContext = builder.evaluationContext;
        this.feature = builder.feature;
    }

    public final String entityId() {
        return this.entityId;
    }

    public final String evaluationContext() {
        return this.evaluationContext;
    }

    public final String feature() {
        return this.feature;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.feature());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationRequest)) {
            return false;
        }
        EvaluationRequest other = (EvaluationRequest)obj;
        return Objects.equals(this.entityId(), other.entityId()) && Objects.equals(this.evaluationContext(), other.evaluationContext()) && Objects.equals(this.feature(), other.feature());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationRequest").add("EntityId", (Object)this.entityId()).add("EvaluationContext", (Object)this.evaluationContext()).add("Feature", (Object)this.feature()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entityId": {
                return Optional.ofNullable(clazz.cast(this.entityId()));
            }
            case "evaluationContext": {
                return Optional.ofNullable(clazz.cast(this.evaluationContext()));
            }
            case "feature": {
                return Optional.ofNullable(clazz.cast(this.feature()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluationRequest, T> g) {
        return obj -> g.apply((EvaluationRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String entityId;
        private String evaluationContext;
        private String feature;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationRequest model) {
            this.entityId(model.entityId);
            this.evaluationContext(model.evaluationContext);
            this.feature(model.feature);
        }

        public final String getEntityId() {
            return this.entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        @Transient
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getEvaluationContext() {
            return this.evaluationContext;
        }

        public final void setEvaluationContext(String evaluationContext) {
            this.evaluationContext = evaluationContext;
        }

        @Override
        @Transient
        public final Builder evaluationContext(String evaluationContext) {
            this.evaluationContext = evaluationContext;
            return this;
        }

        public final String getFeature() {
            return this.feature;
        }

        public final void setFeature(String feature) {
            this.feature = feature;
        }

        @Override
        @Transient
        public final Builder feature(String feature) {
            this.feature = feature;
            return this;
        }

        public EvaluationRequest build() {
            return new EvaluationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationRequest> {
        public Builder entityId(String var1);

        public Builder evaluationContext(String var1);

        public Builder feature(String var1);
    }
}

