/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.evidently.model.EvidentlyResponse;
import software.amazon.awssdk.services.evidently.model.ExperimentReport;
import software.amazon.awssdk.services.evidently.model.ExperimentReportListCopier;
import software.amazon.awssdk.services.evidently.model.ExperimentResultsData;
import software.amazon.awssdk.services.evidently.model.ExperimentResultsDataListCopier;
import software.amazon.awssdk.services.evidently.model.TimestampListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetExperimentResultsResponse
extends EvidentlyResponse
implements ToCopyableBuilder<Builder, GetExperimentResultsResponse> {
    private static final SdkField<List<ExperimentReport>> REPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("reports").getter(GetExperimentResultsResponse.getter(GetExperimentResultsResponse::reports)).setter(GetExperimentResultsResponse.setter(Builder::reports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExperimentReport::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ExperimentResultsData>> RESULTS_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resultsData").getter(GetExperimentResultsResponse.getter(GetExperimentResultsResponse::resultsData)).setter(GetExperimentResultsResponse.setter(Builder::resultsData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultsData").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExperimentResultsData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Instant>> TIMESTAMPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("timestamps").getter(GetExperimentResultsResponse.getter(GetExperimentResultsResponse::timestamps)).setter(GetExperimentResultsResponse.setter(Builder::timestamps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INSTANT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORTS_FIELD, RESULTS_DATA_FIELD, TIMESTAMPS_FIELD));
    private final List<ExperimentReport> reports;
    private final List<ExperimentResultsData> resultsData;
    private final List<Instant> timestamps;

    private GetExperimentResultsResponse(BuilderImpl builder) {
        super(builder);
        this.reports = builder.reports;
        this.resultsData = builder.resultsData;
        this.timestamps = builder.timestamps;
    }

    public final boolean hasReports() {
        return this.reports != null && !(this.reports instanceof SdkAutoConstructList);
    }

    public final List<ExperimentReport> reports() {
        return this.reports;
    }

    public final boolean hasResultsData() {
        return this.resultsData != null && !(this.resultsData instanceof SdkAutoConstructList);
    }

    public final List<ExperimentResultsData> resultsData() {
        return this.resultsData;
    }

    public final boolean hasTimestamps() {
        return this.timestamps != null && !(this.timestamps instanceof SdkAutoConstructList);
    }

    public final List<Instant> timestamps() {
        return this.timestamps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReports() ? this.reports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResultsData() ? this.resultsData() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTimestamps() ? this.timestamps() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExperimentResultsResponse)) {
            return false;
        }
        GetExperimentResultsResponse other = (GetExperimentResultsResponse)((Object)obj);
        return this.hasReports() == other.hasReports() && Objects.equals(this.reports(), other.reports()) && this.hasResultsData() == other.hasResultsData() && Objects.equals(this.resultsData(), other.resultsData()) && this.hasTimestamps() == other.hasTimestamps() && Objects.equals(this.timestamps(), other.timestamps());
    }

    public final String toString() {
        return ToString.builder((String)"GetExperimentResultsResponse").add("Reports", this.hasReports() ? this.reports() : null).add("ResultsData", this.hasResultsData() ? this.resultsData() : null).add("Timestamps", this.hasTimestamps() ? this.timestamps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "reports": {
                return Optional.ofNullable(clazz.cast(this.reports()));
            }
            case "resultsData": {
                return Optional.ofNullable(clazz.cast(this.resultsData()));
            }
            case "timestamps": {
                return Optional.ofNullable(clazz.cast(this.timestamps()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetExperimentResultsResponse, T> g) {
        return obj -> g.apply((GetExperimentResultsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EvidentlyResponse.BuilderImpl
    implements Builder {
        private List<ExperimentReport> reports = DefaultSdkAutoConstructList.getInstance();
        private List<ExperimentResultsData> resultsData = DefaultSdkAutoConstructList.getInstance();
        private List<Instant> timestamps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetExperimentResultsResponse model) {
            super(model);
            this.reports(model.reports);
            this.resultsData(model.resultsData);
            this.timestamps(model.timestamps);
        }

        public final List<ExperimentReport.Builder> getReports() {
            List<ExperimentReport.Builder> result = ExperimentReportListCopier.copyToBuilder(this.reports);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReports(Collection<ExperimentReport.BuilderImpl> reports) {
            this.reports = ExperimentReportListCopier.copyFromBuilder(reports);
        }

        @Override
        @Transient
        public final Builder reports(Collection<ExperimentReport> reports) {
            this.reports = ExperimentReportListCopier.copy(reports);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder reports(ExperimentReport ... reports) {
            this.reports(Arrays.asList(reports));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder reports(Consumer<ExperimentReport.Builder> ... reports) {
            this.reports(Stream.of(reports).map(c -> (ExperimentReport)((ExperimentReport.Builder)ExperimentReport.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ExperimentResultsData.Builder> getResultsData() {
            List<ExperimentResultsData.Builder> result = ExperimentResultsDataListCopier.copyToBuilder(this.resultsData);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResultsData(Collection<ExperimentResultsData.BuilderImpl> resultsData) {
            this.resultsData = ExperimentResultsDataListCopier.copyFromBuilder(resultsData);
        }

        @Override
        @Transient
        public final Builder resultsData(Collection<ExperimentResultsData> resultsData) {
            this.resultsData = ExperimentResultsDataListCopier.copy(resultsData);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resultsData(ExperimentResultsData ... resultsData) {
            this.resultsData(Arrays.asList(resultsData));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resultsData(Consumer<ExperimentResultsData.Builder> ... resultsData) {
            this.resultsData(Stream.of(resultsData).map(c -> (ExperimentResultsData)((ExperimentResultsData.Builder)ExperimentResultsData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<Instant> getTimestamps() {
            if (this.timestamps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.timestamps;
        }

        public final void setTimestamps(Collection<Instant> timestamps) {
            this.timestamps = TimestampListCopier.copy(timestamps);
        }

        @Override
        @Transient
        public final Builder timestamps(Collection<Instant> timestamps) {
            this.timestamps = TimestampListCopier.copy(timestamps);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder timestamps(Instant ... timestamps) {
            this.timestamps(Arrays.asList(timestamps));
            return this;
        }

        @Override
        public GetExperimentResultsResponse build() {
            return new GetExperimentResultsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EvidentlyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetExperimentResultsResponse> {
        public Builder reports(Collection<ExperimentReport> var1);

        public Builder reports(ExperimentReport ... var1);

        public Builder reports(Consumer<ExperimentReport.Builder> ... var1);

        public Builder resultsData(Collection<ExperimentResultsData> var1);

        public Builder resultsData(ExperimentResultsData ... var1);

        public Builder resultsData(Consumer<ExperimentResultsData.Builder> ... var1);

        public Builder timestamps(Collection<Instant> var1);

        public Builder timestamps(Instant ... var1);
    }
}

