/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.evidently.model.EvidentlyResponse;
import software.amazon.awssdk.services.evidently.model.Launch;
import software.amazon.awssdk.services.evidently.model.LaunchesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLaunchesResponse
extends EvidentlyResponse
implements ToCopyableBuilder<Builder, ListLaunchesResponse> {
    private static final SdkField<List<Launch>> LAUNCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("launches").getter(ListLaunchesResponse.getter(ListLaunchesResponse::launches)).setter(ListLaunchesResponse.setter(Builder::launches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Launch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListLaunchesResponse.getter(ListLaunchesResponse::nextToken)).setter(ListLaunchesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCHES_FIELD, NEXT_TOKEN_FIELD));
    private final List<Launch> launches;
    private final String nextToken;

    private ListLaunchesResponse(BuilderImpl builder) {
        super(builder);
        this.launches = builder.launches;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLaunches() {
        return this.launches != null && !(this.launches instanceof SdkAutoConstructList);
    }

    public final List<Launch> launches() {
        return this.launches;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLaunches() ? this.launches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLaunchesResponse)) {
            return false;
        }
        ListLaunchesResponse other = (ListLaunchesResponse)((Object)obj);
        return this.hasLaunches() == other.hasLaunches() && Objects.equals(this.launches(), other.launches()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListLaunchesResponse").add("Launches", this.hasLaunches() ? this.launches() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "launches": {
                return Optional.ofNullable(clazz.cast(this.launches()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLaunchesResponse, T> g) {
        return obj -> g.apply((ListLaunchesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EvidentlyResponse.BuilderImpl
    implements Builder {
        private List<Launch> launches = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLaunchesResponse model) {
            super(model);
            this.launches(model.launches);
            this.nextToken(model.nextToken);
        }

        public final List<Launch.Builder> getLaunches() {
            List<Launch.Builder> result = LaunchesListCopier.copyToBuilder(this.launches);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLaunches(Collection<Launch.BuilderImpl> launches) {
            this.launches = LaunchesListCopier.copyFromBuilder(launches);
        }

        @Override
        @Transient
        public final Builder launches(Collection<Launch> launches) {
            this.launches = LaunchesListCopier.copy(launches);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder launches(Launch ... launches) {
            this.launches(Arrays.asList(launches));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder launches(Consumer<Launch.Builder> ... launches) {
            this.launches(Stream.of(launches).map(c -> (Launch)((Launch.Builder)Launch.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLaunchesResponse build() {
            return new ListLaunchesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EvidentlyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLaunchesResponse> {
        public Builder launches(Collection<Launch> var1);

        public Builder launches(Launch ... var1);

        public Builder launches(Consumer<Launch.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

