/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eventbridge.model.EventBridgeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEventBusRequest
extends EventBridgeRequest
implements ToCopyableBuilder<Builder, CreateEventBusRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateEventBusRequest.getter(CreateEventBusRequest::name)).setter(CreateEventBusRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> EVENT_SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateEventBusRequest.getter(CreateEventBusRequest::eventSourceName)).setter(CreateEventBusRequest.setter(Builder::eventSourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSourceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, EVENT_SOURCE_NAME_FIELD));
    private final String name;
    private final String eventSourceName;

    private CreateEventBusRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.eventSourceName = builder.eventSourceName;
    }

    public String name() {
        return this.name;
    }

    public String eventSourceName() {
        return this.eventSourceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSourceName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEventBusRequest)) {
            return false;
        }
        CreateEventBusRequest other = (CreateEventBusRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.eventSourceName(), other.eventSourceName());
    }

    public String toString() {
        return ToString.builder((String)"CreateEventBusRequest").add("Name", (Object)this.name()).add("EventSourceName", (Object)this.eventSourceName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "EventSourceName": {
                return Optional.ofNullable(clazz.cast(this.eventSourceName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEventBusRequest, T> g) {
        return obj -> g.apply((CreateEventBusRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EventBridgeRequest.BuilderImpl
    implements Builder {
        private String name;
        private String eventSourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEventBusRequest model) {
            super(model);
            this.name(model.name);
            this.eventSourceName(model.eventSourceName);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getEventSourceName() {
            return this.eventSourceName;
        }

        @Override
        public final Builder eventSourceName(String eventSourceName) {
            this.eventSourceName = eventSourceName;
            return this;
        }

        public final void setEventSourceName(String eventSourceName) {
            this.eventSourceName = eventSourceName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEventBusRequest build() {
            return new CreateEventBusRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EventBridgeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEventBusRequest> {
        public Builder name(String var1);

        public Builder eventSourceName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

