/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.auth.scheme;

import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeProvider;
import software.amazon.awssdk.services.eventbridge.auth.scheme.internal.DefaultEventBridgeAuthSchemeProvider;
import software.amazon.awssdk.services.eventbridge.auth.scheme.internal.PreferredEventBridgeAuthSchemeProvider;

/**
 * An auth scheme provider for EventBridge service. The auth scheme provider takes a set of parameters using
 * {@link EventBridgeAuthSchemeParams}, and resolves a list of {@link AuthSchemeOption} based on the given parameters.
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
public interface EventBridgeAuthSchemeProvider extends AuthSchemeProvider {
    /**
     * Resolve the auth schemes based on the given set of parameters.
     */
    List<AuthSchemeOption> resolveAuthScheme(EventBridgeAuthSchemeParams authSchemeParams);

    /**
     * Resolve the auth schemes based on the given set of parameters.
     */
    default List<AuthSchemeOption> resolveAuthScheme(Consumer<EventBridgeAuthSchemeParams.Builder> consumer) {
        EventBridgeAuthSchemeParams.Builder builder = EventBridgeAuthSchemeParams.builder();
        consumer.accept(builder);
        return resolveAuthScheme(builder.build());
    }

    /**
     * Get the default auth scheme provider.
     */
    static EventBridgeAuthSchemeProvider defaultProvider() {
        return DefaultEventBridgeAuthSchemeProvider.create();
    }

    /**
     * Get the default auth scheme provider the preferred auth schemes in order of preference.
     */
    static EventBridgeAuthSchemeProvider defaultProvider(List<String> authSchemePreference) {
        return new PreferredEventBridgeAuthSchemeProvider(defaultProvider(), authSchemePreference);
    }
}
