/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.endpoints.internal;

import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4aAuthScheme;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.eventbridge.endpoints.EventBridgeEndpointParams;
import software.amazon.awssdk.services.eventbridge.endpoints.EventBridgeEndpointProvider;
import software.amazon.awssdk.services.eventbridge.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.eventbridge.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.eventbridge.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultEventBridgeEndpointProvider
implements EventBridgeEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(EventBridgeEndpointParams params) {
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            Region region = params.region();
            String regionId = region == null ? null : region.id();
            RuleResult result = DefaultEventBridgeEndpointProvider.endpointRule0(params, regionId);
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(EventBridgeEndpointParams params, String region) {
        RulePartition partitionResult;
        if (params.endpoint() == null && region != null && (partitionResult = RulesFunctions.awsPartition(region)) != null && "aws-us-gov".equals(partitionResult.name()) && params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://events." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        RuleResult result = DefaultEventBridgeEndpointProvider.endpointRule2(params, region);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultEventBridgeEndpointProvider.endpointRule13(params);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultEventBridgeEndpointProvider.endpointRule17(params, region);
        if (result.isResolved()) {
            return result;
        }
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    private static RuleResult endpointRule2(EventBridgeEndpointParams params, String region) {
        RulePartition partitionResult;
        if (params.endpointId() != null && region != null && (partitionResult = RulesFunctions.awsPartition(region)) != null) {
            RuleResult result = DefaultEventBridgeEndpointProvider.endpointRule3(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("EndpointId must be a valid host label.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule3(EventBridgeEndpointParams params, RulePartition partitionResult) {
        if (RulesFunctions.isValidHostLabel(params.endpointId(), true)) {
            RuleResult result = DefaultEventBridgeEndpointProvider.endpointRule4(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid Configuration: FIPS is not supported with EventBridge multi-region endpoints.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule4(EventBridgeEndpointParams params, RulePartition partitionResult) {
        if (!params.useFips().booleanValue()) {
            if (params.endpoint() != null) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4aAuthScheme.builder().signingName("events").signingRegionSet(Arrays.asList("*")).build())).build());
            }
            RuleResult result = DefaultEventBridgeEndpointProvider.endpointRule6(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.endpointId() + ".endpoint.events." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4aAuthScheme.builder().signingName("events").signingRegionSet(Arrays.asList("*")).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule6(EventBridgeEndpointParams params, RulePartition partitionResult) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultEventBridgeEndpointProvider.endpointRule7(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule7(EventBridgeEndpointParams params, RulePartition partitionResult) {
        if (partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.endpointId() + ".endpoint.events." + partitionResult.dualStackDnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4aAuthScheme.builder().signingName("events").signingRegionSet(Arrays.asList("*")).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule13(EventBridgeEndpointParams params) {
        if (params.endpoint() != null) {
            if (params.useFips().booleanValue()) {
                return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
            }
            if (params.useDualStack().booleanValue()) {
                return RuleResult.error("Invalid Configuration: Dualstack and custom endpoint are not supported");
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule17(EventBridgeEndpointParams params, String region) {
        if (region != null) {
            return DefaultEventBridgeEndpointProvider.endpointRule18(params, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule18(EventBridgeEndpointParams params, String region) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            RuleResult result = DefaultEventBridgeEndpointProvider.endpointRule19(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultEventBridgeEndpointProvider.endpointRule23(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultEventBridgeEndpointProvider.endpointRule29(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://events." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule19(EventBridgeEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultEventBridgeEndpointProvider.endpointRule20(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS and DualStack are enabled, but this partition does not support one or both");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule20(EventBridgeEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsFIPS() && partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://events-fips." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule23(EventBridgeEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultEventBridgeEndpointProvider.endpointRule24(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule24(EventBridgeEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsFIPS()) {
            if ("us-gov-east-1".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://events.us-gov-east-1.amazonaws.com")).build());
            }
            if ("us-gov-west-1".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://events.us-gov-west-1.amazonaws.com")).build());
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://events-fips." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule29(EventBridgeEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultEventBridgeEndpointProvider.endpointRule30(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule30(EventBridgeEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://events." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

