/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartReplayRequest extends EventBridgeRequest implements
        ToCopyableBuilder<StartReplayRequest.Builder, StartReplayRequest> {
    private static final SdkField<String> REPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplayName").getter(getter(StartReplayRequest::replayName)).setter(setter(Builder::replayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplayName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(StartReplayRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> EVENT_SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventSourceArn").getter(getter(StartReplayRequest::eventSourceArn))
            .setter(setter(Builder::eventSourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSourceArn").build()).build();

    private static final SdkField<Instant> EVENT_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EventStartTime").getter(getter(StartReplayRequest::eventStartTime))
            .setter(setter(Builder::eventStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventStartTime").build()).build();

    private static final SdkField<Instant> EVENT_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EventEndTime").getter(getter(StartReplayRequest::eventEndTime)).setter(setter(Builder::eventEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventEndTime").build()).build();

    private static final SdkField<ReplayDestination> DESTINATION_FIELD = SdkField
            .<ReplayDestination> builder(MarshallingType.SDK_POJO).memberName("Destination")
            .getter(getter(StartReplayRequest::destination)).setter(setter(Builder::destination))
            .constructor(ReplayDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLAY_NAME_FIELD,
            DESCRIPTION_FIELD, EVENT_SOURCE_ARN_FIELD, EVENT_START_TIME_FIELD, EVENT_END_TIME_FIELD, DESTINATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String replayName;

    private final String description;

    private final String eventSourceArn;

    private final Instant eventStartTime;

    private final Instant eventEndTime;

    private final ReplayDestination destination;

    private StartReplayRequest(BuilderImpl builder) {
        super(builder);
        this.replayName = builder.replayName;
        this.description = builder.description;
        this.eventSourceArn = builder.eventSourceArn;
        this.eventStartTime = builder.eventStartTime;
        this.eventEndTime = builder.eventEndTime;
        this.destination = builder.destination;
    }

    /**
     * <p>
     * The name of the replay to start.
     * </p>
     * 
     * @return The name of the replay to start.
     */
    public final String replayName() {
        return replayName;
    }

    /**
     * <p>
     * A description for the replay to start.
     * </p>
     * 
     * @return A description for the replay to start.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ARN of the archive to replay events from.
     * </p>
     * 
     * @return The ARN of the archive to replay events from.
     */
    public final String eventSourceArn() {
        return eventSourceArn;
    }

    /**
     * <p>
     * A time stamp for the time to start replaying events. Only events that occurred between the
     * <code>EventStartTime</code> and <code>EventEndTime</code> are replayed.
     * </p>
     * 
     * @return A time stamp for the time to start replaying events. Only events that occurred between the
     *         <code>EventStartTime</code> and <code>EventEndTime</code> are replayed.
     */
    public final Instant eventStartTime() {
        return eventStartTime;
    }

    /**
     * <p>
     * A time stamp for the time to stop replaying events. Only events that occurred between the
     * <code>EventStartTime</code> and <code>EventEndTime</code> are replayed.
     * </p>
     * 
     * @return A time stamp for the time to stop replaying events. Only events that occurred between the
     *         <code>EventStartTime</code> and <code>EventEndTime</code> are replayed.
     */
    public final Instant eventEndTime() {
        return eventEndTime;
    }

    /**
     * <p>
     * A <code>ReplayDestination</code> object that includes details about the destination for the replay.
     * </p>
     * 
     * @return A <code>ReplayDestination</code> object that includes details about the destination for the replay.
     */
    public final ReplayDestination destination() {
        return destination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replayName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(eventSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(eventStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(eventEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartReplayRequest)) {
            return false;
        }
        StartReplayRequest other = (StartReplayRequest) obj;
        return Objects.equals(replayName(), other.replayName()) && Objects.equals(description(), other.description())
                && Objects.equals(eventSourceArn(), other.eventSourceArn())
                && Objects.equals(eventStartTime(), other.eventStartTime())
                && Objects.equals(eventEndTime(), other.eventEndTime()) && Objects.equals(destination(), other.destination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartReplayRequest").add("ReplayName", replayName()).add("Description", description())
                .add("EventSourceArn", eventSourceArn()).add("EventStartTime", eventStartTime())
                .add("EventEndTime", eventEndTime()).add("Destination", destination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplayName":
            return Optional.ofNullable(clazz.cast(replayName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EventSourceArn":
            return Optional.ofNullable(clazz.cast(eventSourceArn()));
        case "EventStartTime":
            return Optional.ofNullable(clazz.cast(eventStartTime()));
        case "EventEndTime":
            return Optional.ofNullable(clazz.cast(eventEndTime()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReplayName", REPLAY_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("EventSourceArn", EVENT_SOURCE_ARN_FIELD);
        map.put("EventStartTime", EVENT_START_TIME_FIELD);
        map.put("EventEndTime", EVENT_END_TIME_FIELD);
        map.put("Destination", DESTINATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartReplayRequest, T> g) {
        return obj -> g.apply((StartReplayRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EventBridgeRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartReplayRequest> {
        /**
         * <p>
         * The name of the replay to start.
         * </p>
         * 
         * @param replayName
         *        The name of the replay to start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replayName(String replayName);

        /**
         * <p>
         * A description for the replay to start.
         * </p>
         * 
         * @param description
         *        A description for the replay to start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ARN of the archive to replay events from.
         * </p>
         * 
         * @param eventSourceArn
         *        The ARN of the archive to replay events from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSourceArn(String eventSourceArn);

        /**
         * <p>
         * A time stamp for the time to start replaying events. Only events that occurred between the
         * <code>EventStartTime</code> and <code>EventEndTime</code> are replayed.
         * </p>
         * 
         * @param eventStartTime
         *        A time stamp for the time to start replaying events. Only events that occurred between the
         *        <code>EventStartTime</code> and <code>EventEndTime</code> are replayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventStartTime(Instant eventStartTime);

        /**
         * <p>
         * A time stamp for the time to stop replaying events. Only events that occurred between the
         * <code>EventStartTime</code> and <code>EventEndTime</code> are replayed.
         * </p>
         * 
         * @param eventEndTime
         *        A time stamp for the time to stop replaying events. Only events that occurred between the
         *        <code>EventStartTime</code> and <code>EventEndTime</code> are replayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventEndTime(Instant eventEndTime);

        /**
         * <p>
         * A <code>ReplayDestination</code> object that includes details about the destination for the replay.
         * </p>
         * 
         * @param destination
         *        A <code>ReplayDestination</code> object that includes details about the destination for the replay.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(ReplayDestination destination);

        /**
         * <p>
         * A <code>ReplayDestination</code> object that includes details about the destination for the replay.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReplayDestination.Builder} avoiding the
         * need to create one manually via {@link ReplayDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReplayDestination.Builder#build()} is called immediately and its
         * result is passed to {@link #destination(ReplayDestination)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link ReplayDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(ReplayDestination)
         */
        default Builder destination(Consumer<ReplayDestination.Builder> destination) {
            return destination(ReplayDestination.builder().applyMutation(destination).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EventBridgeRequest.BuilderImpl implements Builder {
        private String replayName;

        private String description;

        private String eventSourceArn;

        private Instant eventStartTime;

        private Instant eventEndTime;

        private ReplayDestination destination;

        private BuilderImpl() {
        }

        private BuilderImpl(StartReplayRequest model) {
            super(model);
            replayName(model.replayName);
            description(model.description);
            eventSourceArn(model.eventSourceArn);
            eventStartTime(model.eventStartTime);
            eventEndTime(model.eventEndTime);
            destination(model.destination);
        }

        public final String getReplayName() {
            return replayName;
        }

        public final void setReplayName(String replayName) {
            this.replayName = replayName;
        }

        @Override
        public final Builder replayName(String replayName) {
            this.replayName = replayName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEventSourceArn() {
            return eventSourceArn;
        }

        public final void setEventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
        }

        @Override
        public final Builder eventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
            return this;
        }

        public final Instant getEventStartTime() {
            return eventStartTime;
        }

        public final void setEventStartTime(Instant eventStartTime) {
            this.eventStartTime = eventStartTime;
        }

        @Override
        public final Builder eventStartTime(Instant eventStartTime) {
            this.eventStartTime = eventStartTime;
            return this;
        }

        public final Instant getEventEndTime() {
            return eventEndTime;
        }

        public final void setEventEndTime(Instant eventEndTime) {
            this.eventEndTime = eventEndTime;
        }

        @Override
        public final Builder eventEndTime(Instant eventEndTime) {
            this.eventEndTime = eventEndTime;
            return this;
        }

        public final ReplayDestination.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        public final void setDestination(ReplayDestination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(ReplayDestination destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartReplayRequest build() {
            return new StartReplayRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
