/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConnectionsResponse extends EventBridgeResponse implements
        ToCopyableBuilder<ListConnectionsResponse.Builder, ListConnectionsResponse> {
    private static final SdkField<List<Connection>> CONNECTIONS_FIELD = SdkField
            .<List<Connection>> builder(MarshallingType.LIST)
            .memberName("Connections")
            .getter(getter(ListConnectionsResponse::connections))
            .setter(setter(Builder::connections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Connections").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Connection> builder(MarshallingType.SDK_POJO)
                                            .constructor(Connection::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListConnectionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Connection> connections;

    private final String nextToken;

    private ListConnectionsResponse(BuilderImpl builder) {
        super(builder);
        this.connections = builder.connections;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Connections property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConnections() {
        return connections != null && !(connections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of connections objects that include details about the connections.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnections} method.
     * </p>
     * 
     * @return An array of connections objects that include details about the connections.
     */
    public final List<Connection> connections() {
        return connections;
    }

    /**
     * <p>
     * A token indicating there are more results available. If there are no more results, no token is included in the
     * response.
     * </p>
     * <p>
     * The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page of
     * results, make the call again using the returned token. Keep all other arguments unchanged.
     * </p>
     * <p>
     * Using an expired pagination token results in an <code>HTTP 400 InvalidToken</code> error.
     * </p>
     * 
     * @return A token indicating there are more results available. If there are no more results, no token is included
     *         in the response.</p>
     *         <p>
     *         The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page
     *         of results, make the call again using the returned token. Keep all other arguments unchanged.
     *         </p>
     *         <p>
     *         Using an expired pagination token results in an <code>HTTP 400 InvalidToken</code> error.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConnections() ? connections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConnectionsResponse)) {
            return false;
        }
        ListConnectionsResponse other = (ListConnectionsResponse) obj;
        return hasConnections() == other.hasConnections() && Objects.equals(connections(), other.connections())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListConnectionsResponse").add("Connections", hasConnections() ? connections() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Connections":
            return Optional.ofNullable(clazz.cast(connections()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Connections", CONNECTIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConnectionsResponse, T> g) {
        return obj -> g.apply((ListConnectionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EventBridgeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListConnectionsResponse> {
        /**
         * <p>
         * An array of connections objects that include details about the connections.
         * </p>
         * 
         * @param connections
         *        An array of connections objects that include details about the connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connections(Collection<Connection> connections);

        /**
         * <p>
         * An array of connections objects that include details about the connections.
         * </p>
         * 
         * @param connections
         *        An array of connections objects that include details about the connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connections(Connection... connections);

        /**
         * <p>
         * An array of connections objects that include details about the connections.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.eventbridge.model.Connection.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.eventbridge.model.Connection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.eventbridge.model.Connection.Builder#build()} is called immediately
         * and its result is passed to {@link #connections(List<Connection>)}.
         * 
         * @param connections
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.eventbridge.model.Connection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connections(java.util.Collection<Connection>)
         */
        Builder connections(Consumer<Connection.Builder>... connections);

        /**
         * <p>
         * A token indicating there are more results available. If there are no more results, no token is included in
         * the response.
         * </p>
         * <p>
         * The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page of
         * results, make the call again using the returned token. Keep all other arguments unchanged.
         * </p>
         * <p>
         * Using an expired pagination token results in an <code>HTTP 400 InvalidToken</code> error.
         * </p>
         * 
         * @param nextToken
         *        A token indicating there are more results available. If there are no more results, no token is
         *        included in the response.</p>
         *        <p>
         *        The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next
         *        page of results, make the call again using the returned token. Keep all other arguments unchanged.
         *        </p>
         *        <p>
         *        Using an expired pagination token results in an <code>HTTP 400 InvalidToken</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EventBridgeResponse.BuilderImpl implements Builder {
        private List<Connection> connections = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConnectionsResponse model) {
            super(model);
            connections(model.connections);
            nextToken(model.nextToken);
        }

        public final List<Connection.Builder> getConnections() {
            List<Connection.Builder> result = ConnectionResponseListCopier.copyToBuilder(this.connections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnections(Collection<Connection.BuilderImpl> connections) {
            this.connections = ConnectionResponseListCopier.copyFromBuilder(connections);
        }

        @Override
        public final Builder connections(Collection<Connection> connections) {
            this.connections = ConnectionResponseListCopier.copy(connections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connections(Connection... connections) {
            connections(Arrays.asList(connections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connections(Consumer<Connection.Builder>... connections) {
            connections(Stream.of(connections).map(c -> Connection.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListConnectionsResponse build() {
            return new ListConnectionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
