/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters for EventBridge to use when invoking the resource endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectivityResourceParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectivityResourceParameters.Builder, ConnectivityResourceParameters> {
    private static final SdkField<ConnectivityResourceConfigurationArn> RESOURCE_PARAMETERS_FIELD = SdkField
            .<ConnectivityResourceConfigurationArn> builder(MarshallingType.SDK_POJO).memberName("ResourceParameters")
            .getter(getter(ConnectivityResourceParameters::resourceParameters)).setter(setter(Builder::resourceParameters))
            .constructor(ConnectivityResourceConfigurationArn::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceParameters").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ConnectivityResourceConfigurationArn resourceParameters;

    private ConnectivityResourceParameters(BuilderImpl builder) {
        this.resourceParameters = builder.resourceParameters;
    }

    /**
     * <p>
     * The parameters for EventBridge to use when invoking the resource endpoint.
     * </p>
     * 
     * @return The parameters for EventBridge to use when invoking the resource endpoint.
     */
    public final ConnectivityResourceConfigurationArn resourceParameters() {
        return resourceParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectivityResourceParameters)) {
            return false;
        }
        ConnectivityResourceParameters other = (ConnectivityResourceParameters) obj;
        return Objects.equals(resourceParameters(), other.resourceParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectivityResourceParameters").add("ResourceParameters", resourceParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceParameters":
            return Optional.ofNullable(clazz.cast(resourceParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceParameters", RESOURCE_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectivityResourceParameters, T> g) {
        return obj -> g.apply((ConnectivityResourceParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectivityResourceParameters> {
        /**
         * <p>
         * The parameters for EventBridge to use when invoking the resource endpoint.
         * </p>
         * 
         * @param resourceParameters
         *        The parameters for EventBridge to use when invoking the resource endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceParameters(ConnectivityResourceConfigurationArn resourceParameters);

        /**
         * <p>
         * The parameters for EventBridge to use when invoking the resource endpoint.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ConnectivityResourceConfigurationArn.Builder} avoiding the need to create one manually via
         * {@link ConnectivityResourceConfigurationArn#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectivityResourceConfigurationArn.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceParameters(ConnectivityResourceConfigurationArn)}.
         * 
         * @param resourceParameters
         *        a consumer that will call methods on {@link ConnectivityResourceConfigurationArn.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceParameters(ConnectivityResourceConfigurationArn)
         */
        default Builder resourceParameters(Consumer<ConnectivityResourceConfigurationArn.Builder> resourceParameters) {
            return resourceParameters(ConnectivityResourceConfigurationArn.builder().applyMutation(resourceParameters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ConnectivityResourceConfigurationArn resourceParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectivityResourceParameters model) {
            resourceParameters(model.resourceParameters);
        }

        public final ConnectivityResourceConfigurationArn.Builder getResourceParameters() {
            return resourceParameters != null ? resourceParameters.toBuilder() : null;
        }

        public final void setResourceParameters(ConnectivityResourceConfigurationArn.BuilderImpl resourceParameters) {
            this.resourceParameters = resourceParameters != null ? resourceParameters.build() : null;
        }

        @Override
        public final Builder resourceParameters(ConnectivityResourceConfigurationArn resourceParameters) {
            this.resourceParameters = resourceParameters;
            return this;
        }

        @Override
        public ConnectivityResourceParameters build() {
            return new ConnectivityResourceParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
