/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eventbridge.model.ConnectionHttpParameters;
import software.amazon.awssdk.services.eventbridge.model.ConnectivityResourceParameters;
import software.amazon.awssdk.services.eventbridge.model.UpdateConnectionApiKeyAuthRequestParameters;
import software.amazon.awssdk.services.eventbridge.model.UpdateConnectionBasicAuthRequestParameters;
import software.amazon.awssdk.services.eventbridge.model.UpdateConnectionOAuthRequestParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateConnectionAuthRequestParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateConnectionAuthRequestParameters> {
    private static final SdkField<UpdateConnectionBasicAuthRequestParameters> BASIC_AUTH_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BasicAuthParameters").getter(UpdateConnectionAuthRequestParameters.getter(UpdateConnectionAuthRequestParameters::basicAuthParameters)).setter(UpdateConnectionAuthRequestParameters.setter(Builder::basicAuthParameters)).constructor(UpdateConnectionBasicAuthRequestParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BasicAuthParameters").build()}).build();
    private static final SdkField<UpdateConnectionOAuthRequestParameters> O_AUTH_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OAuthParameters").getter(UpdateConnectionAuthRequestParameters.getter(UpdateConnectionAuthRequestParameters::oAuthParameters)).setter(UpdateConnectionAuthRequestParameters.setter(Builder::oAuthParameters)).constructor(UpdateConnectionOAuthRequestParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OAuthParameters").build()}).build();
    private static final SdkField<UpdateConnectionApiKeyAuthRequestParameters> API_KEY_AUTH_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApiKeyAuthParameters").getter(UpdateConnectionAuthRequestParameters.getter(UpdateConnectionAuthRequestParameters::apiKeyAuthParameters)).setter(UpdateConnectionAuthRequestParameters.setter(Builder::apiKeyAuthParameters)).constructor(UpdateConnectionApiKeyAuthRequestParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiKeyAuthParameters").build()}).build();
    private static final SdkField<ConnectionHttpParameters> INVOCATION_HTTP_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InvocationHttpParameters").getter(UpdateConnectionAuthRequestParameters.getter(UpdateConnectionAuthRequestParameters::invocationHttpParameters)).setter(UpdateConnectionAuthRequestParameters.setter(Builder::invocationHttpParameters)).constructor(ConnectionHttpParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationHttpParameters").build()}).build();
    private static final SdkField<ConnectivityResourceParameters> CONNECTIVITY_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConnectivityParameters").getter(UpdateConnectionAuthRequestParameters.getter(UpdateConnectionAuthRequestParameters::connectivityParameters)).setter(UpdateConnectionAuthRequestParameters.setter(Builder::connectivityParameters)).constructor(ConnectivityResourceParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectivityParameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASIC_AUTH_PARAMETERS_FIELD, O_AUTH_PARAMETERS_FIELD, API_KEY_AUTH_PARAMETERS_FIELD, INVOCATION_HTTP_PARAMETERS_FIELD, CONNECTIVITY_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateConnectionAuthRequestParameters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final UpdateConnectionBasicAuthRequestParameters basicAuthParameters;
    private final UpdateConnectionOAuthRequestParameters oAuthParameters;
    private final UpdateConnectionApiKeyAuthRequestParameters apiKeyAuthParameters;
    private final ConnectionHttpParameters invocationHttpParameters;
    private final ConnectivityResourceParameters connectivityParameters;

    private UpdateConnectionAuthRequestParameters(BuilderImpl builder) {
        this.basicAuthParameters = builder.basicAuthParameters;
        this.oAuthParameters = builder.oAuthParameters;
        this.apiKeyAuthParameters = builder.apiKeyAuthParameters;
        this.invocationHttpParameters = builder.invocationHttpParameters;
        this.connectivityParameters = builder.connectivityParameters;
    }

    public final UpdateConnectionBasicAuthRequestParameters basicAuthParameters() {
        return this.basicAuthParameters;
    }

    public final UpdateConnectionOAuthRequestParameters oAuthParameters() {
        return this.oAuthParameters;
    }

    public final UpdateConnectionApiKeyAuthRequestParameters apiKeyAuthParameters() {
        return this.apiKeyAuthParameters;
    }

    public final ConnectionHttpParameters invocationHttpParameters() {
        return this.invocationHttpParameters;
    }

    public final ConnectivityResourceParameters connectivityParameters() {
        return this.connectivityParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.basicAuthParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.oAuthParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKeyAuthParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationHttpParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectivityParameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectionAuthRequestParameters)) {
            return false;
        }
        UpdateConnectionAuthRequestParameters other = (UpdateConnectionAuthRequestParameters)obj;
        return Objects.equals(this.basicAuthParameters(), other.basicAuthParameters()) && Objects.equals(this.oAuthParameters(), other.oAuthParameters()) && Objects.equals(this.apiKeyAuthParameters(), other.apiKeyAuthParameters()) && Objects.equals(this.invocationHttpParameters(), other.invocationHttpParameters()) && Objects.equals(this.connectivityParameters(), other.connectivityParameters());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateConnectionAuthRequestParameters").add("BasicAuthParameters", (Object)this.basicAuthParameters()).add("OAuthParameters", (Object)this.oAuthParameters()).add("ApiKeyAuthParameters", (Object)this.apiKeyAuthParameters()).add("InvocationHttpParameters", (Object)this.invocationHttpParameters()).add("ConnectivityParameters", (Object)this.connectivityParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BasicAuthParameters": {
                return Optional.ofNullable(clazz.cast(this.basicAuthParameters()));
            }
            case "OAuthParameters": {
                return Optional.ofNullable(clazz.cast(this.oAuthParameters()));
            }
            case "ApiKeyAuthParameters": {
                return Optional.ofNullable(clazz.cast(this.apiKeyAuthParameters()));
            }
            case "InvocationHttpParameters": {
                return Optional.ofNullable(clazz.cast(this.invocationHttpParameters()));
            }
            case "ConnectivityParameters": {
                return Optional.ofNullable(clazz.cast(this.connectivityParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BasicAuthParameters", BASIC_AUTH_PARAMETERS_FIELD);
        map.put("OAuthParameters", O_AUTH_PARAMETERS_FIELD);
        map.put("ApiKeyAuthParameters", API_KEY_AUTH_PARAMETERS_FIELD);
        map.put("InvocationHttpParameters", INVOCATION_HTTP_PARAMETERS_FIELD);
        map.put("ConnectivityParameters", CONNECTIVITY_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateConnectionAuthRequestParameters, T> g) {
        return obj -> g.apply((UpdateConnectionAuthRequestParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private UpdateConnectionBasicAuthRequestParameters basicAuthParameters;
        private UpdateConnectionOAuthRequestParameters oAuthParameters;
        private UpdateConnectionApiKeyAuthRequestParameters apiKeyAuthParameters;
        private ConnectionHttpParameters invocationHttpParameters;
        private ConnectivityResourceParameters connectivityParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectionAuthRequestParameters model) {
            this.basicAuthParameters(model.basicAuthParameters);
            this.oAuthParameters(model.oAuthParameters);
            this.apiKeyAuthParameters(model.apiKeyAuthParameters);
            this.invocationHttpParameters(model.invocationHttpParameters);
            this.connectivityParameters(model.connectivityParameters);
        }

        public final UpdateConnectionBasicAuthRequestParameters.Builder getBasicAuthParameters() {
            return this.basicAuthParameters != null ? this.basicAuthParameters.toBuilder() : null;
        }

        public final void setBasicAuthParameters(UpdateConnectionBasicAuthRequestParameters.BuilderImpl basicAuthParameters) {
            this.basicAuthParameters = basicAuthParameters != null ? basicAuthParameters.build() : null;
        }

        @Override
        public final Builder basicAuthParameters(UpdateConnectionBasicAuthRequestParameters basicAuthParameters) {
            this.basicAuthParameters = basicAuthParameters;
            return this;
        }

        public final UpdateConnectionOAuthRequestParameters.Builder getOAuthParameters() {
            return this.oAuthParameters != null ? this.oAuthParameters.toBuilder() : null;
        }

        public final void setOAuthParameters(UpdateConnectionOAuthRequestParameters.BuilderImpl oAuthParameters) {
            this.oAuthParameters = oAuthParameters != null ? oAuthParameters.build() : null;
        }

        @Override
        public final Builder oAuthParameters(UpdateConnectionOAuthRequestParameters oAuthParameters) {
            this.oAuthParameters = oAuthParameters;
            return this;
        }

        public final UpdateConnectionApiKeyAuthRequestParameters.Builder getApiKeyAuthParameters() {
            return this.apiKeyAuthParameters != null ? this.apiKeyAuthParameters.toBuilder() : null;
        }

        public final void setApiKeyAuthParameters(UpdateConnectionApiKeyAuthRequestParameters.BuilderImpl apiKeyAuthParameters) {
            this.apiKeyAuthParameters = apiKeyAuthParameters != null ? apiKeyAuthParameters.build() : null;
        }

        @Override
        public final Builder apiKeyAuthParameters(UpdateConnectionApiKeyAuthRequestParameters apiKeyAuthParameters) {
            this.apiKeyAuthParameters = apiKeyAuthParameters;
            return this;
        }

        public final ConnectionHttpParameters.Builder getInvocationHttpParameters() {
            return this.invocationHttpParameters != null ? this.invocationHttpParameters.toBuilder() : null;
        }

        public final void setInvocationHttpParameters(ConnectionHttpParameters.BuilderImpl invocationHttpParameters) {
            this.invocationHttpParameters = invocationHttpParameters != null ? invocationHttpParameters.build() : null;
        }

        @Override
        public final Builder invocationHttpParameters(ConnectionHttpParameters invocationHttpParameters) {
            this.invocationHttpParameters = invocationHttpParameters;
            return this;
        }

        public final ConnectivityResourceParameters.Builder getConnectivityParameters() {
            return this.connectivityParameters != null ? this.connectivityParameters.toBuilder() : null;
        }

        public final void setConnectivityParameters(ConnectivityResourceParameters.BuilderImpl connectivityParameters) {
            this.connectivityParameters = connectivityParameters != null ? connectivityParameters.build() : null;
        }

        @Override
        public final Builder connectivityParameters(ConnectivityResourceParameters connectivityParameters) {
            this.connectivityParameters = connectivityParameters;
            return this;
        }

        public UpdateConnectionAuthRequestParameters build() {
            return new UpdateConnectionAuthRequestParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateConnectionAuthRequestParameters> {
        public Builder basicAuthParameters(UpdateConnectionBasicAuthRequestParameters var1);

        default public Builder basicAuthParameters(Consumer<UpdateConnectionBasicAuthRequestParameters.Builder> basicAuthParameters) {
            return this.basicAuthParameters((UpdateConnectionBasicAuthRequestParameters)((UpdateConnectionBasicAuthRequestParameters.Builder)UpdateConnectionBasicAuthRequestParameters.builder().applyMutation(basicAuthParameters)).build());
        }

        public Builder oAuthParameters(UpdateConnectionOAuthRequestParameters var1);

        default public Builder oAuthParameters(Consumer<UpdateConnectionOAuthRequestParameters.Builder> oAuthParameters) {
            return this.oAuthParameters((UpdateConnectionOAuthRequestParameters)((UpdateConnectionOAuthRequestParameters.Builder)UpdateConnectionOAuthRequestParameters.builder().applyMutation(oAuthParameters)).build());
        }

        public Builder apiKeyAuthParameters(UpdateConnectionApiKeyAuthRequestParameters var1);

        default public Builder apiKeyAuthParameters(Consumer<UpdateConnectionApiKeyAuthRequestParameters.Builder> apiKeyAuthParameters) {
            return this.apiKeyAuthParameters((UpdateConnectionApiKeyAuthRequestParameters)((UpdateConnectionApiKeyAuthRequestParameters.Builder)UpdateConnectionApiKeyAuthRequestParameters.builder().applyMutation(apiKeyAuthParameters)).build());
        }

        public Builder invocationHttpParameters(ConnectionHttpParameters var1);

        default public Builder invocationHttpParameters(Consumer<ConnectionHttpParameters.Builder> invocationHttpParameters) {
            return this.invocationHttpParameters((ConnectionHttpParameters)((ConnectionHttpParameters.Builder)ConnectionHttpParameters.builder().applyMutation(invocationHttpParameters)).build());
        }

        public Builder connectivityParameters(ConnectivityResourceParameters var1);

        default public Builder connectivityParameters(Consumer<ConnectivityResourceParameters.Builder> connectivityParameters) {
            return this.connectivityParameters((ConnectivityResourceParameters)((ConnectivityResourceParameters.Builder)ConnectivityResourceParameters.builder().applyMutation(connectivityParameters)).build());
        }
    }
}

