/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eventbridge.model.EventBridgeResponse;
import software.amazon.awssdk.services.eventbridge.model.ReplayState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartReplayResponse
extends EventBridgeResponse
implements ToCopyableBuilder<Builder, StartReplayResponse> {
    private static final SdkField<String> REPLAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplayArn").getter(StartReplayResponse.getter(StartReplayResponse::replayArn)).setter(StartReplayResponse.setter(Builder::replayArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplayArn").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(StartReplayResponse.getter(StartReplayResponse::stateAsString)).setter(StartReplayResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> STATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateReason").getter(StartReplayResponse.getter(StartReplayResponse::stateReason)).setter(StartReplayResponse.setter(Builder::stateReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()}).build();
    private static final SdkField<Instant> REPLAY_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReplayStartTime").getter(StartReplayResponse.getter(StartReplayResponse::replayStartTime)).setter(StartReplayResponse.setter(Builder::replayStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplayStartTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLAY_ARN_FIELD, STATE_FIELD, STATE_REASON_FIELD, REPLAY_START_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ReplayArn", REPLAY_ARN_FIELD);
            this.put("State", STATE_FIELD);
            this.put("StateReason", STATE_REASON_FIELD);
            this.put("ReplayStartTime", REPLAY_START_TIME_FIELD);
        }
    });
    private final String replayArn;
    private final String state;
    private final String stateReason;
    private final Instant replayStartTime;

    private StartReplayResponse(BuilderImpl builder) {
        super(builder);
        this.replayArn = builder.replayArn;
        this.state = builder.state;
        this.stateReason = builder.stateReason;
        this.replayStartTime = builder.replayStartTime;
    }

    public final String replayArn() {
        return this.replayArn;
    }

    public final ReplayState state() {
        return ReplayState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String stateReason() {
        return this.stateReason;
    }

    public final Instant replayStartTime() {
        return this.replayStartTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.replayArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.replayStartTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartReplayResponse)) {
            return false;
        }
        StartReplayResponse other = (StartReplayResponse)((Object)obj);
        return Objects.equals(this.replayArn(), other.replayArn()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateReason(), other.stateReason()) && Objects.equals(this.replayStartTime(), other.replayStartTime());
    }

    public final String toString() {
        return ToString.builder((String)"StartReplayResponse").add("ReplayArn", (Object)this.replayArn()).add("State", (Object)this.stateAsString()).add("StateReason", (Object)this.stateReason()).add("ReplayStartTime", (Object)this.replayStartTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplayArn": {
                return Optional.ofNullable(clazz.cast(this.replayArn()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateReason": {
                return Optional.ofNullable(clazz.cast(this.stateReason()));
            }
            case "ReplayStartTime": {
                return Optional.ofNullable(clazz.cast(this.replayStartTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartReplayResponse, T> g) {
        return obj -> g.apply((StartReplayResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EventBridgeResponse.BuilderImpl
    implements Builder {
        private String replayArn;
        private String state;
        private String stateReason;
        private Instant replayStartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(StartReplayResponse model) {
            super(model);
            this.replayArn(model.replayArn);
            this.state(model.state);
            this.stateReason(model.stateReason);
            this.replayStartTime(model.replayStartTime);
        }

        public final String getReplayArn() {
            return this.replayArn;
        }

        public final void setReplayArn(String replayArn) {
            this.replayArn = replayArn;
        }

        @Override
        public final Builder replayArn(String replayArn) {
            this.replayArn = replayArn;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ReplayState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateReason() {
            return this.stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final Instant getReplayStartTime() {
            return this.replayStartTime;
        }

        public final void setReplayStartTime(Instant replayStartTime) {
            this.replayStartTime = replayStartTime;
        }

        @Override
        public final Builder replayStartTime(Instant replayStartTime) {
            this.replayStartTime = replayStartTime;
            return this;
        }

        @Override
        public StartReplayResponse build() {
            return new StartReplayResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EventBridgeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartReplayResponse> {
        public Builder replayArn(String var1);

        public Builder state(String var1);

        public Builder state(ReplayState var1);

        public Builder stateReason(String var1);

        public Builder replayStartTime(Instant var1);
    }
}

