/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eventbridge.model.Archive;
import software.amazon.awssdk.services.eventbridge.model.ArchiveResponseListCopier;
import software.amazon.awssdk.services.eventbridge.model.EventBridgeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListArchivesResponse
extends EventBridgeResponse
implements ToCopyableBuilder<Builder, ListArchivesResponse> {
    private static final SdkField<List<Archive>> ARCHIVES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Archives").getter(ListArchivesResponse.getter(ListArchivesResponse::archives)).setter(ListArchivesResponse.setter(Builder::archives)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Archives").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Archive::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListArchivesResponse.getter(ListArchivesResponse::nextToken)).setter(ListArchivesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Archives", ARCHIVES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<Archive> archives;
    private final String nextToken;

    private ListArchivesResponse(BuilderImpl builder) {
        super(builder);
        this.archives = builder.archives;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasArchives() {
        return this.archives != null && !(this.archives instanceof SdkAutoConstructList);
    }

    public final List<Archive> archives() {
        return this.archives;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArchives() ? this.archives() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListArchivesResponse)) {
            return false;
        }
        ListArchivesResponse other = (ListArchivesResponse)((Object)obj);
        return this.hasArchives() == other.hasArchives() && Objects.equals(this.archives(), other.archives()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListArchivesResponse").add("Archives", this.hasArchives() ? this.archives() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Archives": {
                return Optional.ofNullable(clazz.cast(this.archives()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListArchivesResponse, T> g) {
        return obj -> g.apply((ListArchivesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EventBridgeResponse.BuilderImpl
    implements Builder {
        private List<Archive> archives = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListArchivesResponse model) {
            super(model);
            this.archives(model.archives);
            this.nextToken(model.nextToken);
        }

        public final List<Archive.Builder> getArchives() {
            List<Archive.Builder> result = ArchiveResponseListCopier.copyToBuilder(this.archives);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setArchives(Collection<Archive.BuilderImpl> archives) {
            this.archives = ArchiveResponseListCopier.copyFromBuilder(archives);
        }

        @Override
        public final Builder archives(Collection<Archive> archives) {
            this.archives = ArchiveResponseListCopier.copy(archives);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder archives(Archive ... archives) {
            this.archives(Arrays.asList(archives));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder archives(Consumer<Archive.Builder> ... archives) {
            this.archives(Stream.of(archives).map(c -> (Archive)((Archive.Builder)Archive.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListArchivesResponse build() {
            return new ListArchivesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EventBridgeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListArchivesResponse> {
        public Builder archives(Collection<Archive> var1);

        public Builder archives(Archive ... var1);

        public Builder archives(Consumer<Archive.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

