/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.endpoints.internal;

import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4aAuthScheme;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.eventbridge.endpoints.EventBridgeEndpointParams;
import software.amazon.awssdk.services.eventbridge.endpoints.EventBridgeEndpointProvider;
import software.amazon.awssdk.services.eventbridge.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.eventbridge.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.eventbridge.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultEventBridgeEndpointProvider
implements EventBridgeEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(EventBridgeEndpointParams params) {
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            RuleResult result = DefaultEventBridgeEndpointProvider.endpointRule0(params, new LocalState(params.region()));
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(EventBridgeEndpointParams params, LocalState locals) {
        RuleResult result = DefaultEventBridgeEndpointProvider.endpointRule1(params, locals);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultEventBridgeEndpointProvider.endpointRule12(params, locals);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultEventBridgeEndpointProvider.endpointRule16(params, locals);
        if (result.isResolved()) {
            return result;
        }
        return DefaultEventBridgeEndpointProvider.endpointRule33(params, locals);
    }

    private static RuleResult endpointRule1(EventBridgeEndpointParams params, LocalState locals) {
        if (params.endpointId() != null && locals.region() != null) {
            RulePartition partitionResult = null;
            partitionResult = RulesFunctions.awsPartition(locals.region());
            if (partitionResult != null) {
                RuleResult result = DefaultEventBridgeEndpointProvider.endpointRule2(params, locals = locals.toBuilder().partitionResult(partitionResult).build());
                if (result.isResolved()) {
                    return result;
                }
                return DefaultEventBridgeEndpointProvider.endpointRule11(params, locals);
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule2(EventBridgeEndpointParams params, LocalState locals) {
        if (RulesFunctions.isValidHostLabel(params.endpointId(), true)) {
            RuleResult result = DefaultEventBridgeEndpointProvider.endpointRule3(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultEventBridgeEndpointProvider.endpointRule10(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule3(EventBridgeEndpointParams params, LocalState locals) {
        if (!params.useFips().booleanValue()) {
            RuleResult result = DefaultEventBridgeEndpointProvider.endpointRule4(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultEventBridgeEndpointProvider.endpointRule5(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultEventBridgeEndpointProvider.endpointRule9(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule4(EventBridgeEndpointParams params, LocalState locals) {
        if (params.endpoint() != null) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4aAuthScheme.builder().signingName("events").signingRegionSet(Arrays.asList("*")).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule5(EventBridgeEndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultEventBridgeEndpointProvider.endpointRule6(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultEventBridgeEndpointProvider.endpointRule8(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule6(EventBridgeEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsDualStack()) {
            return DefaultEventBridgeEndpointProvider.endpointRule7(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule7(EventBridgeEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.endpointId() + ".endpoint.events." + locals.partitionResult().dualStackDnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4aAuthScheme.builder().signingName("events").signingRegionSet(Arrays.asList("*")).build())).build());
    }

    private static RuleResult endpointRule8(EventBridgeEndpointParams params, LocalState locals) {
        return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
    }

    private static RuleResult endpointRule9(EventBridgeEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.endpointId() + ".endpoint.events." + locals.partitionResult().dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4aAuthScheme.builder().signingName("events").signingRegionSet(Arrays.asList("*")).build())).build());
    }

    private static RuleResult endpointRule10(EventBridgeEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid Configuration: FIPS is not supported with EventBridge multi-region endpoints.");
    }

    private static RuleResult endpointRule11(EventBridgeEndpointParams params, LocalState locals) {
        return RuleResult.error("EndpointId must be a valid host label.");
    }

    private static RuleResult endpointRule12(EventBridgeEndpointParams params, LocalState locals) {
        if (params.endpoint() != null) {
            RuleResult result = DefaultEventBridgeEndpointProvider.endpointRule13(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultEventBridgeEndpointProvider.endpointRule14(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultEventBridgeEndpointProvider.endpointRule15(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule13(EventBridgeEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule14(EventBridgeEndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            return RuleResult.error("Invalid Configuration: Dualstack and custom endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule15(EventBridgeEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
    }

    private static RuleResult endpointRule16(EventBridgeEndpointParams params, LocalState locals) {
        if (locals.region() != null) {
            return DefaultEventBridgeEndpointProvider.endpointRule17(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule17(EventBridgeEndpointParams params, LocalState locals) {
        RulePartition partitionResult = null;
        partitionResult = RulesFunctions.awsPartition(locals.region());
        if (partitionResult != null) {
            RuleResult result = DefaultEventBridgeEndpointProvider.endpointRule18(params, locals = locals.toBuilder().partitionResult(partitionResult).build());
            if (result.isResolved()) {
                return result;
            }
            result = DefaultEventBridgeEndpointProvider.endpointRule22(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultEventBridgeEndpointProvider.endpointRule28(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultEventBridgeEndpointProvider.endpointRule32(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule18(EventBridgeEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultEventBridgeEndpointProvider.endpointRule19(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultEventBridgeEndpointProvider.endpointRule21(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule19(EventBridgeEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS() && locals.partitionResult().supportsDualStack()) {
            return DefaultEventBridgeEndpointProvider.endpointRule20(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule20(EventBridgeEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://events-fips." + locals.region() + "." + locals.partitionResult().dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule21(EventBridgeEndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static RuleResult endpointRule22(EventBridgeEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultEventBridgeEndpointProvider.endpointRule23(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultEventBridgeEndpointProvider.endpointRule27(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule23(EventBridgeEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS()) {
            RuleResult result = DefaultEventBridgeEndpointProvider.endpointRule24(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultEventBridgeEndpointProvider.endpointRule25(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultEventBridgeEndpointProvider.endpointRule26(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule24(EventBridgeEndpointParams params, LocalState locals) {
        if ("us-gov-east-1".equals(locals.region())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://events.us-gov-east-1.amazonaws.com")).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule25(EventBridgeEndpointParams params, LocalState locals) {
        if ("us-gov-west-1".equals(locals.region())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://events.us-gov-west-1.amazonaws.com")).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule26(EventBridgeEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://events-fips." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
    }

    private static RuleResult endpointRule27(EventBridgeEndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
    }

    private static RuleResult endpointRule28(EventBridgeEndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultEventBridgeEndpointProvider.endpointRule29(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultEventBridgeEndpointProvider.endpointRule31(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule29(EventBridgeEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsDualStack()) {
            return DefaultEventBridgeEndpointProvider.endpointRule30(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule30(EventBridgeEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://events." + locals.region() + "." + locals.partitionResult().dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule31(EventBridgeEndpointParams params, LocalState locals) {
        return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
    }

    private static RuleResult endpointRule32(EventBridgeEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://events." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
    }

    private static RuleResult endpointRule33(EventBridgeEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private static final class LocalStateBuilder {
        private String region;
        private RulePartition partitionResult;

        LocalStateBuilder() {
            this.region = null;
            this.partitionResult = null;
        }

        LocalStateBuilder(LocalState locals) {
            this.region = locals.region;
            this.partitionResult = locals.partitionResult;
        }

        public LocalStateBuilder region(String value) {
            this.region = value;
            return this;
        }

        public LocalStateBuilder partitionResult(RulePartition value) {
            this.partitionResult = value;
            return this;
        }

        LocalState build() {
            return new LocalState(this);
        }
    }

    private static final class LocalState {
        private final String region;
        private final RulePartition partitionResult;

        LocalState() {
            this.region = null;
            this.partitionResult = null;
        }

        LocalState(Region region) {
            this.region = region != null ? region.id() : null;
            this.partitionResult = null;
        }

        LocalState(LocalStateBuilder builder) {
            this.region = builder.region;
            this.partitionResult = builder.partitionResult;
        }

        public String region() {
            return this.region;
        }

        public RulePartition partitionResult() {
            return this.partitionResult;
        }

        public LocalStateBuilder toBuilder() {
            return new LocalStateBuilder(this);
        }
    }
}

