/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.eventbridge.DefaultEventBridgeAsyncClient;
import software.amazon.awssdk.services.eventbridge.DefaultEventBridgeBaseClientBuilder;
import software.amazon.awssdk.services.eventbridge.EventBridgeAsyncClient;
import software.amazon.awssdk.services.eventbridge.EventBridgeAsyncClientBuilder;
import software.amazon.awssdk.services.eventbridge.EventBridgeServiceClientConfiguration;
import software.amazon.awssdk.services.eventbridge.endpoints.EventBridgeEndpointProvider;

@SdkInternalApi
final class DefaultEventBridgeAsyncClientBuilder
extends DefaultEventBridgeBaseClientBuilder<EventBridgeAsyncClientBuilder, EventBridgeAsyncClient>
implements EventBridgeAsyncClientBuilder {
    DefaultEventBridgeAsyncClientBuilder() {
    }

    @Override
    public DefaultEventBridgeAsyncClientBuilder endpointProvider(EventBridgeEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final EventBridgeAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultEventBridgeAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        EventBridgeServiceClientConfiguration serviceClientConfiguration = EventBridgeServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultEventBridgeAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

