/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.eventbridge.DefaultEventBridgeBaseClientBuilder;
import software.amazon.awssdk.services.eventbridge.DefaultEventBridgeClient;
import software.amazon.awssdk.services.eventbridge.EventBridgeClient;
import software.amazon.awssdk.services.eventbridge.EventBridgeClientBuilder;
import software.amazon.awssdk.services.eventbridge.EventBridgeServiceClientConfiguration;
import software.amazon.awssdk.services.eventbridge.endpoints.EventBridgeEndpointProvider;

@SdkInternalApi
final class DefaultEventBridgeClientBuilder
extends DefaultEventBridgeBaseClientBuilder<EventBridgeClientBuilder, EventBridgeClient>
implements EventBridgeClientBuilder {
    DefaultEventBridgeClientBuilder() {
    }

    @Override
    public DefaultEventBridgeClientBuilder endpointProvider(EventBridgeEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final EventBridgeClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultEventBridgeClientBuilder.validateClientOptions(clientConfiguration);
        EventBridgeServiceClientConfiguration serviceClientConfiguration = EventBridgeServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultEventBridgeClient(serviceClientConfiguration, clientConfiguration);
    }
}

