/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.eventbridge.DefaultEventBridgeAsyncClient;
import software.amazon.awssdk.services.eventbridge.DefaultEventBridgeBaseClientBuilder;
import software.amazon.awssdk.services.eventbridge.EventBridgeAsyncClient;
import software.amazon.awssdk.services.eventbridge.EventBridgeAsyncClientBuilder;
import software.amazon.awssdk.services.eventbridge.EventBridgeServiceClientConfiguration;
import software.amazon.awssdk.services.eventbridge.endpoints.EventBridgeEndpointProvider;

@SdkInternalApi
final class DefaultEventBridgeAsyncClientBuilder
extends DefaultEventBridgeBaseClientBuilder<EventBridgeAsyncClientBuilder, EventBridgeAsyncClient>
implements EventBridgeAsyncClientBuilder {
    DefaultEventBridgeAsyncClientBuilder() {
    }

    @Override
    public DefaultEventBridgeAsyncClientBuilder endpointProvider(EventBridgeEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final EventBridgeAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultEventBridgeAsyncClientBuilder.validateClientOptions(clientConfiguration);
        EventBridgeServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultEventBridgeAsyncClient client = new DefaultEventBridgeAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private EventBridgeServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return EventBridgeServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

