/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectionBodyParameter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectionBodyParameter> {
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(ConnectionBodyParameter.getter(ConnectionBodyParameter::key)).setter(ConnectionBodyParameter.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(ConnectionBodyParameter.getter(ConnectionBodyParameter::value)).setter(ConnectionBodyParameter.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<Boolean> IS_VALUE_SECRET_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsValueSecret").getter(ConnectionBodyParameter.getter(ConnectionBodyParameter::isValueSecret)).setter(ConnectionBodyParameter.setter(Builder::isValueSecret)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsValueSecret").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUE_FIELD, IS_VALUE_SECRET_FIELD));
    private static final long serialVersionUID = 1L;
    private final String key;
    private final String value;
    private final Boolean isValueSecret;

    private ConnectionBodyParameter(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
        this.isValueSecret = builder.isValueSecret;
    }

    public final String key() {
        return this.key;
    }

    public final String value() {
        return this.value;
    }

    public final Boolean isValueSecret() {
        return this.isValueSecret;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.isValueSecret());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionBodyParameter)) {
            return false;
        }
        ConnectionBodyParameter other = (ConnectionBodyParameter)obj;
        return Objects.equals(this.key(), other.key()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.isValueSecret(), other.isValueSecret());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectionBodyParameter").add("Key", (Object)this.key()).add("Value", (Object)this.value()).add("IsValueSecret", (Object)this.isValueSecret()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "IsValueSecret": {
                return Optional.ofNullable(clazz.cast(this.isValueSecret()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectionBodyParameter, T> g) {
        return obj -> g.apply((ConnectionBodyParameter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String key;
        private String value;
        private Boolean isValueSecret;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionBodyParameter model) {
            this.key(model.key);
            this.value(model.value);
            this.isValueSecret(model.isValueSecret);
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        @Transient
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        @Transient
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final Boolean getIsValueSecret() {
            return this.isValueSecret;
        }

        public final void setIsValueSecret(Boolean isValueSecret) {
            this.isValueSecret = isValueSecret;
        }

        @Override
        @Transient
        public final Builder isValueSecret(Boolean isValueSecret) {
            this.isValueSecret = isValueSecret;
            return this;
        }

        public ConnectionBodyParameter build() {
            return new ConnectionBodyParameter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectionBodyParameter> {
        public Builder key(String var1);

        public Builder value(String var1);

        public Builder isValueSecret(Boolean var1);
    }
}

