/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eventbridge.model.ArchiveState;
import software.amazon.awssdk.services.eventbridge.model.EventBridgeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateArchiveResponse
extends EventBridgeResponse
implements ToCopyableBuilder<Builder, UpdateArchiveResponse> {
    private static final SdkField<String> ARCHIVE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArchiveArn").getter(UpdateArchiveResponse.getter(UpdateArchiveResponse::archiveArn)).setter(UpdateArchiveResponse.setter(Builder::archiveArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveArn").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(UpdateArchiveResponse.getter(UpdateArchiveResponse::stateAsString)).setter(UpdateArchiveResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> STATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateReason").getter(UpdateArchiveResponse.getter(UpdateArchiveResponse::stateReason)).setter(UpdateArchiveResponse.setter(Builder::stateReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(UpdateArchiveResponse.getter(UpdateArchiveResponse::creationTime)).setter(UpdateArchiveResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVE_ARN_FIELD, STATE_FIELD, STATE_REASON_FIELD, CREATION_TIME_FIELD));
    private final String archiveArn;
    private final String state;
    private final String stateReason;
    private final Instant creationTime;

    private UpdateArchiveResponse(BuilderImpl builder) {
        super(builder);
        this.archiveArn = builder.archiveArn;
        this.state = builder.state;
        this.stateReason = builder.stateReason;
        this.creationTime = builder.creationTime;
    }

    public String archiveArn() {
        return this.archiveArn;
    }

    public ArchiveState state() {
        return ArchiveState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public String stateReason() {
        return this.stateReason;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateArchiveResponse)) {
            return false;
        }
        UpdateArchiveResponse other = (UpdateArchiveResponse)((Object)obj);
        return Objects.equals(this.archiveArn(), other.archiveArn()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateReason(), other.stateReason()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public String toString() {
        return ToString.builder((String)"UpdateArchiveResponse").add("ArchiveArn", (Object)this.archiveArn()).add("State", (Object)this.stateAsString()).add("StateReason", (Object)this.stateReason()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ArchiveArn": {
                return Optional.ofNullable(clazz.cast(this.archiveArn()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateReason": {
                return Optional.ofNullable(clazz.cast(this.stateReason()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateArchiveResponse, T> g) {
        return obj -> g.apply((UpdateArchiveResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EventBridgeResponse.BuilderImpl
    implements Builder {
        private String archiveArn;
        private String state;
        private String stateReason;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateArchiveResponse model) {
            super(model);
            this.archiveArn(model.archiveArn);
            this.state(model.state);
            this.stateReason(model.stateReason);
            this.creationTime(model.creationTime);
        }

        public final String getArchiveArn() {
            return this.archiveArn;
        }

        @Override
        public final Builder archiveArn(String archiveArn) {
            this.archiveArn = archiveArn;
            return this;
        }

        public final void setArchiveArn(String archiveArn) {
            this.archiveArn = archiveArn;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ArchiveState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStateReason() {
            return this.stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public UpdateArchiveResponse build() {
            return new UpdateArchiveResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EventBridgeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateArchiveResponse> {
        public Builder archiveArn(String var1);

        public Builder state(String var1);

        public Builder state(ArchiveState var1);

        public Builder stateReason(String var1);

        public Builder creationTime(Instant var1);
    }
}

