/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eventbridge.model.EventBridgeResponse;
import software.amazon.awssdk.services.eventbridge.model.PartnerEventSource;
import software.amazon.awssdk.services.eventbridge.model.PartnerEventSourceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPartnerEventSourcesResponse
extends EventBridgeResponse
implements ToCopyableBuilder<Builder, ListPartnerEventSourcesResponse> {
    private static final SdkField<List<PartnerEventSource>> PARTNER_EVENT_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListPartnerEventSourcesResponse.getter(ListPartnerEventSourcesResponse::partnerEventSources)).setter(ListPartnerEventSourcesResponse.setter(Builder::partnerEventSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartnerEventSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PartnerEventSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListPartnerEventSourcesResponse.getter(ListPartnerEventSourcesResponse::nextToken)).setter(ListPartnerEventSourcesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTNER_EVENT_SOURCES_FIELD, NEXT_TOKEN_FIELD));
    private final List<PartnerEventSource> partnerEventSources;
    private final String nextToken;

    private ListPartnerEventSourcesResponse(BuilderImpl builder) {
        super(builder);
        this.partnerEventSources = builder.partnerEventSources;
        this.nextToken = builder.nextToken;
    }

    public boolean hasPartnerEventSources() {
        return this.partnerEventSources != null && !(this.partnerEventSources instanceof SdkAutoConstructList);
    }

    public List<PartnerEventSource> partnerEventSources() {
        return this.partnerEventSources;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.partnerEventSources());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPartnerEventSourcesResponse)) {
            return false;
        }
        ListPartnerEventSourcesResponse other = (ListPartnerEventSourcesResponse)((Object)obj);
        return Objects.equals(this.partnerEventSources(), other.partnerEventSources()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListPartnerEventSourcesResponse").add("PartnerEventSources", this.partnerEventSources()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PartnerEventSources": {
                return Optional.ofNullable(clazz.cast(this.partnerEventSources()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPartnerEventSourcesResponse, T> g) {
        return obj -> g.apply((ListPartnerEventSourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EventBridgeResponse.BuilderImpl
    implements Builder {
        private List<PartnerEventSource> partnerEventSources = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPartnerEventSourcesResponse model) {
            super(model);
            this.partnerEventSources(model.partnerEventSources);
            this.nextToken(model.nextToken);
        }

        public final Collection<PartnerEventSource.Builder> getPartnerEventSources() {
            return this.partnerEventSources != null ? (Collection)this.partnerEventSources.stream().map(PartnerEventSource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder partnerEventSources(Collection<PartnerEventSource> partnerEventSources) {
            this.partnerEventSources = PartnerEventSourceListCopier.copy(partnerEventSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partnerEventSources(PartnerEventSource ... partnerEventSources) {
            this.partnerEventSources(Arrays.asList(partnerEventSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partnerEventSources(Consumer<PartnerEventSource.Builder> ... partnerEventSources) {
            this.partnerEventSources(Stream.of(partnerEventSources).map(c -> (PartnerEventSource)((PartnerEventSource.Builder)PartnerEventSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPartnerEventSources(Collection<PartnerEventSource.BuilderImpl> partnerEventSources) {
            this.partnerEventSources = PartnerEventSourceListCopier.copyFromBuilder(partnerEventSources);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPartnerEventSourcesResponse build() {
            return new ListPartnerEventSourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EventBridgeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPartnerEventSourcesResponse> {
        public Builder partnerEventSources(Collection<PartnerEventSource> var1);

        public Builder partnerEventSources(PartnerEventSource ... var1);

        public Builder partnerEventSources(Consumer<PartnerEventSource.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

