/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.eventbridge.EventBridgeClient;
import software.amazon.awssdk.services.eventbridge.model.ActivateEventSourceRequest;
import software.amazon.awssdk.services.eventbridge.model.ActivateEventSourceResponse;
import software.amazon.awssdk.services.eventbridge.model.ConcurrentModificationException;
import software.amazon.awssdk.services.eventbridge.model.CreateEventBusRequest;
import software.amazon.awssdk.services.eventbridge.model.CreateEventBusResponse;
import software.amazon.awssdk.services.eventbridge.model.CreatePartnerEventSourceRequest;
import software.amazon.awssdk.services.eventbridge.model.CreatePartnerEventSourceResponse;
import software.amazon.awssdk.services.eventbridge.model.DeactivateEventSourceRequest;
import software.amazon.awssdk.services.eventbridge.model.DeactivateEventSourceResponse;
import software.amazon.awssdk.services.eventbridge.model.DeleteEventBusRequest;
import software.amazon.awssdk.services.eventbridge.model.DeleteEventBusResponse;
import software.amazon.awssdk.services.eventbridge.model.DeletePartnerEventSourceRequest;
import software.amazon.awssdk.services.eventbridge.model.DeletePartnerEventSourceResponse;
import software.amazon.awssdk.services.eventbridge.model.DeleteRuleRequest;
import software.amazon.awssdk.services.eventbridge.model.DeleteRuleResponse;
import software.amazon.awssdk.services.eventbridge.model.DescribeEventBusRequest;
import software.amazon.awssdk.services.eventbridge.model.DescribeEventBusResponse;
import software.amazon.awssdk.services.eventbridge.model.DescribeEventSourceRequest;
import software.amazon.awssdk.services.eventbridge.model.DescribeEventSourceResponse;
import software.amazon.awssdk.services.eventbridge.model.DescribePartnerEventSourceRequest;
import software.amazon.awssdk.services.eventbridge.model.DescribePartnerEventSourceResponse;
import software.amazon.awssdk.services.eventbridge.model.DescribeRuleRequest;
import software.amazon.awssdk.services.eventbridge.model.DescribeRuleResponse;
import software.amazon.awssdk.services.eventbridge.model.DisableRuleRequest;
import software.amazon.awssdk.services.eventbridge.model.DisableRuleResponse;
import software.amazon.awssdk.services.eventbridge.model.EnableRuleRequest;
import software.amazon.awssdk.services.eventbridge.model.EnableRuleResponse;
import software.amazon.awssdk.services.eventbridge.model.EventBridgeException;
import software.amazon.awssdk.services.eventbridge.model.InternalException;
import software.amazon.awssdk.services.eventbridge.model.InvalidEventPatternException;
import software.amazon.awssdk.services.eventbridge.model.InvalidStateException;
import software.amazon.awssdk.services.eventbridge.model.LimitExceededException;
import software.amazon.awssdk.services.eventbridge.model.ListEventBusesRequest;
import software.amazon.awssdk.services.eventbridge.model.ListEventBusesResponse;
import software.amazon.awssdk.services.eventbridge.model.ListEventSourcesRequest;
import software.amazon.awssdk.services.eventbridge.model.ListEventSourcesResponse;
import software.amazon.awssdk.services.eventbridge.model.ListPartnerEventSourceAccountsRequest;
import software.amazon.awssdk.services.eventbridge.model.ListPartnerEventSourceAccountsResponse;
import software.amazon.awssdk.services.eventbridge.model.ListPartnerEventSourcesRequest;
import software.amazon.awssdk.services.eventbridge.model.ListPartnerEventSourcesResponse;
import software.amazon.awssdk.services.eventbridge.model.ListRuleNamesByTargetRequest;
import software.amazon.awssdk.services.eventbridge.model.ListRuleNamesByTargetResponse;
import software.amazon.awssdk.services.eventbridge.model.ListRulesRequest;
import software.amazon.awssdk.services.eventbridge.model.ListRulesResponse;
import software.amazon.awssdk.services.eventbridge.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.eventbridge.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.eventbridge.model.ListTargetsByRuleRequest;
import software.amazon.awssdk.services.eventbridge.model.ListTargetsByRuleResponse;
import software.amazon.awssdk.services.eventbridge.model.ManagedRuleException;
import software.amazon.awssdk.services.eventbridge.model.PolicyLengthExceededException;
import software.amazon.awssdk.services.eventbridge.model.PutEventsRequest;
import software.amazon.awssdk.services.eventbridge.model.PutEventsResponse;
import software.amazon.awssdk.services.eventbridge.model.PutPartnerEventsRequest;
import software.amazon.awssdk.services.eventbridge.model.PutPartnerEventsResponse;
import software.amazon.awssdk.services.eventbridge.model.PutPermissionRequest;
import software.amazon.awssdk.services.eventbridge.model.PutPermissionResponse;
import software.amazon.awssdk.services.eventbridge.model.PutRuleRequest;
import software.amazon.awssdk.services.eventbridge.model.PutRuleResponse;
import software.amazon.awssdk.services.eventbridge.model.PutTargetsRequest;
import software.amazon.awssdk.services.eventbridge.model.PutTargetsResponse;
import software.amazon.awssdk.services.eventbridge.model.RemovePermissionRequest;
import software.amazon.awssdk.services.eventbridge.model.RemovePermissionResponse;
import software.amazon.awssdk.services.eventbridge.model.RemoveTargetsRequest;
import software.amazon.awssdk.services.eventbridge.model.RemoveTargetsResponse;
import software.amazon.awssdk.services.eventbridge.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.eventbridge.model.ResourceNotFoundException;
import software.amazon.awssdk.services.eventbridge.model.TagResourceRequest;
import software.amazon.awssdk.services.eventbridge.model.TagResourceResponse;
import software.amazon.awssdk.services.eventbridge.model.TestEventPatternRequest;
import software.amazon.awssdk.services.eventbridge.model.TestEventPatternResponse;
import software.amazon.awssdk.services.eventbridge.model.UntagResourceRequest;
import software.amazon.awssdk.services.eventbridge.model.UntagResourceResponse;
import software.amazon.awssdk.services.eventbridge.transform.ActivateEventSourceRequestMarshaller;
import software.amazon.awssdk.services.eventbridge.transform.CreateEventBusRequestMarshaller;
import software.amazon.awssdk.services.eventbridge.transform.CreatePartnerEventSourceRequestMarshaller;
import software.amazon.awssdk.services.eventbridge.transform.DeactivateEventSourceRequestMarshaller;
import software.amazon.awssdk.services.eventbridge.transform.DeleteEventBusRequestMarshaller;
import software.amazon.awssdk.services.eventbridge.transform.DeletePartnerEventSourceRequestMarshaller;
import software.amazon.awssdk.services.eventbridge.transform.DeleteRuleRequestMarshaller;
import software.amazon.awssdk.services.eventbridge.transform.DescribeEventBusRequestMarshaller;
import software.amazon.awssdk.services.eventbridge.transform.DescribeEventSourceRequestMarshaller;
import software.amazon.awssdk.services.eventbridge.transform.DescribePartnerEventSourceRequestMarshaller;
import software.amazon.awssdk.services.eventbridge.transform.DescribeRuleRequestMarshaller;
import software.amazon.awssdk.services.eventbridge.transform.DisableRuleRequestMarshaller;
import software.amazon.awssdk.services.eventbridge.transform.EnableRuleRequestMarshaller;
import software.amazon.awssdk.services.eventbridge.transform.ListEventBusesRequestMarshaller;
import software.amazon.awssdk.services.eventbridge.transform.ListEventSourcesRequestMarshaller;
import software.amazon.awssdk.services.eventbridge.transform.ListPartnerEventSourceAccountsRequestMarshaller;
import software.amazon.awssdk.services.eventbridge.transform.ListPartnerEventSourcesRequestMarshaller;
import software.amazon.awssdk.services.eventbridge.transform.ListRuleNamesByTargetRequestMarshaller;
import software.amazon.awssdk.services.eventbridge.transform.ListRulesRequestMarshaller;
import software.amazon.awssdk.services.eventbridge.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.eventbridge.transform.ListTargetsByRuleRequestMarshaller;
import software.amazon.awssdk.services.eventbridge.transform.PutEventsRequestMarshaller;
import software.amazon.awssdk.services.eventbridge.transform.PutPartnerEventsRequestMarshaller;
import software.amazon.awssdk.services.eventbridge.transform.PutPermissionRequestMarshaller;
import software.amazon.awssdk.services.eventbridge.transform.PutRuleRequestMarshaller;
import software.amazon.awssdk.services.eventbridge.transform.PutTargetsRequestMarshaller;
import software.amazon.awssdk.services.eventbridge.transform.RemovePermissionRequestMarshaller;
import software.amazon.awssdk.services.eventbridge.transform.RemoveTargetsRequestMarshaller;
import software.amazon.awssdk.services.eventbridge.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.eventbridge.transform.TestEventPatternRequestMarshaller;
import software.amazon.awssdk.services.eventbridge.transform.UntagResourceRequestMarshaller;

@SdkInternalApi
final class DefaultEventBridgeClient
implements EventBridgeClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultEventBridgeClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "events";
    }

    @Override
    public ActivateEventSourceResponse activateEventSource(ActivateEventSourceRequest activateEventSourceRequest) throws ResourceNotFoundException, ConcurrentModificationException, InvalidStateException, InternalException, AwsServiceException, SdkClientException, EventBridgeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ActivateEventSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ActivateEventSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ActivateEventSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)activateEventSourceRequest).withMarshaller((Marshaller)new ActivateEventSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateEventBusResponse createEventBus(CreateEventBusRequest createEventBusRequest) throws ResourceAlreadyExistsException, ResourceNotFoundException, InvalidStateException, InternalException, ConcurrentModificationException, LimitExceededException, AwsServiceException, SdkClientException, EventBridgeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEventBusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateEventBusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEventBus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createEventBusRequest).withMarshaller((Marshaller)new CreateEventBusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreatePartnerEventSourceResponse createPartnerEventSource(CreatePartnerEventSourceRequest createPartnerEventSourceRequest) throws ResourceAlreadyExistsException, InternalException, ConcurrentModificationException, LimitExceededException, AwsServiceException, SdkClientException, EventBridgeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePartnerEventSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreatePartnerEventSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePartnerEventSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPartnerEventSourceRequest).withMarshaller((Marshaller)new CreatePartnerEventSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeactivateEventSourceResponse deactivateEventSource(DeactivateEventSourceRequest deactivateEventSourceRequest) throws ResourceNotFoundException, ConcurrentModificationException, InvalidStateException, InternalException, AwsServiceException, SdkClientException, EventBridgeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeactivateEventSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeactivateEventSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeactivateEventSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deactivateEventSourceRequest).withMarshaller((Marshaller)new DeactivateEventSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteEventBusResponse deleteEventBus(DeleteEventBusRequest deleteEventBusRequest) throws InternalException, ConcurrentModificationException, AwsServiceException, SdkClientException, EventBridgeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEventBusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteEventBusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEventBus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEventBusRequest).withMarshaller((Marshaller)new DeleteEventBusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeletePartnerEventSourceResponse deletePartnerEventSource(DeletePartnerEventSourceRequest deletePartnerEventSourceRequest) throws InternalException, ConcurrentModificationException, AwsServiceException, SdkClientException, EventBridgeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePartnerEventSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeletePartnerEventSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePartnerEventSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePartnerEventSourceRequest).withMarshaller((Marshaller)new DeletePartnerEventSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteRuleResponse deleteRule(DeleteRuleRequest deleteRuleRequest) throws ConcurrentModificationException, ManagedRuleException, InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException, EventBridgeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRuleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteRuleRequest).withMarshaller((Marshaller)new DeleteRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeEventBusResponse describeEventBus(DescribeEventBusRequest describeEventBusRequest) throws ResourceNotFoundException, InternalException, AwsServiceException, SdkClientException, EventBridgeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEventBusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeEventBusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventBus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventBusRequest).withMarshaller((Marshaller)new DescribeEventBusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeEventSourceResponse describeEventSource(DescribeEventSourceRequest describeEventSourceRequest) throws ResourceNotFoundException, InternalException, AwsServiceException, SdkClientException, EventBridgeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEventSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeEventSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventSourceRequest).withMarshaller((Marshaller)new DescribeEventSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribePartnerEventSourceResponse describePartnerEventSource(DescribePartnerEventSourceRequest describePartnerEventSourceRequest) throws ResourceNotFoundException, InternalException, AwsServiceException, SdkClientException, EventBridgeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePartnerEventSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribePartnerEventSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePartnerEventSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describePartnerEventSourceRequest).withMarshaller((Marshaller)new DescribePartnerEventSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeRuleResponse describeRule(DescribeRuleRequest describeRuleRequest) throws ResourceNotFoundException, InternalException, AwsServiceException, SdkClientException, EventBridgeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRuleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeRuleRequest).withMarshaller((Marshaller)new DescribeRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DisableRuleResponse disableRule(DisableRuleRequest disableRuleRequest) throws ResourceNotFoundException, ConcurrentModificationException, ManagedRuleException, InternalException, AwsServiceException, SdkClientException, EventBridgeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableRuleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DisableRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableRuleRequest).withMarshaller((Marshaller)new DisableRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public EnableRuleResponse enableRule(EnableRuleRequest enableRuleRequest) throws ResourceNotFoundException, ConcurrentModificationException, ManagedRuleException, InternalException, AwsServiceException, SdkClientException, EventBridgeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableRuleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (EnableRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableRuleRequest).withMarshaller((Marshaller)new EnableRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListEventBusesResponse listEventBuses(ListEventBusesRequest listEventBusesRequest) throws InternalException, AwsServiceException, SdkClientException, EventBridgeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEventBusesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListEventBusesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEventBuses").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listEventBusesRequest).withMarshaller((Marshaller)new ListEventBusesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListEventSourcesResponse listEventSources(ListEventSourcesRequest listEventSourcesRequest) throws InternalException, AwsServiceException, SdkClientException, EventBridgeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEventSourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListEventSourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEventSources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listEventSourcesRequest).withMarshaller((Marshaller)new ListEventSourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListPartnerEventSourceAccountsResponse listPartnerEventSourceAccounts(ListPartnerEventSourceAccountsRequest listPartnerEventSourceAccountsRequest) throws ResourceNotFoundException, InternalException, AwsServiceException, SdkClientException, EventBridgeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPartnerEventSourceAccountsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListPartnerEventSourceAccountsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPartnerEventSourceAccounts").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPartnerEventSourceAccountsRequest).withMarshaller((Marshaller)new ListPartnerEventSourceAccountsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListPartnerEventSourcesResponse listPartnerEventSources(ListPartnerEventSourcesRequest listPartnerEventSourcesRequest) throws InternalException, AwsServiceException, SdkClientException, EventBridgeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPartnerEventSourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListPartnerEventSourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPartnerEventSources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPartnerEventSourcesRequest).withMarshaller((Marshaller)new ListPartnerEventSourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListRuleNamesByTargetResponse listRuleNamesByTarget(ListRuleNamesByTargetRequest listRuleNamesByTargetRequest) throws InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException, EventBridgeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRuleNamesByTargetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListRuleNamesByTargetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRuleNamesByTarget").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRuleNamesByTargetRequest).withMarshaller((Marshaller)new ListRuleNamesByTargetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListRulesResponse listRules(ListRulesRequest listRulesRequest) throws InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException, EventBridgeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRulesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListRulesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRules").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRulesRequest).withMarshaller((Marshaller)new ListRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, InternalException, AwsServiceException, SdkClientException, EventBridgeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListTargetsByRuleResponse listTargetsByRule(ListTargetsByRuleRequest listTargetsByRuleRequest) throws ResourceNotFoundException, InternalException, AwsServiceException, SdkClientException, EventBridgeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTargetsByRuleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListTargetsByRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTargetsByRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTargetsByRuleRequest).withMarshaller((Marshaller)new ListTargetsByRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutEventsResponse putEvents(PutEventsRequest putEventsRequest) throws InternalException, AwsServiceException, SdkClientException, EventBridgeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutEventsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutEvents").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putEventsRequest).withMarshaller((Marshaller)new PutEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutPartnerEventsResponse putPartnerEvents(PutPartnerEventsRequest putPartnerEventsRequest) throws InternalException, AwsServiceException, SdkClientException, EventBridgeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutPartnerEventsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutPartnerEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutPartnerEvents").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putPartnerEventsRequest).withMarshaller((Marshaller)new PutPartnerEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutPermissionResponse putPermission(PutPermissionRequest putPermissionRequest) throws ResourceNotFoundException, PolicyLengthExceededException, InternalException, ConcurrentModificationException, AwsServiceException, SdkClientException, EventBridgeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutPermissionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutPermissionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutPermission").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putPermissionRequest).withMarshaller((Marshaller)new PutPermissionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutRuleResponse putRule(PutRuleRequest putRuleRequest) throws InvalidEventPatternException, LimitExceededException, ConcurrentModificationException, ManagedRuleException, InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException, EventBridgeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutRuleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putRuleRequest).withMarshaller((Marshaller)new PutRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutTargetsResponse putTargets(PutTargetsRequest putTargetsRequest) throws ResourceNotFoundException, ConcurrentModificationException, LimitExceededException, ManagedRuleException, InternalException, AwsServiceException, SdkClientException, EventBridgeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutTargetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutTargetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutTargets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putTargetsRequest).withMarshaller((Marshaller)new PutTargetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public RemovePermissionResponse removePermission(RemovePermissionRequest removePermissionRequest) throws ResourceNotFoundException, InternalException, ConcurrentModificationException, AwsServiceException, SdkClientException, EventBridgeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemovePermissionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RemovePermissionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemovePermission").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removePermissionRequest).withMarshaller((Marshaller)new RemovePermissionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public RemoveTargetsResponse removeTargets(RemoveTargetsRequest removeTargetsRequest) throws ResourceNotFoundException, ConcurrentModificationException, ManagedRuleException, InternalException, AwsServiceException, SdkClientException, EventBridgeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveTargetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RemoveTargetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTargets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeTargetsRequest).withMarshaller((Marshaller)new RemoveTargetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, ConcurrentModificationException, InternalException, ManagedRuleException, AwsServiceException, SdkClientException, EventBridgeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public TestEventPatternResponse testEventPattern(TestEventPatternRequest testEventPatternRequest) throws InvalidEventPatternException, InternalException, AwsServiceException, SdkClientException, EventBridgeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TestEventPatternResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (TestEventPatternResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TestEventPattern").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)testEventPatternRequest).withMarshaller((Marshaller)new TestEventPatternRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, InternalException, ConcurrentModificationException, ManagedRuleException, AwsServiceException, SdkClientException, EventBridgeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(EventBridgeException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").exceptionBuilderSupplier(PolicyLengthExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidStateException").exceptionBuilderSupplier(InvalidStateException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").exceptionBuilderSupplier(InvalidEventPatternException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalException").exceptionBuilderSupplier(InternalException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ManagedRuleException").exceptionBuilderSupplier(ManagedRuleException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }
}

