/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobMetrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobMetrics> {
    private static final SdkField<Integer> INPUT_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("inputRecords").getter(JobMetrics.getter(JobMetrics::inputRecords)).setter(JobMetrics.setter(Builder::inputRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputRecords").build()}).build();
    private static final SdkField<Integer> TOTAL_RECORDS_PROCESSED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("totalRecordsProcessed").getter(JobMetrics.getter(JobMetrics::totalRecordsProcessed)).setter(JobMetrics.setter(Builder::totalRecordsProcessed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalRecordsProcessed").build()}).build();
    private static final SdkField<Integer> RECORDS_NOT_PROCESSED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("recordsNotProcessed").getter(JobMetrics.getter(JobMetrics::recordsNotProcessed)).setter(JobMetrics.setter(Builder::recordsNotProcessed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordsNotProcessed").build()}).build();
    private static final SdkField<Integer> DELETE_RECORDS_PROCESSED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("deleteRecordsProcessed").getter(JobMetrics.getter(JobMetrics::deleteRecordsProcessed)).setter(JobMetrics.setter(Builder::deleteRecordsProcessed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteRecordsProcessed").build()}).build();
    private static final SdkField<Integer> MATCH_I_DS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("matchIDs").getter(JobMetrics.getter(JobMetrics::matchIDs)).setter(JobMetrics.setter(Builder::matchIDs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchIDs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_RECORDS_FIELD, TOTAL_RECORDS_PROCESSED_FIELD, RECORDS_NOT_PROCESSED_FIELD, DELETE_RECORDS_PROCESSED_FIELD, MATCH_I_DS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = JobMetrics.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer inputRecords;
    private final Integer totalRecordsProcessed;
    private final Integer recordsNotProcessed;
    private final Integer deleteRecordsProcessed;
    private final Integer matchIDs;

    private JobMetrics(BuilderImpl builder) {
        this.inputRecords = builder.inputRecords;
        this.totalRecordsProcessed = builder.totalRecordsProcessed;
        this.recordsNotProcessed = builder.recordsNotProcessed;
        this.deleteRecordsProcessed = builder.deleteRecordsProcessed;
        this.matchIDs = builder.matchIDs;
    }

    public final Integer inputRecords() {
        return this.inputRecords;
    }

    public final Integer totalRecordsProcessed() {
        return this.totalRecordsProcessed;
    }

    public final Integer recordsNotProcessed() {
        return this.recordsNotProcessed;
    }

    public final Integer deleteRecordsProcessed() {
        return this.deleteRecordsProcessed;
    }

    public final Integer matchIDs() {
        return this.matchIDs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalRecordsProcessed());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordsNotProcessed());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteRecordsProcessed());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchIDs());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobMetrics)) {
            return false;
        }
        JobMetrics other = (JobMetrics)obj;
        return Objects.equals(this.inputRecords(), other.inputRecords()) && Objects.equals(this.totalRecordsProcessed(), other.totalRecordsProcessed()) && Objects.equals(this.recordsNotProcessed(), other.recordsNotProcessed()) && Objects.equals(this.deleteRecordsProcessed(), other.deleteRecordsProcessed()) && Objects.equals(this.matchIDs(), other.matchIDs());
    }

    public final String toString() {
        return ToString.builder((String)"JobMetrics").add("InputRecords", (Object)this.inputRecords()).add("TotalRecordsProcessed", (Object)this.totalRecordsProcessed()).add("RecordsNotProcessed", (Object)this.recordsNotProcessed()).add("DeleteRecordsProcessed", (Object)this.deleteRecordsProcessed()).add("MatchIDs", (Object)this.matchIDs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inputRecords": {
                return Optional.ofNullable(clazz.cast(this.inputRecords()));
            }
            case "totalRecordsProcessed": {
                return Optional.ofNullable(clazz.cast(this.totalRecordsProcessed()));
            }
            case "recordsNotProcessed": {
                return Optional.ofNullable(clazz.cast(this.recordsNotProcessed()));
            }
            case "deleteRecordsProcessed": {
                return Optional.ofNullable(clazz.cast(this.deleteRecordsProcessed()));
            }
            case "matchIDs": {
                return Optional.ofNullable(clazz.cast(this.matchIDs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Integer>> map = new HashMap<String, SdkField<Integer>>();
        map.put("inputRecords", INPUT_RECORDS_FIELD);
        map.put("totalRecordsProcessed", TOTAL_RECORDS_PROCESSED_FIELD);
        map.put("recordsNotProcessed", RECORDS_NOT_PROCESSED_FIELD);
        map.put("deleteRecordsProcessed", DELETE_RECORDS_PROCESSED_FIELD);
        map.put("matchIDs", MATCH_I_DS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobMetrics, T> g) {
        return obj -> g.apply((JobMetrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer inputRecords;
        private Integer totalRecordsProcessed;
        private Integer recordsNotProcessed;
        private Integer deleteRecordsProcessed;
        private Integer matchIDs;

        private BuilderImpl() {
        }

        private BuilderImpl(JobMetrics model) {
            this.inputRecords(model.inputRecords);
            this.totalRecordsProcessed(model.totalRecordsProcessed);
            this.recordsNotProcessed(model.recordsNotProcessed);
            this.deleteRecordsProcessed(model.deleteRecordsProcessed);
            this.matchIDs(model.matchIDs);
        }

        public final Integer getInputRecords() {
            return this.inputRecords;
        }

        public final void setInputRecords(Integer inputRecords) {
            this.inputRecords = inputRecords;
        }

        @Override
        public final Builder inputRecords(Integer inputRecords) {
            this.inputRecords = inputRecords;
            return this;
        }

        public final Integer getTotalRecordsProcessed() {
            return this.totalRecordsProcessed;
        }

        public final void setTotalRecordsProcessed(Integer totalRecordsProcessed) {
            this.totalRecordsProcessed = totalRecordsProcessed;
        }

        @Override
        public final Builder totalRecordsProcessed(Integer totalRecordsProcessed) {
            this.totalRecordsProcessed = totalRecordsProcessed;
            return this;
        }

        public final Integer getRecordsNotProcessed() {
            return this.recordsNotProcessed;
        }

        public final void setRecordsNotProcessed(Integer recordsNotProcessed) {
            this.recordsNotProcessed = recordsNotProcessed;
        }

        @Override
        public final Builder recordsNotProcessed(Integer recordsNotProcessed) {
            this.recordsNotProcessed = recordsNotProcessed;
            return this;
        }

        public final Integer getDeleteRecordsProcessed() {
            return this.deleteRecordsProcessed;
        }

        public final void setDeleteRecordsProcessed(Integer deleteRecordsProcessed) {
            this.deleteRecordsProcessed = deleteRecordsProcessed;
        }

        @Override
        public final Builder deleteRecordsProcessed(Integer deleteRecordsProcessed) {
            this.deleteRecordsProcessed = deleteRecordsProcessed;
            return this;
        }

        public final Integer getMatchIDs() {
            return this.matchIDs;
        }

        public final void setMatchIDs(Integer matchIDs) {
            this.matchIDs = matchIDs;
        }

        @Override
        public final Builder matchIDs(Integer matchIDs) {
            this.matchIDs = matchIDs;
            return this;
        }

        public JobMetrics build() {
            return new JobMetrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobMetrics> {
        public Builder inputRecords(Integer var1);

        public Builder totalRecordsProcessed(Integer var1);

        public Builder recordsNotProcessed(Integer var1);

        public Builder deleteRecordsProcessed(Integer var1);

        public Builder matchIDs(Integer var1);
    }
}

