/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.entityresolution.model.EntityResolutionRequest;
import software.amazon.awssdk.services.entityresolution.model.GenerateMatchIdInputRecordsListCopier;
import software.amazon.awssdk.services.entityresolution.model.ProcessingType;
import software.amazon.awssdk.services.entityresolution.model.Record;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GenerateMatchIdRequest
extends EntityResolutionRequest
implements ToCopyableBuilder<Builder, GenerateMatchIdRequest> {
    private static final SdkField<String> WORKFLOW_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowName").getter(GenerateMatchIdRequest.getter(GenerateMatchIdRequest::workflowName)).setter(GenerateMatchIdRequest.setter(Builder::workflowName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workflowName").build()}).build();
    private static final SdkField<List<Record>> RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("records").getter(GenerateMatchIdRequest.getter(GenerateMatchIdRequest::records)).setter(GenerateMatchIdRequest.setter(Builder::records)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("records").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Record::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PROCESSING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("processingType").getter(GenerateMatchIdRequest.getter(GenerateMatchIdRequest::processingTypeAsString)).setter(GenerateMatchIdRequest.setter(Builder::processingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("processingType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_NAME_FIELD, RECORDS_FIELD, PROCESSING_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GenerateMatchIdRequest.memberNameToFieldInitializer();
    private final String workflowName;
    private final List<Record> records;
    private final String processingType;

    private GenerateMatchIdRequest(BuilderImpl builder) {
        super(builder);
        this.workflowName = builder.workflowName;
        this.records = builder.records;
        this.processingType = builder.processingType;
    }

    public final String workflowName() {
        return this.workflowName;
    }

    public final boolean hasRecords() {
        return this.records != null && !(this.records instanceof SdkAutoConstructList);
    }

    public final List<Record> records() {
        return this.records;
    }

    public final ProcessingType processingType() {
        return ProcessingType.fromValue(this.processingType);
    }

    public final String processingTypeAsString() {
        return this.processingType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecords() ? this.records() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.processingTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateMatchIdRequest)) {
            return false;
        }
        GenerateMatchIdRequest other = (GenerateMatchIdRequest)((Object)obj);
        return Objects.equals(this.workflowName(), other.workflowName()) && this.hasRecords() == other.hasRecords() && Objects.equals(this.records(), other.records()) && Objects.equals(this.processingTypeAsString(), other.processingTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GenerateMatchIdRequest").add("WorkflowName", (Object)this.workflowName()).add("Records", this.hasRecords() ? this.records() : null).add("ProcessingType", (Object)this.processingTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workflowName": {
                return Optional.ofNullable(clazz.cast(this.workflowName()));
            }
            case "records": {
                return Optional.ofNullable(clazz.cast(this.records()));
            }
            case "processingType": {
                return Optional.ofNullable(clazz.cast(this.processingTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("workflowName", WORKFLOW_NAME_FIELD);
        map.put("records", RECORDS_FIELD);
        map.put("processingType", PROCESSING_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GenerateMatchIdRequest, T> g) {
        return obj -> g.apply((GenerateMatchIdRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EntityResolutionRequest.BuilderImpl
    implements Builder {
        private String workflowName;
        private List<Record> records = DefaultSdkAutoConstructList.getInstance();
        private String processingType;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateMatchIdRequest model) {
            super(model);
            this.workflowName(model.workflowName);
            this.records(model.records);
            this.processingType(model.processingType);
        }

        public final String getWorkflowName() {
            return this.workflowName;
        }

        public final void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        @Override
        public final Builder workflowName(String workflowName) {
            this.workflowName = workflowName;
            return this;
        }

        public final List<Record.Builder> getRecords() {
            List<Record.Builder> result = GenerateMatchIdInputRecordsListCopier.copyToBuilder(this.records);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecords(Collection<Record.BuilderImpl> records) {
            this.records = GenerateMatchIdInputRecordsListCopier.copyFromBuilder(records);
        }

        @Override
        public final Builder records(Collection<Record> records) {
            this.records = GenerateMatchIdInputRecordsListCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Record ... records) {
            this.records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<Record.Builder> ... records) {
            this.records(Stream.of(records).map(c -> (Record)((Record.Builder)Record.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getProcessingType() {
            return this.processingType;
        }

        public final void setProcessingType(String processingType) {
            this.processingType = processingType;
        }

        @Override
        public final Builder processingType(String processingType) {
            this.processingType = processingType;
            return this;
        }

        @Override
        public final Builder processingType(ProcessingType processingType) {
            this.processingType(processingType == null ? null : processingType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GenerateMatchIdRequest build() {
            return new GenerateMatchIdRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EntityResolutionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GenerateMatchIdRequest> {
        public Builder workflowName(String var1);

        public Builder records(Collection<Record> var1);

        public Builder records(Record ... var1);

        public Builder records(Consumer<Record.Builder> ... var1);

        public Builder processingType(String var1);

        public Builder processingType(ProcessingType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

