/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The match group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MatchGroup implements SdkPojo, Serializable, ToCopyableBuilder<MatchGroup.Builder, MatchGroup> {
    private static final SdkField<List<MatchedRecord>> RECORDS_FIELD = SdkField
            .<List<MatchedRecord>> builder(MarshallingType.LIST)
            .memberName("records")
            .getter(getter(MatchGroup::records))
            .setter(setter(Builder::records))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("records").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MatchedRecord> builder(MarshallingType.SDK_POJO)
                                            .constructor(MatchedRecord::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MATCH_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("matchId").getter(getter(MatchGroup::matchId)).setter(setter(Builder::matchId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchId").build()).build();

    private static final SdkField<String> MATCH_RULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("matchRule").getter(getter(MatchGroup::matchRule)).setter(setter(Builder::matchRule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchRule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORDS_FIELD, MATCH_ID_FIELD,
            MATCH_RULE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<MatchedRecord> records;

    private final String matchId;

    private final String matchRule;

    private MatchGroup(BuilderImpl builder) {
        this.records = builder.records;
        this.matchId = builder.matchId;
        this.matchRule = builder.matchRule;
    }

    /**
     * For responses, this returns true if the service returned a value for the Records property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRecords() {
        return records != null && !(records instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The matched records.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecords} method.
     * </p>
     * 
     * @return The matched records.
     */
    public final List<MatchedRecord> records() {
        return records;
    }

    /**
     * <p>
     * The match ID.
     * </p>
     * 
     * @return The match ID.
     */
    public final String matchId() {
        return matchId;
    }

    /**
     * <p>
     * The match rule of the match group.
     * </p>
     * 
     * @return The match rule of the match group.
     */
    public final String matchRule() {
        return matchRule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRecords() ? records() : null);
        hashCode = 31 * hashCode + Objects.hashCode(matchId());
        hashCode = 31 * hashCode + Objects.hashCode(matchRule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatchGroup)) {
            return false;
        }
        MatchGroup other = (MatchGroup) obj;
        return hasRecords() == other.hasRecords() && Objects.equals(records(), other.records())
                && Objects.equals(matchId(), other.matchId()) && Objects.equals(matchRule(), other.matchRule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MatchGroup").add("Records", hasRecords() ? records() : null).add("MatchId", matchId())
                .add("MatchRule", matchRule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "records":
            return Optional.ofNullable(clazz.cast(records()));
        case "matchId":
            return Optional.ofNullable(clazz.cast(matchId()));
        case "matchRule":
            return Optional.ofNullable(clazz.cast(matchRule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("records", RECORDS_FIELD);
        map.put("matchId", MATCH_ID_FIELD);
        map.put("matchRule", MATCH_RULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MatchGroup, T> g) {
        return obj -> g.apply((MatchGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MatchGroup> {
        /**
         * <p>
         * The matched records.
         * </p>
         * 
         * @param records
         *        The matched records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Collection<MatchedRecord> records);

        /**
         * <p>
         * The matched records.
         * </p>
         * 
         * @param records
         *        The matched records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(MatchedRecord... records);

        /**
         * <p>
         * The matched records.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.entityresolution.model.MatchedRecord.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.entityresolution.model.MatchedRecord#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.entityresolution.model.MatchedRecord.Builder#build()} is called
         * immediately and its result is passed to {@link #records(List<MatchedRecord>)}.
         * 
         * @param records
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.entityresolution.model.MatchedRecord.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #records(java.util.Collection<MatchedRecord>)
         */
        Builder records(Consumer<MatchedRecord.Builder>... records);

        /**
         * <p>
         * The match ID.
         * </p>
         * 
         * @param matchId
         *        The match ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchId(String matchId);

        /**
         * <p>
         * The match rule of the match group.
         * </p>
         * 
         * @param matchRule
         *        The match rule of the match group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchRule(String matchRule);
    }

    static final class BuilderImpl implements Builder {
        private List<MatchedRecord> records = DefaultSdkAutoConstructList.getInstance();

        private String matchId;

        private String matchRule;

        private BuilderImpl() {
        }

        private BuilderImpl(MatchGroup model) {
            records(model.records);
            matchId(model.matchId);
            matchRule(model.matchRule);
        }

        public final List<MatchedRecord.Builder> getRecords() {
            List<MatchedRecord.Builder> result = MatchedRecordsListCopier.copyToBuilder(this.records);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecords(Collection<MatchedRecord.BuilderImpl> records) {
            this.records = MatchedRecordsListCopier.copyFromBuilder(records);
        }

        @Override
        public final Builder records(Collection<MatchedRecord> records) {
            this.records = MatchedRecordsListCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(MatchedRecord... records) {
            records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<MatchedRecord.Builder>... records) {
            records(Stream.of(records).map(c -> MatchedRecord.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMatchId() {
            return matchId;
        }

        public final void setMatchId(String matchId) {
            this.matchId = matchId;
        }

        @Override
        public final Builder matchId(String matchId) {
            this.matchId = matchId;
            return this;
        }

        public final String getMatchRule() {
            return matchRule;
        }

        public final void setMatchRule(String matchRule) {
            this.matchRule = matchRule;
        }

        @Override
        public final Builder matchRule(String matchRule) {
            this.matchRule = matchRule;
            return this;
        }

        @Override
        public MatchGroup build() {
            return new MatchGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
