/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object containing <code>inputRecords</code>, <code>totalRecordsProcessed</code>, <code>matchIDs</code>, and
 * <code>recordsNotProcessed</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobMetrics implements SdkPojo, Serializable, ToCopyableBuilder<JobMetrics.Builder, JobMetrics> {
    private static final SdkField<Integer> INPUT_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("inputRecords").getter(getter(JobMetrics::inputRecords)).setter(setter(Builder::inputRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputRecords").build()).build();

    private static final SdkField<Integer> TOTAL_RECORDS_PROCESSED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalRecordsProcessed").getter(getter(JobMetrics::totalRecordsProcessed))
            .setter(setter(Builder::totalRecordsProcessed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalRecordsProcessed").build())
            .build();

    private static final SdkField<Integer> RECORDS_NOT_PROCESSED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("recordsNotProcessed").getter(getter(JobMetrics::recordsNotProcessed))
            .setter(setter(Builder::recordsNotProcessed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordsNotProcessed").build())
            .build();

    private static final SdkField<Integer> DELETE_RECORDS_PROCESSED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("deleteRecordsProcessed").getter(getter(JobMetrics::deleteRecordsProcessed))
            .setter(setter(Builder::deleteRecordsProcessed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteRecordsProcessed").build())
            .build();

    private static final SdkField<Integer> MATCH_I_DS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("matchIDs").getter(getter(JobMetrics::matchIDs)).setter(setter(Builder::matchIDs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchIDs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_RECORDS_FIELD,
            TOTAL_RECORDS_PROCESSED_FIELD, RECORDS_NOT_PROCESSED_FIELD, DELETE_RECORDS_PROCESSED_FIELD, MATCH_I_DS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer inputRecords;

    private final Integer totalRecordsProcessed;

    private final Integer recordsNotProcessed;

    private final Integer deleteRecordsProcessed;

    private final Integer matchIDs;

    private JobMetrics(BuilderImpl builder) {
        this.inputRecords = builder.inputRecords;
        this.totalRecordsProcessed = builder.totalRecordsProcessed;
        this.recordsNotProcessed = builder.recordsNotProcessed;
        this.deleteRecordsProcessed = builder.deleteRecordsProcessed;
        this.matchIDs = builder.matchIDs;
    }

    /**
     * <p>
     * The total number of input records.
     * </p>
     * 
     * @return The total number of input records.
     */
    public final Integer inputRecords() {
        return inputRecords;
    }

    /**
     * <p>
     * The total number of records processed.
     * </p>
     * 
     * @return The total number of records processed.
     */
    public final Integer totalRecordsProcessed() {
        return totalRecordsProcessed;
    }

    /**
     * <p>
     * The total number of records that did not get processed.
     * </p>
     * 
     * @return The total number of records that did not get processed.
     */
    public final Integer recordsNotProcessed() {
        return recordsNotProcessed;
    }

    /**
     * <p>
     * The number of records processed that were marked for deletion (<code>DELETE</code> = True) in the input file.
     * This metric tracks records flagged for removal during the job execution.
     * </p>
     * 
     * @return The number of records processed that were marked for deletion (<code>DELETE</code> = True) in the input
     *         file. This metric tracks records flagged for removal during the job execution.
     */
    public final Integer deleteRecordsProcessed() {
        return deleteRecordsProcessed;
    }

    /**
     * <p>
     * The total number of <code>matchID</code>s generated.
     * </p>
     * 
     * @return The total number of <code>matchID</code>s generated.
     */
    public final Integer matchIDs() {
        return matchIDs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputRecords());
        hashCode = 31 * hashCode + Objects.hashCode(totalRecordsProcessed());
        hashCode = 31 * hashCode + Objects.hashCode(recordsNotProcessed());
        hashCode = 31 * hashCode + Objects.hashCode(deleteRecordsProcessed());
        hashCode = 31 * hashCode + Objects.hashCode(matchIDs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobMetrics)) {
            return false;
        }
        JobMetrics other = (JobMetrics) obj;
        return Objects.equals(inputRecords(), other.inputRecords())
                && Objects.equals(totalRecordsProcessed(), other.totalRecordsProcessed())
                && Objects.equals(recordsNotProcessed(), other.recordsNotProcessed())
                && Objects.equals(deleteRecordsProcessed(), other.deleteRecordsProcessed())
                && Objects.equals(matchIDs(), other.matchIDs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobMetrics").add("InputRecords", inputRecords())
                .add("TotalRecordsProcessed", totalRecordsProcessed()).add("RecordsNotProcessed", recordsNotProcessed())
                .add("DeleteRecordsProcessed", deleteRecordsProcessed()).add("MatchIDs", matchIDs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inputRecords":
            return Optional.ofNullable(clazz.cast(inputRecords()));
        case "totalRecordsProcessed":
            return Optional.ofNullable(clazz.cast(totalRecordsProcessed()));
        case "recordsNotProcessed":
            return Optional.ofNullable(clazz.cast(recordsNotProcessed()));
        case "deleteRecordsProcessed":
            return Optional.ofNullable(clazz.cast(deleteRecordsProcessed()));
        case "matchIDs":
            return Optional.ofNullable(clazz.cast(matchIDs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("inputRecords", INPUT_RECORDS_FIELD);
        map.put("totalRecordsProcessed", TOTAL_RECORDS_PROCESSED_FIELD);
        map.put("recordsNotProcessed", RECORDS_NOT_PROCESSED_FIELD);
        map.put("deleteRecordsProcessed", DELETE_RECORDS_PROCESSED_FIELD);
        map.put("matchIDs", MATCH_I_DS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobMetrics, T> g) {
        return obj -> g.apply((JobMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobMetrics> {
        /**
         * <p>
         * The total number of input records.
         * </p>
         * 
         * @param inputRecords
         *        The total number of input records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputRecords(Integer inputRecords);

        /**
         * <p>
         * The total number of records processed.
         * </p>
         * 
         * @param totalRecordsProcessed
         *        The total number of records processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalRecordsProcessed(Integer totalRecordsProcessed);

        /**
         * <p>
         * The total number of records that did not get processed.
         * </p>
         * 
         * @param recordsNotProcessed
         *        The total number of records that did not get processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordsNotProcessed(Integer recordsNotProcessed);

        /**
         * <p>
         * The number of records processed that were marked for deletion (<code>DELETE</code> = True) in the input file.
         * This metric tracks records flagged for removal during the job execution.
         * </p>
         * 
         * @param deleteRecordsProcessed
         *        The number of records processed that were marked for deletion (<code>DELETE</code> = True) in the
         *        input file. This metric tracks records flagged for removal during the job execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteRecordsProcessed(Integer deleteRecordsProcessed);

        /**
         * <p>
         * The total number of <code>matchID</code>s generated.
         * </p>
         * 
         * @param matchIDs
         *        The total number of <code>matchID</code>s generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchIDs(Integer matchIDs);
    }

    static final class BuilderImpl implements Builder {
        private Integer inputRecords;

        private Integer totalRecordsProcessed;

        private Integer recordsNotProcessed;

        private Integer deleteRecordsProcessed;

        private Integer matchIDs;

        private BuilderImpl() {
        }

        private BuilderImpl(JobMetrics model) {
            inputRecords(model.inputRecords);
            totalRecordsProcessed(model.totalRecordsProcessed);
            recordsNotProcessed(model.recordsNotProcessed);
            deleteRecordsProcessed(model.deleteRecordsProcessed);
            matchIDs(model.matchIDs);
        }

        public final Integer getInputRecords() {
            return inputRecords;
        }

        public final void setInputRecords(Integer inputRecords) {
            this.inputRecords = inputRecords;
        }

        @Override
        public final Builder inputRecords(Integer inputRecords) {
            this.inputRecords = inputRecords;
            return this;
        }

        public final Integer getTotalRecordsProcessed() {
            return totalRecordsProcessed;
        }

        public final void setTotalRecordsProcessed(Integer totalRecordsProcessed) {
            this.totalRecordsProcessed = totalRecordsProcessed;
        }

        @Override
        public final Builder totalRecordsProcessed(Integer totalRecordsProcessed) {
            this.totalRecordsProcessed = totalRecordsProcessed;
            return this;
        }

        public final Integer getRecordsNotProcessed() {
            return recordsNotProcessed;
        }

        public final void setRecordsNotProcessed(Integer recordsNotProcessed) {
            this.recordsNotProcessed = recordsNotProcessed;
        }

        @Override
        public final Builder recordsNotProcessed(Integer recordsNotProcessed) {
            this.recordsNotProcessed = recordsNotProcessed;
            return this;
        }

        public final Integer getDeleteRecordsProcessed() {
            return deleteRecordsProcessed;
        }

        public final void setDeleteRecordsProcessed(Integer deleteRecordsProcessed) {
            this.deleteRecordsProcessed = deleteRecordsProcessed;
        }

        @Override
        public final Builder deleteRecordsProcessed(Integer deleteRecordsProcessed) {
            this.deleteRecordsProcessed = deleteRecordsProcessed;
            return this;
        }

        public final Integer getMatchIDs() {
            return matchIDs;
        }

        public final void setMatchIDs(Integer matchIDs) {
            this.matchIDs = matchIDs;
        }

        @Override
        public final Builder matchIDs(Integer matchIDs) {
            this.matchIDs = matchIDs;
            return this;
        }

        @Override
        public JobMetrics build() {
            return new JobMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
