/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that defines the list of matching rules to run in an ID mapping workflow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdMappingRuleBasedProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<IdMappingRuleBasedProperties.Builder, IdMappingRuleBasedProperties> {
    private static final SdkField<List<Rule>> RULES_FIELD = SdkField
            .<List<Rule>> builder(MarshallingType.LIST)
            .memberName("rules")
            .getter(getter(IdMappingRuleBasedProperties::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Rule> builder(MarshallingType.SDK_POJO)
                                            .constructor(Rule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RULE_DEFINITION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ruleDefinitionType").getter(getter(IdMappingRuleBasedProperties::ruleDefinitionTypeAsString))
            .setter(setter(Builder::ruleDefinitionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleDefinitionType").build())
            .build();

    private static final SdkField<String> ATTRIBUTE_MATCHING_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("attributeMatchingModel").getter(getter(IdMappingRuleBasedProperties::attributeMatchingModelAsString))
            .setter(setter(Builder::attributeMatchingModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeMatchingModel").build())
            .build();

    private static final SdkField<String> RECORD_MATCHING_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recordMatchingModel").getter(getter(IdMappingRuleBasedProperties::recordMatchingModelAsString))
            .setter(setter(Builder::recordMatchingModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordMatchingModel").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULES_FIELD,
            RULE_DEFINITION_TYPE_FIELD, ATTRIBUTE_MATCHING_MODEL_FIELD, RECORD_MATCHING_MODEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Rule> rules;

    private final String ruleDefinitionType;

    private final String attributeMatchingModel;

    private final String recordMatchingModel;

    private IdMappingRuleBasedProperties(BuilderImpl builder) {
        this.rules = builder.rules;
        this.ruleDefinitionType = builder.ruleDefinitionType;
        this.attributeMatchingModel = builder.attributeMatchingModel;
        this.recordMatchingModel = builder.recordMatchingModel;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rules property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The rules that can be used for ID mapping.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRules} method.
     * </p>
     * 
     * @return The rules that can be used for ID mapping.
     */
    public final List<Rule> rules() {
        return rules;
    }

    /**
     * <p>
     * The set of rules you can use in an ID mapping workflow. The limitations specified for the source or target to
     * define the match rules must be compatible.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #ruleDefinitionType} will return {@link IdMappingWorkflowRuleDefinitionType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #ruleDefinitionTypeAsString}.
     * </p>
     * 
     * @return The set of rules you can use in an ID mapping workflow. The limitations specified for the source or
     *         target to define the match rules must be compatible.
     * @see IdMappingWorkflowRuleDefinitionType
     */
    public final IdMappingWorkflowRuleDefinitionType ruleDefinitionType() {
        return IdMappingWorkflowRuleDefinitionType.fromValue(ruleDefinitionType);
    }

    /**
     * <p>
     * The set of rules you can use in an ID mapping workflow. The limitations specified for the source or target to
     * define the match rules must be compatible.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #ruleDefinitionType} will return {@link IdMappingWorkflowRuleDefinitionType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #ruleDefinitionTypeAsString}.
     * </p>
     * 
     * @return The set of rules you can use in an ID mapping workflow. The limitations specified for the source or
     *         target to define the match rules must be compatible.
     * @see IdMappingWorkflowRuleDefinitionType
     */
    public final String ruleDefinitionTypeAsString() {
        return ruleDefinitionType;
    }

    /**
     * <p>
     * The comparison type. You can either choose <code>ONE_TO_ONE</code> or <code>MANY_TO_MANY</code> as the
     * <code>attributeMatchingModel</code>.
     * </p>
     * <p>
     * If you choose <code>ONE_TO_ONE</code>, the system can only match attributes if the sub-types are an exact match.
     * For example, for the <code>Email</code> attribute type, the system will only consider it a match if the value of
     * the <code>Email</code> field of Profile A matches the value of the <code>Email</code> field of Profile B.
     * </p>
     * <p>
     * If you choose <code>MANY_TO_MANY</code>, the system can match attributes across the sub-types of an attribute
     * type. For example, if the value of the <code>Email</code> field of Profile A matches the value of the
     * <code>BusinessEmail</code> field of Profile B, the two profiles are matched on the <code>Email</code> attribute
     * type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #attributeMatchingModel} will return {@link AttributeMatchingModel#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #attributeMatchingModelAsString}.
     * </p>
     * 
     * @return The comparison type. You can either choose <code>ONE_TO_ONE</code> or <code>MANY_TO_MANY</code> as the
     *         <code>attributeMatchingModel</code>. </p>
     *         <p>
     *         If you choose <code>ONE_TO_ONE</code>, the system can only match attributes if the sub-types are an exact
     *         match. For example, for the <code>Email</code> attribute type, the system will only consider it a match
     *         if the value of the <code>Email</code> field of Profile A matches the value of the <code>Email</code>
     *         field of Profile B.
     *         </p>
     *         <p>
     *         If you choose <code>MANY_TO_MANY</code>, the system can match attributes across the sub-types of an
     *         attribute type. For example, if the value of the <code>Email</code> field of Profile A matches the value
     *         of the <code>BusinessEmail</code> field of Profile B, the two profiles are matched on the
     *         <code>Email</code> attribute type.
     * @see AttributeMatchingModel
     */
    public final AttributeMatchingModel attributeMatchingModel() {
        return AttributeMatchingModel.fromValue(attributeMatchingModel);
    }

    /**
     * <p>
     * The comparison type. You can either choose <code>ONE_TO_ONE</code> or <code>MANY_TO_MANY</code> as the
     * <code>attributeMatchingModel</code>.
     * </p>
     * <p>
     * If you choose <code>ONE_TO_ONE</code>, the system can only match attributes if the sub-types are an exact match.
     * For example, for the <code>Email</code> attribute type, the system will only consider it a match if the value of
     * the <code>Email</code> field of Profile A matches the value of the <code>Email</code> field of Profile B.
     * </p>
     * <p>
     * If you choose <code>MANY_TO_MANY</code>, the system can match attributes across the sub-types of an attribute
     * type. For example, if the value of the <code>Email</code> field of Profile A matches the value of the
     * <code>BusinessEmail</code> field of Profile B, the two profiles are matched on the <code>Email</code> attribute
     * type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #attributeMatchingModel} will return {@link AttributeMatchingModel#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #attributeMatchingModelAsString}.
     * </p>
     * 
     * @return The comparison type. You can either choose <code>ONE_TO_ONE</code> or <code>MANY_TO_MANY</code> as the
     *         <code>attributeMatchingModel</code>. </p>
     *         <p>
     *         If you choose <code>ONE_TO_ONE</code>, the system can only match attributes if the sub-types are an exact
     *         match. For example, for the <code>Email</code> attribute type, the system will only consider it a match
     *         if the value of the <code>Email</code> field of Profile A matches the value of the <code>Email</code>
     *         field of Profile B.
     *         </p>
     *         <p>
     *         If you choose <code>MANY_TO_MANY</code>, the system can match attributes across the sub-types of an
     *         attribute type. For example, if the value of the <code>Email</code> field of Profile A matches the value
     *         of the <code>BusinessEmail</code> field of Profile B, the two profiles are matched on the
     *         <code>Email</code> attribute type.
     * @see AttributeMatchingModel
     */
    public final String attributeMatchingModelAsString() {
        return attributeMatchingModel;
    }

    /**
     * <p>
     * The type of matching record that is allowed to be used in an ID mapping workflow.
     * </p>
     * <p>
     * If the value is set to <code>ONE_SOURCE_TO_ONE_TARGET</code>, only one record in the source can be matched to the
     * same record in the target.
     * </p>
     * <p>
     * If the value is set to <code>MANY_SOURCE_TO_ONE_TARGET</code>, multiple records in the source can be matched to
     * one record in the target.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #recordMatchingModel} will return {@link RecordMatchingModel#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #recordMatchingModelAsString}.
     * </p>
     * 
     * @return The type of matching record that is allowed to be used in an ID mapping workflow. </p>
     *         <p>
     *         If the value is set to <code>ONE_SOURCE_TO_ONE_TARGET</code>, only one record in the source can be
     *         matched to the same record in the target.
     *         </p>
     *         <p>
     *         If the value is set to <code>MANY_SOURCE_TO_ONE_TARGET</code>, multiple records in the source can be
     *         matched to one record in the target.
     * @see RecordMatchingModel
     */
    public final RecordMatchingModel recordMatchingModel() {
        return RecordMatchingModel.fromValue(recordMatchingModel);
    }

    /**
     * <p>
     * The type of matching record that is allowed to be used in an ID mapping workflow.
     * </p>
     * <p>
     * If the value is set to <code>ONE_SOURCE_TO_ONE_TARGET</code>, only one record in the source can be matched to the
     * same record in the target.
     * </p>
     * <p>
     * If the value is set to <code>MANY_SOURCE_TO_ONE_TARGET</code>, multiple records in the source can be matched to
     * one record in the target.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #recordMatchingModel} will return {@link RecordMatchingModel#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #recordMatchingModelAsString}.
     * </p>
     * 
     * @return The type of matching record that is allowed to be used in an ID mapping workflow. </p>
     *         <p>
     *         If the value is set to <code>ONE_SOURCE_TO_ONE_TARGET</code>, only one record in the source can be
     *         matched to the same record in the target.
     *         </p>
     *         <p>
     *         If the value is set to <code>MANY_SOURCE_TO_ONE_TARGET</code>, multiple records in the source can be
     *         matched to one record in the target.
     * @see RecordMatchingModel
     */
    public final String recordMatchingModelAsString() {
        return recordMatchingModel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ruleDefinitionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(attributeMatchingModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(recordMatchingModelAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdMappingRuleBasedProperties)) {
            return false;
        }
        IdMappingRuleBasedProperties other = (IdMappingRuleBasedProperties) obj;
        return hasRules() == other.hasRules() && Objects.equals(rules(), other.rules())
                && Objects.equals(ruleDefinitionTypeAsString(), other.ruleDefinitionTypeAsString())
                && Objects.equals(attributeMatchingModelAsString(), other.attributeMatchingModelAsString())
                && Objects.equals(recordMatchingModelAsString(), other.recordMatchingModelAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdMappingRuleBasedProperties").add("Rules", hasRules() ? rules() : null)
                .add("RuleDefinitionType", ruleDefinitionTypeAsString())
                .add("AttributeMatchingModel", attributeMatchingModelAsString())
                .add("RecordMatchingModel", recordMatchingModelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "rules":
            return Optional.ofNullable(clazz.cast(rules()));
        case "ruleDefinitionType":
            return Optional.ofNullable(clazz.cast(ruleDefinitionTypeAsString()));
        case "attributeMatchingModel":
            return Optional.ofNullable(clazz.cast(attributeMatchingModelAsString()));
        case "recordMatchingModel":
            return Optional.ofNullable(clazz.cast(recordMatchingModelAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("rules", RULES_FIELD);
        map.put("ruleDefinitionType", RULE_DEFINITION_TYPE_FIELD);
        map.put("attributeMatchingModel", ATTRIBUTE_MATCHING_MODEL_FIELD);
        map.put("recordMatchingModel", RECORD_MATCHING_MODEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdMappingRuleBasedProperties, T> g) {
        return obj -> g.apply((IdMappingRuleBasedProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdMappingRuleBasedProperties> {
        /**
         * <p>
         * The rules that can be used for ID mapping.
         * </p>
         * 
         * @param rules
         *        The rules that can be used for ID mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<Rule> rules);

        /**
         * <p>
         * The rules that can be used for ID mapping.
         * </p>
         * 
         * @param rules
         *        The rules that can be used for ID mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Rule... rules);

        /**
         * <p>
         * The rules that can be used for ID mapping.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.entityresolution.model.Rule.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.entityresolution.model.Rule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.entityresolution.model.Rule.Builder#build()} is called immediately and
         * its result is passed to {@link #rules(List<Rule>)}.
         * 
         * @param rules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.entityresolution.model.Rule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(java.util.Collection<Rule>)
         */
        Builder rules(Consumer<Rule.Builder>... rules);

        /**
         * <p>
         * The set of rules you can use in an ID mapping workflow. The limitations specified for the source or target to
         * define the match rules must be compatible.
         * </p>
         * 
         * @param ruleDefinitionType
         *        The set of rules you can use in an ID mapping workflow. The limitations specified for the source or
         *        target to define the match rules must be compatible.
         * @see IdMappingWorkflowRuleDefinitionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdMappingWorkflowRuleDefinitionType
         */
        Builder ruleDefinitionType(String ruleDefinitionType);

        /**
         * <p>
         * The set of rules you can use in an ID mapping workflow. The limitations specified for the source or target to
         * define the match rules must be compatible.
         * </p>
         * 
         * @param ruleDefinitionType
         *        The set of rules you can use in an ID mapping workflow. The limitations specified for the source or
         *        target to define the match rules must be compatible.
         * @see IdMappingWorkflowRuleDefinitionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdMappingWorkflowRuleDefinitionType
         */
        Builder ruleDefinitionType(IdMappingWorkflowRuleDefinitionType ruleDefinitionType);

        /**
         * <p>
         * The comparison type. You can either choose <code>ONE_TO_ONE</code> or <code>MANY_TO_MANY</code> as the
         * <code>attributeMatchingModel</code>.
         * </p>
         * <p>
         * If you choose <code>ONE_TO_ONE</code>, the system can only match attributes if the sub-types are an exact
         * match. For example, for the <code>Email</code> attribute type, the system will only consider it a match if
         * the value of the <code>Email</code> field of Profile A matches the value of the <code>Email</code> field of
         * Profile B.
         * </p>
         * <p>
         * If you choose <code>MANY_TO_MANY</code>, the system can match attributes across the sub-types of an attribute
         * type. For example, if the value of the <code>Email</code> field of Profile A matches the value of the
         * <code>BusinessEmail</code> field of Profile B, the two profiles are matched on the <code>Email</code>
         * attribute type.
         * </p>
         * 
         * @param attributeMatchingModel
         *        The comparison type. You can either choose <code>ONE_TO_ONE</code> or <code>MANY_TO_MANY</code> as the
         *        <code>attributeMatchingModel</code>. </p>
         *        <p>
         *        If you choose <code>ONE_TO_ONE</code>, the system can only match attributes if the sub-types are an
         *        exact match. For example, for the <code>Email</code> attribute type, the system will only consider it
         *        a match if the value of the <code>Email</code> field of Profile A matches the value of the
         *        <code>Email</code> field of Profile B.
         *        </p>
         *        <p>
         *        If you choose <code>MANY_TO_MANY</code>, the system can match attributes across the sub-types of an
         *        attribute type. For example, if the value of the <code>Email</code> field of Profile A matches the
         *        value of the <code>BusinessEmail</code> field of Profile B, the two profiles are matched on the
         *        <code>Email</code> attribute type.
         * @see AttributeMatchingModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttributeMatchingModel
         */
        Builder attributeMatchingModel(String attributeMatchingModel);

        /**
         * <p>
         * The comparison type. You can either choose <code>ONE_TO_ONE</code> or <code>MANY_TO_MANY</code> as the
         * <code>attributeMatchingModel</code>.
         * </p>
         * <p>
         * If you choose <code>ONE_TO_ONE</code>, the system can only match attributes if the sub-types are an exact
         * match. For example, for the <code>Email</code> attribute type, the system will only consider it a match if
         * the value of the <code>Email</code> field of Profile A matches the value of the <code>Email</code> field of
         * Profile B.
         * </p>
         * <p>
         * If you choose <code>MANY_TO_MANY</code>, the system can match attributes across the sub-types of an attribute
         * type. For example, if the value of the <code>Email</code> field of Profile A matches the value of the
         * <code>BusinessEmail</code> field of Profile B, the two profiles are matched on the <code>Email</code>
         * attribute type.
         * </p>
         * 
         * @param attributeMatchingModel
         *        The comparison type. You can either choose <code>ONE_TO_ONE</code> or <code>MANY_TO_MANY</code> as the
         *        <code>attributeMatchingModel</code>. </p>
         *        <p>
         *        If you choose <code>ONE_TO_ONE</code>, the system can only match attributes if the sub-types are an
         *        exact match. For example, for the <code>Email</code> attribute type, the system will only consider it
         *        a match if the value of the <code>Email</code> field of Profile A matches the value of the
         *        <code>Email</code> field of Profile B.
         *        </p>
         *        <p>
         *        If you choose <code>MANY_TO_MANY</code>, the system can match attributes across the sub-types of an
         *        attribute type. For example, if the value of the <code>Email</code> field of Profile A matches the
         *        value of the <code>BusinessEmail</code> field of Profile B, the two profiles are matched on the
         *        <code>Email</code> attribute type.
         * @see AttributeMatchingModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttributeMatchingModel
         */
        Builder attributeMatchingModel(AttributeMatchingModel attributeMatchingModel);

        /**
         * <p>
         * The type of matching record that is allowed to be used in an ID mapping workflow.
         * </p>
         * <p>
         * If the value is set to <code>ONE_SOURCE_TO_ONE_TARGET</code>, only one record in the source can be matched to
         * the same record in the target.
         * </p>
         * <p>
         * If the value is set to <code>MANY_SOURCE_TO_ONE_TARGET</code>, multiple records in the source can be matched
         * to one record in the target.
         * </p>
         * 
         * @param recordMatchingModel
         *        The type of matching record that is allowed to be used in an ID mapping workflow. </p>
         *        <p>
         *        If the value is set to <code>ONE_SOURCE_TO_ONE_TARGET</code>, only one record in the source can be
         *        matched to the same record in the target.
         *        </p>
         *        <p>
         *        If the value is set to <code>MANY_SOURCE_TO_ONE_TARGET</code>, multiple records in the source can be
         *        matched to one record in the target.
         * @see RecordMatchingModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordMatchingModel
         */
        Builder recordMatchingModel(String recordMatchingModel);

        /**
         * <p>
         * The type of matching record that is allowed to be used in an ID mapping workflow.
         * </p>
         * <p>
         * If the value is set to <code>ONE_SOURCE_TO_ONE_TARGET</code>, only one record in the source can be matched to
         * the same record in the target.
         * </p>
         * <p>
         * If the value is set to <code>MANY_SOURCE_TO_ONE_TARGET</code>, multiple records in the source can be matched
         * to one record in the target.
         * </p>
         * 
         * @param recordMatchingModel
         *        The type of matching record that is allowed to be used in an ID mapping workflow. </p>
         *        <p>
         *        If the value is set to <code>ONE_SOURCE_TO_ONE_TARGET</code>, only one record in the source can be
         *        matched to the same record in the target.
         *        </p>
         *        <p>
         *        If the value is set to <code>MANY_SOURCE_TO_ONE_TARGET</code>, multiple records in the source can be
         *        matched to one record in the target.
         * @see RecordMatchingModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordMatchingModel
         */
        Builder recordMatchingModel(RecordMatchingModel recordMatchingModel);
    }

    static final class BuilderImpl implements Builder {
        private List<Rule> rules = DefaultSdkAutoConstructList.getInstance();

        private String ruleDefinitionType;

        private String attributeMatchingModel;

        private String recordMatchingModel;

        private BuilderImpl() {
        }

        private BuilderImpl(IdMappingRuleBasedProperties model) {
            rules(model.rules);
            ruleDefinitionType(model.ruleDefinitionType);
            attributeMatchingModel(model.attributeMatchingModel);
            recordMatchingModel(model.recordMatchingModel);
        }

        public final List<Rule.Builder> getRules() {
            List<Rule.Builder> result = IdMappingRuleBasedPropertiesRulesListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<Rule.BuilderImpl> rules) {
            this.rules = IdMappingRuleBasedPropertiesRulesListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<Rule> rules) {
            this.rules = IdMappingRuleBasedPropertiesRulesListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Rule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<Rule.Builder>... rules) {
            rules(Stream.of(rules).map(c -> Rule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRuleDefinitionType() {
            return ruleDefinitionType;
        }

        public final void setRuleDefinitionType(String ruleDefinitionType) {
            this.ruleDefinitionType = ruleDefinitionType;
        }

        @Override
        public final Builder ruleDefinitionType(String ruleDefinitionType) {
            this.ruleDefinitionType = ruleDefinitionType;
            return this;
        }

        @Override
        public final Builder ruleDefinitionType(IdMappingWorkflowRuleDefinitionType ruleDefinitionType) {
            this.ruleDefinitionType(ruleDefinitionType == null ? null : ruleDefinitionType.toString());
            return this;
        }

        public final String getAttributeMatchingModel() {
            return attributeMatchingModel;
        }

        public final void setAttributeMatchingModel(String attributeMatchingModel) {
            this.attributeMatchingModel = attributeMatchingModel;
        }

        @Override
        public final Builder attributeMatchingModel(String attributeMatchingModel) {
            this.attributeMatchingModel = attributeMatchingModel;
            return this;
        }

        @Override
        public final Builder attributeMatchingModel(AttributeMatchingModel attributeMatchingModel) {
            this.attributeMatchingModel(attributeMatchingModel == null ? null : attributeMatchingModel.toString());
            return this;
        }

        public final String getRecordMatchingModel() {
            return recordMatchingModel;
        }

        public final void setRecordMatchingModel(String recordMatchingModel) {
            this.recordMatchingModel = recordMatchingModel;
        }

        @Override
        public final Builder recordMatchingModel(String recordMatchingModel) {
            this.recordMatchingModel = recordMatchingModel;
            return this;
        }

        @Override
        public final Builder recordMatchingModel(RecordMatchingModel recordMatchingModel) {
            this.recordMatchingModel(recordMatchingModel == null ? null : recordMatchingModel.toString());
            return this;
        }

        @Override
        public IdMappingRuleBasedProperties build() {
            return new IdMappingRuleBasedProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
